package com.ejianc.business.supbusiness.enums;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 自动称重枚举
 */
public enum AutomaticWeighEnums {

    开启自动称重(0, "开启自动称重"),
    关闭自动称重(1, "关闭自动称重");



    private Integer code;
    private String description;
    private static Map<Integer, AutomaticWeighEnums> enumMap;

    AutomaticWeighEnums(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(AutomaticWeighEnums.class).stream().collect(Collectors.toMap(AutomaticWeighEnums::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static AutomaticWeighEnums getEnumByCode(Integer code) {
        return enumMap.get(code);
    }
}
