package com.ejianc.business.supbusiness.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CheckStateEnum {
    待验收(0, "待验收"),
    部分验收(1, "部分验收"),
    已验收(2, "已验收");

    CheckStateEnum(Integer status, String statusName) {
        this.statusName = statusName;
        this.status = status;
    }

    private Integer status;
    private String statusName;
    private static Map<Integer, CheckStateEnum> enumMap = new HashMap();

    public String getStatusName() {
        return statusName;
    }

    public Integer getStatus() {
        return status;
    }


    public static CheckStateEnum getEnumByStatus(Integer status) {
        return (CheckStateEnum)enumMap.get(status);
    }

    static {
        enumMap = (Map) EnumSet.allOf(CheckStateEnum.class).stream().collect(Collectors.toMap(CheckStateEnum::getStatus, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
