package com.ejianc.business.supbusiness.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.vo.DeliveryVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 消耗材送货单
 *
 * @author generator
 */
public interface IDeliveryService extends IBaseService<DeliveryEntity> {

    /**
     * 查询送货单
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<DeliveryVO> queryDeliverList(QueryParam param);

    /**
     * 保存、修改送货单
     *
     * @param saveOrUpdateVO 送货单数据
     * @return 保存数据
     */
    DeliveryVO saveDeliver(DeliveryVO saveOrUpdateVO);

    /**
     * 变更送货单状态
     *
     * @param saveOrUpdateVO 需要变更的送货单信息
     * @return 变更结果
     */
    Boolean updateDeliverState(DeliveryVO saveOrUpdateVO);

    /**
     * 根据订单初始化送货单详情
     *
     * @param orderId 订单id
     * @return 送货单详情
     */
    DeliveryVO queryInitDelivery(Long orderId);

    /**
     * 根据orderId查询当前订单下已送货的材料数量
     *
     * @param orderId 订单id
     * @return 已送货材料数量
     */
    Map<Long, BigDecimal> sumDeliveredGroupByDetailId(Long orderId);

    /**
     * 处理终审后时间
     *
     * @param id 送货单id
     * @return 推送后数据
     */
    DeliveryVO saveCommitAfter(Long id);

    DeliveryVO updateWeighkey(Integer saveType, Long deliveryId);

    Boolean checkWeighkey(String weighkey);

    DeliveryVO getDetailByWeighkey(String weighkey);
}
