package com.ejianc.business.supbusiness.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.supbusiness.bean.OrderEntity;
import com.ejianc.business.supbusiness.vo.OrderVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

/**
 * 消耗材订单表
 *
 * @author generator
 */
public interface IOrderService extends IBaseService<OrderEntity> {

    /**
     * 保存施工方推送的订单数据
     *
     * @param request 施工方请求
     * @param file    文件信息
     * @return 保存结果
     */
    boolean saveOrder(HttpServletRequest request, MultipartFile file);

    /**
     * 查询待接收列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<OrderVO> queryOrderWaitList(QueryParam param);

    /**
     * 查询待送货列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<OrderVO> queryOrderDeliveredList(QueryParam param);

    /**
     * 接收、拒收订单
     *
     * @param saveOrUpdateVO 订单详情
     * @return 保存结果
     */
    OrderVO saveOrderDelivered(OrderVO saveOrUpdateVO);

    /**
     * 施工方撤回时删除订单
     *
     * @param vo 需要删除的订单
     * @return 删除结果
     */
    boolean deleteOrder(OrderVO vo);

    /**
     * 施工方关闭订单
     *
     * @param vo 需要关闭订单
     * @return 关闭订单
     */
    boolean updateOrderCloseFlag(OrderVO vo);

    /**
     * 查询订单明细及订单下的送货单
     *
     * @param id 订单
     * @return 查询订单
     */
    OrderVO queryOrderDetail(Long id);

    IPage<OrderVO> queryAllList(QueryParam param);
}
