package com.ejianc.business.supbusiness.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.supbusiness.bean.DeliveryCarEntity;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.mapper.DeliveryCarMapper;
import com.ejianc.business.supbusiness.service.IDeliveryCarService;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.vo.DeliveryCarVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 发货单车次
 *
 * @author generator
 *
 */
@Service("deliveryCarService")
public class DeliveryCarServiceImpl extends BaseServiceImpl<DeliveryCarMapper, DeliveryCarEntity> implements IDeliveryCarService{

    @Autowired
    private IDeliveryService deliveryService;

    @Override
    public DeliveryCarVO saveOrUpdate(DeliveryCarVO deliveryInfoCar) {
        if(null == deliveryInfoCar.getId()) {
            //修改重新计算重量
            DeliveryEntity delivery = deliveryService.selectById(deliveryInfoCar.getDeliveryId());
            deliveryInfoCar.setOrgId(delivery.getOrgId());
            deliveryInfoCar.setProjectId(delivery.getProjectId());
            deliveryInfoCar.setProjectName(delivery.getProjectName());
            deliveryInfoCar.setPlatformCode(delivery.getPlatformCode());
            //新增
            deliveryInfoCar.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        }
        DeliveryCarEntity entity = BeanMapper.map(deliveryInfoCar, DeliveryCarEntity.class);
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, DeliveryCarVO.class);
    }

    @Override
    public List<String> queryNumber(Long pkSupplier, String searchTaxt) {
        LambdaQueryWrapper<DeliveryCarEntity> entityWrapper = new LambdaQueryWrapper<DeliveryCarEntity>();
        entityWrapper.eq(DeliveryCarEntity::getSupplierId, pkSupplier);
        entityWrapper.like(StringUtils.isNoneBlank(searchTaxt), DeliveryCarEntity::getDeliveryCarNumber, searchTaxt);
        List<DeliveryCarEntity> deliveryInfoCars = list(entityWrapper);
        if (CollectionUtils.isNotEmpty(deliveryInfoCars)) {
            return deliveryInfoCars.stream().map(DeliveryCarEntity::getDeliveryCarNumber).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    @Override
    public List<DeliveryCarVO> queryDeliveryInfoCar(Long deliveryId, Long deliveryDetailId) {
        LambdaQueryWrapper<DeliveryCarEntity> entityWrapper = new LambdaQueryWrapper<DeliveryCarEntity>();
        entityWrapper.eq(DeliveryCarEntity::getDeliveryId, deliveryId);
        entityWrapper.eq(DeliveryCarEntity::getDeliveryDetailId, deliveryDetailId);
        List<DeliveryCarEntity> list = list(entityWrapper);
        return CollectionUtils.isNotEmpty(list) ? BeanMapper.mapList(list, DeliveryCarVO.class) : null;
    }

}
