package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.supbusiness.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.supbusiness.bean.MaterialPlanDetailEntity;
import com.ejianc.business.supbusiness.bean.MaterialPlanEntity;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.utils.ProMaterialFileUtils;
import com.ejianc.business.supbusiness.vo.DeliveryrecordVO;
import com.ejianc.business.supbusiness.vo.MaterialPlanVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supbusiness.mapper.DeliveryrecordMapper;
import com.ejianc.business.supbusiness.bean.DeliveryrecordEntity;
import com.ejianc.business.supbusiness.service.IDeliveryrecordService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 领料单-主表
 * 
 * @author generator
 * 
 */
@Service("deliveryrecordService")
public class DeliveryrecordServiceImpl extends BaseServiceImpl<DeliveryrecordMapper, DeliveryrecordEntity> implements IDeliveryrecordService{

    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * 单据类型
     */
    private static final String deliveryrecordBillType = "EJCBT202408000012";

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 上传文件单据类型
     */
    private static final String fileSourceType = "deliveryrecord";
    /** 订单接收推送施工方 */
    public static final String PUSH_DELIVERRRECORD_PLAN = "/ejc-zjkjmaterial-web/openapi/deliveryrecord/updateSignStatus";
    @Override
    public DeliveryrecordVO updateSignStatus(DeliveryrecordVO deliveryrecordVO) {
        DeliveryrecordEntity deliveryrecordEntity = super.selectById(deliveryrecordVO.getId());
        if (deliveryrecordEntity.getSignStatus() == 2){
            throw new BusinessException("已签字确认,请勿重复确认!");
        }

        logger.info("开始通知施工方签字单信息>>>>>>>>>>>>>>>>>>>");

        deliveryrecordEntity.setSignStatus(2);
        deliveryrecordEntity.setSupOperateTime(new Date());
        deliveryrecordEntity.setSupOperatorName(deliveryrecordVO.getSupOperatorName());
        deliveryrecordEntity.setSupOperatorPhone(deliveryrecordVO.getSupOperatorPhone());
        deliveryrecordEntity.setSupOperatorUserCode(deliveryrecordVO.getSupOperatorUserCode());
        Map<String, String> paramMap = new HashMap<>();

        paramMap.put("billId", CommonUtils.createString(deliveryrecordEntity.getSourceId()));
        paramMap.put("supOperatorName", CommonUtils.createString(deliveryrecordEntity.getSupOperatorName()));
        paramMap.put("supOperatorPhone", CommonUtils.createString(deliveryrecordEntity.getSupOperatorPhone()));
        paramMap.put("supOperatorUserCode", CommonUtils.createString(deliveryrecordEntity.getSupOperatorUserCode()));
        paramMap.put("supOperateTime", CommonUtils.createString(deliveryrecordEntity.getSupOperateTime().getTime()));

        // 查询文件信息
        //查询单据附件信息并下载
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(deliveryrecordEntity.getId(), deliveryrecordBillType, fileSourceType, null);
        if (!fileResp.isSuccess()) {
            throw new BusinessException("查询文件信息失败！");
        }
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        List<AttachmentVO> fileList = fileResp.getData();

        Map<String, String> fileSourceTypeMap = new HashMap<>();
        List<Long> fileIds = new ArrayList<>();

        //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
        for (AttachmentVO attach : fileList) {
            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
            fileIds.add(attach.getId());
        }
        paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
        //当前单据携带有附件信息
        if (CollectionUtils.isNotEmpty(fileList)) {
            Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
            fileMap.keySet().stream().forEach(fileKey -> {
                Map<String, InputStream> file = new HashMap<>(1);
                file.put(fileKey, fileMap.get(fileKey));
                files.put(fileKey, file);
            });
        }

        String systemId = deliveryrecordEntity.getSystemId();
        logger.info("发送参数===url:{},paramMap:[{}],systemId:{},files:{}", PUSH_DELIVERRRECORD_PLAN, paramMap, systemId, files);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataAndFilesWithThirdSystem(PUSH_DELIVERRRECORD_PLAN, paramMap, systemId, files);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        super.saveOrUpdate(deliveryrecordEntity, false);
        logger.info("通知施工方领料单信息结束<<<<<<<<<<<<<<<<<<<<<<");
        return BeanMapper.map(deliveryrecordEntity, DeliveryrecordVO.class);
    }

    @Override
    public Boolean delSupDeliveryRecord(DeliveryrecordVO vo) {
        logger.info("进入领料计划单撤回接口>>>>>>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (vo.getSourceId() == null) {
            throw new BusinessException("领料单不存在");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, vo.getSourceId()));
        List<DeliveryrecordEntity> materialPlanEntityList = super.queryList(queryParam,false);
        if (CollectionUtils.isEmpty(materialPlanEntityList)) {
            throw new BusinessException("领料单不存在");
        }
        DeliveryrecordEntity materialPlanEntity = materialPlanEntityList.get(0);
        if (vo.getSystemId() == null || !vo.getSystemId().equals(materialPlanEntity.getSystemId())) {
            throw new BusinessException("系统来源不匹配");
        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(materialPlanEntity.getId(), deliveryrecordBillType, null, null);
        // 查询成功并有相应的文件
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
                    .collect(Collectors.joining(","));
            attachmentApi.delete(ids);
        }
        boolean flag = super.removeById(materialPlanEntity.getId(), false);
        logger.info("领料计划撤回成功<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    /**
     * 保存施工方推送的领料单数据
     *
     * @param request 施工方请求
     * @param file    文件信息
     * @return 保存结果
     */
    @Override
    public Boolean saveDeliveryRecord(HttpServletRequest request, MultipartFile file) {
        logger.info("进入领料单保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        String plan = request.getParameter("deliveryrecord");
        logger.info("接收到数据：{}", plan);
        DeliveryrecordVO saveOrUpdateVO = JSON.parseObject(plan, new TypeReference<DeliveryrecordVO>() {
        });

        DeliveryrecordEntity entity = BeanMapper.map(saveOrUpdateVO, DeliveryrecordEntity.class);
        if (CollectionUtils.isEmpty(entity.getDeliveryrecorddetailEntityList())) {
            throw new BusinessException("材料列表不能为空！");
        }
//        // 查询是否存在相同sourceId的订单
//        Long sourceId = entity.getSourceId();
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
//        List<OrderEntity> orderEntityList = super.queryList(queryParam);
//        // 同一个订单重复推送，则是抛出异常
//        if (CollectionUtils.isNotEmpty(orderEntityList)) {
//            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(orderEntityList));
//            throw new BusinessException("该订单已在存在！");
//        }
        DeliveryrecordEntity materialPlanEntity = super.selectById(saveOrUpdateVO.getId());
        // 同一个订单重复推送，则是抛出异常
        if (null != materialPlanEntity) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(materialPlanEntity));
//            throw new BusinessException("订单已在存在！");
        }
        entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
//        entity.setReceiveState(OrderReceiveStateEnum.WAIT_RECEIVE.getCode());
        // 处理附件
        //保存单据中附件并获取到上传后附件的Id
        entity.setId(IdWorker.getId());
        List<DeliveryrecorddetailEntity> materialPlanDetailList = entity.getDeliveryrecorddetailEntityList();
        for (DeliveryrecorddetailEntity materialPlanDetailEntity : materialPlanDetailList){
            materialPlanDetailEntity.setSourceId(saveOrUpdateVO.getSourceId());
            materialPlanDetailEntity.setSourceDetailId(materialPlanDetailEntity.getId());
            materialPlanDetailEntity.setId(IdWorker.getId());
            materialPlanDetailEntity.setMid(entity.getId());
        }
        if (null != file) {
            // 供方id与施工方id相同，此时传入数据中存在id
            List<Long> attrs = ProMaterialFileUtils
                    .upFile("outType", entity.getId().toString(), deliveryrecordBillType, file, request, logger,
                            FileUtil.getInstance().getBaseHost());
            entity.setAttachIds(attrs);
        }
        boolean flag = super.saveOrUpdate(entity, false);
        logger.info("保存成功，领料单保存结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }
}
