package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.supbusiness.bean.MaterialPlanDetailEntity;
import com.ejianc.business.supbusiness.bean.MaterialPlanEntity;
import com.ejianc.business.supbusiness.mapper.MaterialPlanMapper;
import com.ejianc.business.supbusiness.service.IMaterialPlanService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.utils.ProMaterialFileUtils;
import com.ejianc.business.supbusiness.utils.SendMsgUtils;
import com.ejianc.business.supbusiness.vo.MaterialPlanVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 领料计划-主表
 *
 * @author generator
 */
@Service("materialPlanService")
public class MaterialPlanServiceImpl extends BaseServiceImpl<MaterialPlanMapper, MaterialPlanEntity> implements IMaterialPlanService {
    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * 单据类型
     */
    private static final String materialPlanBillType = "EJCBT202408000009";

    @Autowired
    private ISystemDataPushService systemDataPushService;

    /**
     * 上传文件单据类型
     */
    private static final String fileSourceType = "materialPlan";
    /**
     * 订单接收推送施工方
     */
    public static final String PUSH_MATERIAL_PLAN = "/zjkj-wzxt-web/openapi/materialPlan/updateSignStatus";

    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Value("${weixinMsg.planTmp}")
    private String WEIXIN_PLAN_TMP;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;


    /**
     * 保存施工方推送的领料计划数据
     *
     * @param request 施工方请求
     * @param file    文件信息
     * @return 保存结果
     */
    @Override
    public boolean savePlan(HttpServletRequest request, MultipartFile file) {
        logger.info("进入领料计划保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        String plan = request.getParameter("plan");
        logger.info("接收到数据：{}", plan);
        MaterialPlanVO saveOrUpdateVO = JSON.parseObject(plan, new TypeReference<MaterialPlanVO>() {
        });

        MaterialPlanEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialPlanEntity.class);
        if (CollectionUtils.isEmpty(entity.getMaterialPlanDetailList())) {
            throw new BusinessException("材料列表不能为空！");
        }
//        // 查询是否存在相同sourceId的订单
//        Long sourceId = entity.getSourceId();
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
//        List<OrderEntity> orderEntityList = super.queryList(queryParam);
//        // 同一个订单重复推送，则是抛出异常
//        if (CollectionUtils.isNotEmpty(orderEntityList)) {
//            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(orderEntityList));
//            throw new BusinessException("该订单已在存在！");
//        }
        MaterialPlanEntity materialPlanEntity = super.selectById(saveOrUpdateVO.getId());
        // 同一个订单重复推送，则是抛出异常
        if (null != materialPlanEntity) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(materialPlanEntity));
//            throw new BusinessException("订单已在存在！");
        }
        entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
//        entity.setReceiveState(OrderReceiveStateEnum.WAIT_RECEIVE.getCode());
        // 处理附件
        //保存单据中附件并获取到上传后附件的Id
        entity.setId(IdWorker.getId());
        List<MaterialPlanDetailEntity> materialPlanDetailList = entity.getMaterialPlanDetailList();
        for (MaterialPlanDetailEntity materialPlanDetailEntity : materialPlanDetailList) {
            materialPlanDetailEntity.setSourceId(saveOrUpdateVO.getSourceId());
            materialPlanDetailEntity.setSourceDetailId(materialPlanDetailEntity.getId());
            materialPlanDetailEntity.setId(IdWorker.getId());
            materialPlanDetailEntity.setPlanId(entity.getId());
        }
        if (null != file) {
            // 供方id与施工方id相同，此时传入数据中存在id
            List<Long> attrs = ProMaterialFileUtils
                    .upFile(fileSourceType, entity.getId().toString(), materialPlanBillType, file, request, logger,
                            FileUtil.getInstance().getBaseHost());
            entity.setAttachIds(attrs);
        }
        boolean flag = super.saveOrUpdate(entity, false);
        logger.info("保存成功，领料计划保存结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");

        sendWeChatMsg(entity);

        return flag;
    }

    /**
     * 发送微信消息
     */
    private void sendWeChatMsg(MaterialPlanEntity materialPlanEntity) {
        String systemId = materialPlanEntity.getSystemId();
        CommonResponse<Map<Long, List<Long>>> commonResponse = cooperateEnterpriseApi
                .getCooperateSupplierSuperUserIdByEnterpriseId(systemId);
        logger.info("{}查询供应商数据结果：{}", systemId, JSONObject.toJSONString(commonResponse));
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("查询供方列表失败！");
        }
        Map<Long, List<Long>> map = commonResponse.getData();

        if (map.isEmpty()) {
            logger.info("查询信息为空！");
            return;
        }
        logger.info("------开始发送微信消息----");
        logger.info("发送消息数量：{}；消息模板：{}", map.size(), WEIXIN_PLAN_TMP);
        // 循环处理发送消息
        for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
            Long tenantId = entry.getKey();
            List<Long> userLongList = entry.getValue();
            if (CollectionUtils.isEmpty(userLongList)) {
                logger.info("租户{}下查询用户为空", tenantId);
                continue;
            }
            String subject = "您有一条新的领料计划信息";
            String content = "领料计划编号：" + materialPlanEntity.getPlanCode() + "，项目名称：" + materialPlanEntity.getProjectName();
            HashMap<String, Object> weixinMap = new HashMap<>();
            String pcUrl = BASE_HOST + "zjkj-supbusiness-frontend/#/pickPlan/card?id=" + materialPlanEntity.getId();
            String mobileUrl = BASE_HOST + "zjkj-supbusiness-mobile/#/pickPlan/card?id=" + materialPlanEntity.getId() + "&userid={userid}";
            String wechatUrl = BASE_HOST + "zjkj-supbusiness-mobile/#/pickPlan/card?id=" + materialPlanEntity.getId() + "&openid={openid}";
            weixinMap.put("character_string2", materialPlanEntity.getPlanCode()); // 领用单号
            weixinMap.put("thing6", materialPlanEntity.getProjectName()); // 申请项目
            weixinMap.put("time17", new SimpleDateFormat("yyyy-MM-dd").format(materialPlanEntity.getPlanDate())); // 发布时间
            weixinMap.put("thing3", materialPlanEntity.getOperatorName()); // 申请人

            List<String> userList = userLongList.stream().map(String::valueOf).collect(Collectors.toList());

            new SendMsgUtils().sendWeiXinMsg(userList, subject, content, tenantId.toString(),
                    weixinMap, WEIXIN_PLAN_TMP, mobileUrl, pcUrl, wechatUrl, pushMessageApi);
        }
        logger.info("------发送微信消息结束----");
    }

    @Override
    public MaterialPlanVO updateSignStatus(MaterialPlanVO materialPlanVO) {
        MaterialPlanEntity materialPlanEntity = super.selectById(materialPlanVO.getId());
        if (materialPlanEntity.getSignStatus() == 2) {
            throw new BusinessException("已签字确认,请勿重复确认!");
        }

        logger.info("开始通知施工方签字单信息>>>>>>>>>>>>>>>>>>>");

        materialPlanEntity.setSignStatus(2);
        materialPlanEntity.setSupOperateTime(new Date());
        materialPlanEntity.setSupOperatorName(materialPlanVO.getSupOperatorName());
        materialPlanEntity.setSupOperatorPhone(materialPlanVO.getSupOperatorPhone());
        materialPlanEntity.setSupOperatorUserCode(materialPlanVO.getSupOperatorUserCode());
        Map<String, String> paramMap = new HashMap<>();

        paramMap.put("billId", CommonUtils.createString(materialPlanEntity.getSourceId()));
        paramMap.put("supOperatorName", CommonUtils.createString(materialPlanEntity.getSupOperatorName()));
        paramMap.put("supOperatorPhone", CommonUtils.createString(materialPlanEntity.getSupOperatorPhone()));
        paramMap.put("supOperatorUserCode", CommonUtils.createString(materialPlanEntity.getSupOperatorUserCode()));
        paramMap.put("supOperateTime", CommonUtils.createString(materialPlanEntity.getSupOperateTime().getTime()));

        // 查询文件信息
        //查询单据附件信息并下载
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(materialPlanEntity.getId(), materialPlanBillType, fileSourceType, null);
        if (!fileResp.isSuccess()) {
            throw new BusinessException("查询文件信息失败！");
        }
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        List<AttachmentVO> fileList = fileResp.getData();

        //Map<fileName, fileSourceType>
        Map<String, String> fileSourceTypeMap = new HashMap<>();
        List<Long> fileIds = new ArrayList<>();

        //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
        for (AttachmentVO attach : fileList) {
            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
            fileIds.add(attach.getId());
        }
        paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
        //当前单据携带有附件信息
        if (CollectionUtils.isNotEmpty(fileList)) {
            Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
            fileMap.keySet().stream().forEach(fileKey -> {
                Map<String, InputStream> file = new HashMap<>(1);
                file.put(fileKey, fileMap.get(fileKey));
                files.put(fileKey, file);
            });
        }

        String systemId = materialPlanEntity.getSystemId();
        logger.info("发送参数===url:{},paramMap:[{}],systemId:{},files:{}", PUSH_MATERIAL_PLAN, paramMap, systemId, files);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataAndFilesWithThirdSystem(PUSH_MATERIAL_PLAN, paramMap, systemId, files);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        super.saveOrUpdate(materialPlanEntity, false);
        logger.info("通知施工方领料计划单信息结束<<<<<<<<<<<<<<<<<<<<<<");
        return BeanMapper.map(materialPlanEntity, MaterialPlanVO.class);
    }


    /**
     * 删除领料计划
     *
     * @param vo 需要删除的领料计划
     * @return 删除结果
     */
    @Override
    public Boolean delSupPLan(MaterialPlanVO vo) {
        logger.info("进入领料计划单撤回接口>>>>>>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (vo.getSourceId() == null) {
            throw new BusinessException("领料计划不存在");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, vo.getSourceId()));
        List<MaterialPlanEntity> materialPlanEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(materialPlanEntityList)) {
            throw new BusinessException("领料计划不存在");
        }
        MaterialPlanEntity materialPlanEntity = materialPlanEntityList.get(0);
        if (vo.getSystemId() == null || !vo.getSystemId().equals(materialPlanEntity.getSystemId())) {
            throw new BusinessException("系统来源不匹配");
        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(materialPlanEntity.getId(), materialPlanBillType, null, null);
        // 查询成功并有相应的文件
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
                    .collect(Collectors.joining(","));
            attachmentApi.delete(ids);
        }
        boolean flag = super.removeById(materialPlanEntity.getId(), false);
        logger.info("领料计划撤回成功<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

}
