/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.DeliveryDetailEntity;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.bean.OrderDetailEntity;
import com.ejianc.business.supbusiness.bean.OrderEntity;
import com.ejianc.business.supbusiness.bean.WeighkeyRecordEntity;
import com.ejianc.business.supbusiness.enums.AutomaticWeighEnums;
import com.ejianc.business.supbusiness.enums.CloseFlagEnum;
import com.ejianc.business.supbusiness.enums.DeliverCheckStateEnum;
import com.ejianc.business.supbusiness.enums.OrderDeliverStateEnum;
import com.ejianc.business.supbusiness.mapper.DeliveryMapper;
import com.ejianc.business.supbusiness.service.IDeliveryDetailService;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.service.IOrderService;
import com.ejianc.business.supbusiness.service.IWeighkeyRecordService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.vo.DeliveryDbVO;
import com.ejianc.business.supbusiness.vo.DeliveryDetailDbVO;
import com.ejianc.business.supbusiness.vo.DeliveryDetailVO;
import com.ejianc.business.supbusiness.vo.DeliveryVO;
import com.ejianc.business.supbusiness.vo.OrderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZJKJ-SUP-DELIVERY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IWeighkeyRecordService weighkeyRecordService;
    private Lock lock = new ReentrantLock();

    @Override
    public IPage<DeliveryVO> queryDeliverList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("closeFlag")) {
            param.getParams().put("closeFlag", new Parameter("eq", (Object)CloseFlagEnum.NORMAL.getCode()));
        }
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("createTime", "desc");
        }
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        return pageData;
    }

    @Override
    public DeliveryVO saveDeliver(DeliveryVO saveOrUpdateVO) {
        List checkList;
        Long orderId = saveOrUpdateVO.getOrderId();
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(orderId));
        if (CloseFlagEnum.CLOSE.getCode().equals(orderEntity.getOrderFlag())) {
            throw new BusinessException("\u5f53\u524d\u8ba2\u5355\u5df2\u5173\u95ed\uff01");
        }
        QueryParam checkParam = new QueryParam();
        checkParam.getParams().put("orderId", new Parameter("eq", (Object)orderId));
        checkParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (saveOrUpdateVO.getId() != null) {
            checkParam.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkList = super.queryList(checkParam)))) {
            throw new BusinessException("\u5f53\u524d\u8ba2\u5355\u5b58\u5728\u672a\u751f\u6548\u7684\u9001\u8d27\u5355\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getDeliveryDetailList())) {
            throw new BusinessException("\u9001\u8d27\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List automaticWeighList = saveOrUpdateVO.getDeliveryDetailList().stream().filter(e -> !"del".equals(e.getRowState())).map(DeliveryDetailVO::getDetailAutomaticWeigh).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(automaticWeighList) && automaticWeighList.contains(AutomaticWeighEnums.\u5173\u95ed\u81ea\u52a8\u79f0\u91cd.getCode()) && automaticWeighList.contains(AutomaticWeighEnums.\u5f00\u542f\u81ea\u52a8\u79f0\u91cd.getCode())) {
            throw new BusinessException("\u9001\u8d27\u5355\u660e\u7ec6\u5fc5\u987b\u5168\u90e8\u662f\u81ea\u52a8\u79f0\u91cd\u6216\u5168\u90e8\u4e0d\u662f\u81ea\u52a8\u79f0\u91cd\u7684\u6750\u6599\uff0c\u4e0d\u80fd\u4e24\u8005\u6df7\u5408\u53d1\u8d27\uff01");
        }
        Integer automaticWeigh = CollectionUtils.isNotEmpty(automaticWeighList) ? (Integer)automaticWeighList.get(0) : AutomaticWeighEnums.\u5173\u95ed\u81ea\u52a8\u79f0\u91cd.getCode();
        saveOrUpdateVO.setAutomaticWeigh(automaticWeigh);
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeliveryEntity.class));
        entity.setPlatformCode(orderEntity.getPlatformCode());
        entity.setPlatformType(orderEntity.getPlatformType());
        entity.setLinkId(orderEntity.getLinkId());
        entity.setLinkName(orderEntity.getLinkName());
        entity.setOrderExpiryDate(orderEntity.getExpiryDate());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Map<Long, BigDecimal> receiveNumsSumMap = orderEntity.getOrderDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, OrderDetailEntity::getReceiveNumsSum));
        Map<Long, BigDecimal> map = this.sumDeliveredGroupByDetailId(orderId);
        ArrayList<String> nameList = new ArrayList<String>();
        for (DeliveryDetailEntity deliveryDetailEntity : entity.getDeliveryDetailList()) {
            BigDecimal shippedNumSum;
            Long orderDetailId = deliveryDetailEntity.getOrderDetailId();
            BigDecimal receiveNumsSum = receiveNumsSumMap.get(orderDetailId);
            BigDecimal notShippedNumSum = receiveNumsSum.subtract(shippedNumSum = CommonUtils.setBigDecimalDefaultValue(map.get(orderDetailId)).add(deliveryDetailEntity.getDeliveryNum()));
            if (notShippedNumSum.compareTo(BigDecimal.ZERO) < 0) {
                notShippedNumSum = BigDecimal.ZERO;
            }
            deliveryDetailEntity.setReceiveNumsSum(receiveNumsSum);
            deliveryDetailEntity.setShippedNumSum(shippedNumSum);
            deliveryDetailEntity.setNotShippedNumSum(notShippedNumSum);
            nameList.add(deliveryDetailEntity.getMaterialName());
        }
        entity.setMaterialName(StringUtils.join(nameList, (String)","));
        super.saveOrUpdate((Object)entity, false);
        return (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
    }

    @Override
    public Boolean updateDeliverState(DeliveryVO saveOrUpdateVO) {
        this.logger.info("\u8fdb\u5165\u9001\u8d27\u5355\u53d8\u66f4\u72b6\u6001\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO));
        if (null == saveOrUpdateVO.getSourceId()) {
            throw new BusinessException("\u9001\u8d27\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        DeliveryEntity entity = (DeliveryEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getSourceId()));
        if (null == entity) {
            throw new BusinessException("\u9001\u8d27\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (saveOrUpdateVO.getCheckStatus() == null && saveOrUpdateVO.getCloseFlag() == null) {
            throw new BusinessException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (saveOrUpdateVO.getCheckStatus() != null) {
            entity.setCheckStatus(saveOrUpdateVO.getCheckStatus());
        }
        if (saveOrUpdateVO.getCloseFlag() != null) {
            entity.setCloseFlag(saveOrUpdateVO.getCloseFlag());
        }
        boolean flag = super.saveOrUpdate((Object)entity, false);
        this.logger.info("\u9001\u8d27\u5355\u53d8\u66f4\u72b6\u6001\u63a5\u53e3\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    @Override
    public DeliveryVO queryInitDelivery(Long orderId) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(orderId));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(DeliveryEntity::getProjectId, (Object)orderEntity.getProjectId());
        queryWrapper.in(DeliveryEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(DeliveryEntity::getDeliverDate);
        queryWrapper.last("limit 1");
        DeliveryEntity lastDelivery = (DeliveryEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)orderEntity), DeliveryVO.class);
        vo.setOrderId(orderEntity.getId());
        vo.setOrderBillCode(orderEntity.getBillCode());
        vo.setEmployeeId(null);
        vo.setEmployeeName(null);
        vo.setDeliverName(null);
        vo.setDeliverPhone(null);
        vo.setArriveDate(null);
        vo.setLicensePlate(null);
        vo.setDepartmentId(null);
        vo.setDepartmentName(null);
        vo.setCloseFlag(null);
        vo.setId(null);
        vo.setCheckStatus(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        vo.setMemo(null);
        vo.setCloseFlag(CloseFlagEnum.NORMAL.getCode());
        vo.setArriveDate(new Date());
        vo.setDeliverAddress(null != lastDelivery ? lastDelivery.getDeliverAddress() : null);
        ArrayList<DeliveryDetailVO> list = new ArrayList<DeliveryDetailVO>();
        for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
            if (BigDecimal.ZERO.compareTo(CommonUtils.setBigDecimalDefaultValue(orderDetailEntity.getNotShippedNumSum())) >= 0) continue;
            DeliveryDetailVO detailVO = (DeliveryDetailVO)BeanMapper.map((Object)((Object)orderDetailEntity), DeliveryDetailVO.class);
            detailVO.setOrderId(orderDetailEntity.getOrderId());
            detailVO.setOrderDetailId(orderDetailEntity.getId());
            detailVO.setDeliveryNum(orderDetailEntity.getNotShippedNumSum());
            detailVO.setCheckNum(null);
            detailVO.setReceiveNumsSum(orderDetailEntity.getReceiveNumsSum());
            detailVO.setShippedNumSum(orderDetailEntity.getDeliverNumsSum());
            detailVO.setId(null);
            list.add(detailVO);
        }
        vo.setDeliveryDetailList(list);
        return vo;
    }

    @Override
    public Map<Long, BigDecimal> sumDeliveredGroupByDetailId(Long orderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter("eq", (Object)orderId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List deliveryList = super.queryList(queryParam);
        this.logger.info("\u5df2\u9001\u8d27\u7684\u9001\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)deliveryList));
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)deliveryList)) {
            ArrayList<Long> deliveryIdList = new ArrayList<Long>();
            for (DeliveryEntity entity : deliveryList) {
                deliveryIdList.add(entity.getId());
            }
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("deliveryId", new Parameter("in", deliveryIdList));
            List deliveryDetailList = this.deliveryDetailService.queryList(detailParam);
            for (DeliveryDetailEntity detail : deliveryDetailList) {
                Long orderDetailId = detail.getOrderDetailId();
                if (map.containsKey(orderDetailId)) {
                    BigDecimal sum = detail.getDeliveryNum().add((BigDecimal)map.get(orderDetailId));
                    map.put(orderDetailId, sum);
                    continue;
                }
                map.put(orderDetailId, detail.getDeliveryNum());
            }
        }
        return map;
    }

    @Override
    public DeliveryVO saveCommitAfter(Long id) {
        this.logger.info("\u8fdb\u5165\u63a8\u9001\u9001\u8d27\u5355\u65b9\u6cd5>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)super.selectById((Serializable)id));
        Long orderId = deliveryEntity.getOrderId();
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(orderId));
        if (CloseFlagEnum.CLOSE.getCode().equals(orderEntity.getOrderFlag())) {
            throw new BusinessException("\u8ba2\u5355\u5df2\u5173\u95ed\uff0c\u63d0\u4ea4\u5931\u8d25\uff01");
        }
        deliveryEntity.setCheckStatus(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        deliveryEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        super.saveOrUpdate((Object)deliveryEntity, false);
        Map<Long, BigDecimal> map = this.sumDeliveredGroupByDetailId(orderId);
        this.logger.info("\u5df2\u9001\u8d27\u6750\u6599\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(map));
        Integer orderDeliverState = OrderDeliverStateEnum.PART_DELIVERED.getCode();
        int fullFlag = 0;
        for (OrderDetailEntity entity : orderEntity.getOrderDetailList()) {
            if (BigDecimal.ZERO.compareTo(entity.getReceiveNumsSum()) == 0) {
                ++fullFlag;
                continue;
            }
            BigDecimal delivery = map.get(entity.getId());
            if (delivery == null) continue;
            entity.setDeliverNumsSum(delivery);
            if (delivery.compareTo(entity.getReceiveNumsSum()) > -1) {
                ++fullFlag;
                entity.setNotShippedNumSum(BigDecimal.ZERO);
                continue;
            }
            entity.setNotShippedNumSum(entity.getReceiveNumsSum().subtract(delivery));
        }
        if (fullFlag > 0 && fullFlag == orderEntity.getOrderDetailList().size()) {
            orderDeliverState = OrderDeliverStateEnum.FULL_DELIVERED.getCode();
        }
        if (!orderDeliverState.equals(orderEntity.getDeliverState()) && !OrderDeliverStateEnum.FULL_DELIVERED.getCode().equals(orderEntity.getDeliverState())) {
            orderEntity.setDeliverState(orderDeliverState);
        }
        this.orderService.saveOrUpdate((Object)orderEntity, false);
        this.logger.info("\u5269\u4f59\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)orderEntity)));
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u53d1\u8d27\u5355\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        String url = "/zjkj-wzxt-web/openapi/delivery/supplierPushDelivery";
        DeliveryDbVO tbVO = (DeliveryDbVO)BeanMapper.map((Object)((Object)deliveryEntity), DeliveryDbVO.class);
        tbVO.setSourceId(deliveryEntity.getId());
        tbVO.setMaterialDeliveryDetailList(null);
        if (CollectionUtils.isNotEmpty(deliveryEntity.getDeliveryDetailList())) {
            ArrayList<DeliveryDetailDbVO> tbVOList = new ArrayList<DeliveryDetailDbVO>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryEntity.getDeliveryDetailList()) {
                DeliveryDetailDbVO detailTbVO = (DeliveryDetailDbVO)BeanMapper.map((Object)((Object)deliveryDetailEntity), DeliveryDetailDbVO.class);
                detailTbVO.setSourceId(deliveryEntity.getId());
                detailTbVO.setSourceDetailId(deliveryDetailEntity.getId());
                tbVOList.add(detailTbVO);
            }
            tbVO.setMaterialDeliveryDetailList(tbVOList);
        }
        String postData = JSONObject.toJSONString((Object)tbVO);
        String systemId = deliveryEntity.getSystemId();
        this.logger.info("\u53d1\u9001\u53c2\u6570===url:{},postData:[{}],systemId:{}", new Object[]{url, postData, systemId});
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, this.logger);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u53d1\u8d27\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<");
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u8ba2\u5355\u9001\u8d27\u72b6\u6001>>>>>>>>>>>>>>>>>>>");
        String orderUrl = "/zjkj-wzxt-web/openapi/order/updateDeliver";
        OrderVO orderVO = new OrderVO();
        orderVO.setId(orderEntity.getId());
        orderVO.setDeliverState(orderEntity.getDeliverState());
        String orderPostData = JSONObject.toJSONString((Object)orderVO);
        CommonResponse orderCommonResponse = this.systemDataPushService.exchangeDataWithThirdSystem(orderUrl, RequestMethod.POST, orderPostData, systemId);
        CommonUtils.checkCommonResponse(orderCommonResponse, this.logger);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u8ba2\u5355\u9001\u8d27\u72b6\u6001\u7ed3\u675f<<<<<<<<<<<<<<<<<<<");
        this.logger.info("\u63a8\u9001\u9001\u8d27\u5355\u65b9\u6cd5\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        if (0 == deliveryEntity.getAutomaticWeigh()) {
            return this.updateWeighkey(1, deliveryEntity.getId());
        }
        return (DeliveryVO)BeanMapper.map((Object)((Object)deliveryEntity), DeliveryVO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeliveryVO updateWeighkey(Integer saveType, Long deliveryId) {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowDate = sdf.format(d);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        ((Calendar)calendar).add(10, 48);
        String endDate = sdf.format(calendar.getTime());
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.selectById(deliveryId));
        if (delivery.getAutomaticWeigh() == 1) {
            throw new BusinessException("\u975e\u667a\u80fd\u79f0\u91cd\u9879\u76ee\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u53e3\u4ee4");
        }
        if (saveType == 2) {
            delivery.setWeighkeyUnusedDate(nowDate);
            delivery.setWeighkey("");
        }
        WeighkeyRecordEntity weighkeyRecord = null;
        if (StringUtils.isNotEmpty((CharSequence)delivery.getWeighkey())) {
            weighkeyRecord = new WeighkeyRecordEntity();
            BeanUtils.copyProperties((Object)((Object)delivery), (Object)((Object)weighkeyRecord));
            weighkeyRecord.setDeliveryId(delivery.getId());
        }
        this.lock.lock();
        try {
            if (saveType == 1) {
                delivery.setWeighkeyCreateDate(nowDate);
                delivery.setWeighkeyUnusedDate(endDate);
                delivery.setPkWeighkeyCreator(String.valueOf(InvocationInfoProxy.getUserid()));
                Set<String> set = this.weighkeySet();
                String random = null;
                if (set.size() <= 10000) {
                    String ran;
                    while (set.contains(ran = String.format("%04d", (int)(Math.random() * 10000.0)))) {
                    }
                    random = ran;
                } else {
                    String ran;
                    while (set.contains(ran = DeliveryServiceImpl.getStringRandom(4))) {
                    }
                    random = ran;
                }
                delivery.setWeighkey(random);
            }
            ((DeliveryMapper)this.baseMapper).updateById((Object)delivery);
        }
        finally {
            this.lock.unlock();
        }
        if (null != weighkeyRecord) {
            this.weighkeyRecordService.saveOrUpdate((Object)weighkeyRecord);
        }
        return (DeliveryVO)BeanMapper.map((Object)((Object)delivery), DeliveryVO.class);
    }

    @Override
    public Boolean checkWeighkey(String weighkey) {
        List<String> pkList = ((DeliveryMapper)this.baseMapper).getListByWeighkey(weighkey);
        if (CollectionUtils.isEmpty(pkList)) {
            throw new BusinessException("\u53e3\u4ee4\u672a\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u53d1\u8d27\u65b9");
        }
        return true;
    }

    @Override
    public DeliveryVO getDetailByWeighkey(String weighkey) {
        this.checkWeighkey(weighkey);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(DeliveryEntity::getWeighkey, (Object)weighkey);
        queryWrapper.eq(DeliveryEntity::getCloseFlag, (Object)0);
        queryWrapper.le(DeliveryEntity::getWeighkeyCreateDate, (Object)this.getCurrDate());
        queryWrapper.ge(DeliveryEntity::getWeighkeyUnusedDate, (Object)this.getCurrDate());
        DeliveryEntity entity = (DeliveryEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
        if (null != entity) {
            return (DeliveryVO)BeanMapper.map((Object)this.selectById(entity.getId()), DeliveryVO.class);
        }
        return null;
    }

    private String getCurrDate() {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    public static String getStringRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    private Set<String> weighkeySet() {
        HashSet<String> usedWeighkeySet = null;
        List<String> list = ((DeliveryMapper)this.baseMapper).getUsedWeighkey();
        usedWeighkeySet = CollectionUtils.isNotEmpty(list) ? new HashSet<String>(list) : new HashSet();
        return usedWeighkeySet;
    }
}

