/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.supbusiness.bean.MaterialPlanDetailEntity;
import com.ejianc.business.supbusiness.bean.MaterialPlanEntity;
import com.ejianc.business.supbusiness.mapper.MaterialPlanMapper;
import com.ejianc.business.supbusiness.service.IMaterialPlanService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.utils.ProMaterialFileUtils;
import com.ejianc.business.supbusiness.utils.SendMsgUtils;
import com.ejianc.business.supbusiness.vo.MaterialPlanVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="materialPlanService")
public class MaterialPlanServiceImpl
extends BaseServiceImpl<MaterialPlanMapper, MaterialPlanEntity>
implements IMaterialPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String materialPlanBillType = "EJCBT202408000009";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String fileSourceType = "materialPlan";
    public static final String PUSH_MATERIAL_PLAN = "/zjkj-wzxt-web/openapi/materialPlan/updateSignStatus";
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${weixinMsg.planTmp}")
    private String WEIXIN_PLAN_TMP;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    @Override
    public boolean savePlan(HttpServletRequest request, MultipartFile file) {
        this.logger.info("\u8fdb\u5165\u9886\u6599\u8ba1\u5212\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String plan = request.getParameter("plan");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)plan);
        MaterialPlanVO saveOrUpdateVO = (MaterialPlanVO)JSON.parseObject((String)plan, (TypeReference)new TypeReference<MaterialPlanVO>(){}, (Feature[])new Feature[0]);
        MaterialPlanEntity entity = (MaterialPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialPlanEntity.class));
        if (CollectionUtils.isEmpty(entity.getMaterialPlanDetailList())) {
            throw new BusinessException("\u6750\u6599\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        MaterialPlanEntity materialPlanEntity = (MaterialPlanEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        if (null != materialPlanEntity) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)((Object)materialPlanEntity)));
        }
        entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        entity.setId(IdWorker.getId());
        List<MaterialPlanDetailEntity> materialPlanDetailList = entity.getMaterialPlanDetailList();
        for (MaterialPlanDetailEntity materialPlanDetailEntity : materialPlanDetailList) {
            materialPlanDetailEntity.setSourceId(saveOrUpdateVO.getSourceId());
            materialPlanDetailEntity.setSourceDetailId(materialPlanDetailEntity.getId());
            materialPlanDetailEntity.setId(IdWorker.getId());
            materialPlanDetailEntity.setPlanId(entity.getId());
        }
        if (null != file) {
            List<Long> attrs = ProMaterialFileUtils.upFile(fileSourceType, entity.getId().toString(), materialPlanBillType, file, request, this.logger, FileUtil.getInstance().getBaseHost());
            entity.setAttachIds(attrs);
        }
        boolean flag = super.saveOrUpdate((Object)entity, false);
        this.logger.info("\u4fdd\u5b58\u6210\u529f\uff0c\u9886\u6599\u8ba1\u5212\u4fdd\u5b58\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        this.sendWeChatMsg(entity);
        return flag;
    }

    private void sendWeChatMsg(MaterialPlanEntity materialPlanEntity) {
        String systemId = materialPlanEntity.getSystemId();
        CommonResponse commonResponse = this.cooperateEnterpriseApi.getCooperateSupplierSuperUserIdByEnterpriseId(systemId);
        this.logger.info("{}\u67e5\u8be2\u4f9b\u5e94\u5546\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)systemId, (Object)JSONObject.toJSONString((Object)commonResponse));
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u4f9b\u65b9\u5217\u8868\u5931\u8d25\uff01");
        }
        Map map = (Map)commonResponse.getData();
        if (map.isEmpty()) {
            this.logger.info("\u67e5\u8be2\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return;
        }
        this.logger.info("------\u5f00\u59cb\u53d1\u9001\u5fae\u4fe1\u6d88\u606f----");
        this.logger.info("\u53d1\u9001\u6d88\u606f\u6570\u91cf\uff1a{}\uff1b\u6d88\u606f\u6a21\u677f\uff1a{}", (Object)map.size(), (Object)this.WEIXIN_PLAN_TMP);
        for (Map.Entry entry : map.entrySet()) {
            Long tenantId = (Long)entry.getKey();
            List userLongList = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)userLongList)) {
                this.logger.info("\u79df\u6237{}\u4e0b\u67e5\u8be2\u7528\u6237\u4e3a\u7a7a", (Object)tenantId);
                continue;
            }
            String subject = "\u60a8\u6709\u4e00\u6761\u65b0\u7684\u9886\u6599\u8ba1\u5212\u4fe1\u606f";
            String content = "\u9886\u6599\u8ba1\u5212\u7f16\u53f7\uff1a" + materialPlanEntity.getPlanCode() + "\uff0c\u9879\u76ee\u540d\u79f0\uff1a" + materialPlanEntity.getProjectName();
            HashMap<String, Object> weixinMap = new HashMap<String, Object>();
            String pcUrl = this.BASE_HOST + "zjkj-supbusiness-frontend/#/pickPlan/card?id=" + materialPlanEntity.getId();
            String mobileUrl = this.BASE_HOST + "zjkj-supbusiness-mobile/#/pickPlan/card?id=" + materialPlanEntity.getId() + "&userid={userid}";
            String wechatUrl = this.BASE_HOST + "zjkj-supbusiness-mobile/#/pickPlan/card?id=" + materialPlanEntity.getId() + "&openid={openid}";
            weixinMap.put("character_string2", materialPlanEntity.getPlanCode());
            weixinMap.put("thing6", materialPlanEntity.getProjectName());
            weixinMap.put("time17", new SimpleDateFormat("yyyy-MM-dd").format(materialPlanEntity.getPlanDate()));
            weixinMap.put("thing3", materialPlanEntity.getOperatorName());
            List<String> userList = userLongList.stream().map(String::valueOf).collect(Collectors.toList());
            new SendMsgUtils().sendWeiXinMsg(userList, subject, content, tenantId.toString(), weixinMap, this.WEIXIN_PLAN_TMP, mobileUrl, pcUrl, wechatUrl, this.pushMessageApi);
        }
        this.logger.info("------\u53d1\u9001\u5fae\u4fe1\u6d88\u606f\u7ed3\u675f----");
    }

    @Override
    public MaterialPlanVO updateSignStatus(MaterialPlanVO materialPlanVO) {
        MaterialPlanEntity materialPlanEntity = (MaterialPlanEntity)((Object)super.selectById((Serializable)materialPlanVO.getId()));
        if (materialPlanEntity.getSignStatus() == 2) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u786e\u8ba4,\u8bf7\u52ff\u91cd\u590d\u786e\u8ba4!");
        }
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u7b7e\u5b57\u5355\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        materialPlanEntity.setSignStatus(2);
        materialPlanEntity.setSupOperateTime(new Date());
        materialPlanEntity.setSupOperatorName(materialPlanVO.getSupOperatorName());
        materialPlanEntity.setSupOperatorPhone(materialPlanVO.getSupOperatorPhone());
        materialPlanEntity.setSupOperatorUserCode(materialPlanVO.getSupOperatorUserCode());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("billId", CommonUtils.createString(materialPlanEntity.getSourceId()));
        paramMap.put("supOperatorName", CommonUtils.createString(materialPlanEntity.getSupOperatorName()));
        paramMap.put("supOperatorPhone", CommonUtils.createString(materialPlanEntity.getSupOperatorPhone()));
        paramMap.put("supOperatorUserCode", CommonUtils.createString(materialPlanEntity.getSupOperatorUserCode()));
        paramMap.put("supOperateTime", CommonUtils.createString(materialPlanEntity.getSupOperateTime().getTime()));
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(materialPlanEntity.getId(), materialPlanBillType, fileSourceType, null);
        if (!fileResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashMap files = new HashMap();
        List fileList = (List)fileResp.getData();
        HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
        ArrayList<Long> fileIds = new ArrayList<Long>();
        for (AttachmentVO attach : fileList) {
            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
            fileIds.add(attach.getId());
        }
        paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
            Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
            fileMap.keySet().stream().forEach(fileKey -> {
                HashMap file = new HashMap(1);
                file.put((String)fileKey, fileMap.get(fileKey));
                files.put(fileKey, file);
            });
        }
        String systemId = materialPlanEntity.getSystemId();
        this.logger.info("\u53d1\u9001\u53c2\u6570===url:{},paramMap:[{}],systemId:{},files:{}", new Object[]{PUSH_MATERIAL_PLAN, paramMap, systemId, files});
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataAndFilesWithThirdSystem(PUSH_MATERIAL_PLAN, paramMap, systemId, files);
        CommonUtils.checkCommonResponse(commonResponse, this.logger);
        super.saveOrUpdate((Object)materialPlanEntity, false);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u9886\u6599\u8ba1\u5212\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<");
        return (MaterialPlanVO)BeanMapper.map((Object)((Object)materialPlanEntity), MaterialPlanVO.class);
    }

    @Override
    public Boolean delSupPLan(MaterialPlanVO vo) {
        this.logger.info("\u8fdb\u5165\u9886\u6599\u8ba1\u5212\u5355\u64a4\u56de\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (vo.getSourceId() == null) {
            throw new BusinessException("\u9886\u6599\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("eq", (Object)vo.getSourceId()));
        List materialPlanEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)materialPlanEntityList)) {
            throw new BusinessException("\u9886\u6599\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        MaterialPlanEntity materialPlanEntity = (MaterialPlanEntity)((Object)materialPlanEntityList.get(0));
        if (vo.getSystemId() == null || !vo.getSystemId().equals(materialPlanEntity.getSystemId())) {
            throw new BusinessException("\u7cfb\u7edf\u6765\u6e90\u4e0d\u5339\u914d");
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(materialPlanEntity.getId(), materialPlanBillType, null, null);
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.info("\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)fileResp.getData()));
            String ids = ((List)fileResp.getData()).stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
            this.attachmentApi.delete(ids);
        }
        boolean flag = super.removeById((Serializable)materialPlanEntity.getId(), false);
        this.logger.info("\u9886\u6599\u8ba1\u5212\u64a4\u56de\u6210\u529f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }
}

