/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.OrderDetailEntity;
import com.ejianc.business.supbusiness.mapper.OrderDetailMapper;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.service.IOrderDetailService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.vo.OrderDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderDetailService")
public class OrderDetailServiceImpl
extends BaseServiceImpl<OrderDetailMapper, OrderDetailEntity>
implements IOrderDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeliveryService deliveryService;

    @Override
    public boolean deleteOrderDetailByOrderId(Long orderId) {
        return ((OrderDetailMapper)this.baseMapper).deleteOrderDetailByOrderId(orderId);
    }

    @Override
    public IPage<OrderDetailVO> refMaterialOrderDetailData(Integer pageNumber, Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List list = param.getFuzzyFields();
        list.add("materialName");
        list.add("materialTypeName");
        list.add("spec");
        list.add("materialCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orderId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            _con = JSONObject.parseObject((String)condition);
            if (!_con.containsKey((Object)"orderId")) {
                this.logger.error("orderId\u662f\u5fc5\u4f20\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                throw new BusinessException("\u67e5\u8be2\u53c2\u7167\u5931\u8d25\uff01");
            }
        } else {
            this.logger.error("orderId\u662f\u5fc5\u4f20\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("\u67e5\u8be2\u53c2\u7167\u5931\u8d25\uff01");
        }
        orderId = Long.valueOf(_con.get((Object)"orderId").toString());
        param.getParams().put("orderId", new Parameter("eq", (Object)orderId));
        param.getParams().put("notShippedNumSum", new Parameter("gt", (Object)BigDecimal.ZERO));
        param.getOrderMap().put("notShippedNumSum", "desc");
        IPage page = super.queryPage(param, false);
        List detailEntityList = page.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            Map<Long, BigDecimal> deliveryMap = this.deliveryService.sumDeliveredGroupByDetailId(orderId);
            for (OrderDetailEntity orderDetailEntity : detailEntityList) {
                orderDetailEntity.setNotShippedNumSum(orderDetailEntity.getReceiveNumsSum().subtract(CommonUtils.setBigDecimalDefaultValue(deliveryMap.get(orderDetailEntity.getId()))));
            }
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderDetailVO.class));
        return pageData;
    }
}

