/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbusiness.bean.DeliveryCarEntity;
import com.ejianc.business.supbusiness.bean.DeliveryDetailEntity;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.bean.WeighApplyEntity;
import com.ejianc.business.supbusiness.mapper.WeighApplyMapper;
import com.ejianc.business.supbusiness.service.IDeliveryCarService;
import com.ejianc.business.supbusiness.service.IDeliveryDetailService;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.service.IWeighApplyService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.vo.DeliveryCarVO;
import com.ejianc.business.supbusiness.vo.WeighApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="weighApplyService")
public class WeighApplyServiceImpl
extends BaseServiceImpl<WeighApplyMapper, WeighApplyEntity>
implements IWeighApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IDeliveryCarService deliveryCarService;

    @Override
    public WeighApplyVO saveOrUpdate(WeighApplyVO saveOrUpdateVO) {
        WeighApplyEntity entity = this.fullAddData(saveOrUpdateVO);
        entity.setId(IdWorker.getId());
        entity.setApplyDate(new Date());
        entity.setOtherId(entity.getDeliveryId() + "@@" + entity.getDeliveryDetailId() + "@@" + entity.getId() + "@@" + entity.getMaterialId());
        this.saveOrUpdate((Object)entity);
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u8fc7\u78c5\u7533\u8bf7\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        String url = "/zjkj-wzxt-web/openapi/weighApply/saveOrUpdate";
        WeighApplyVO tbVO = (WeighApplyVO)((Object)BeanMapper.map((Object)((Object)entity), WeighApplyVO.class));
        String postData = JSONObject.toJSONString((Object)((Object)tbVO));
        String systemId = entity.getSystemId();
        this.logger.info("\u53d1\u9001\u53c2\u6570===url:{},postData:[{}],systemId:{}", new Object[]{url, postData, systemId});
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, this.logger);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u53d1\u8d27\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<");
        return (WeighApplyVO)((Object)BeanMapper.map((Object)((Object)entity), WeighApplyVO.class));
    }

    @Override
    public WeighApplyVO addyzPCWeighApply(DeliveryCarVO deliveryCarVO) {
        WeighApplyEntity entity = this.fullPcAddData(deliveryCarVO);
        entity.setId(IdWorker.getId());
        entity.setApplyDate(new Date());
        entity.setOtherId(entity.getDeliveryId() + "@@" + entity.getDeliveryDetailId() + "@@" + entity.getId() + "@@" + entity.getMaterialId());
        this.saveOrUpdate((Object)entity);
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u8fc7\u78c5\u7533\u8bf7\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        String url = "/zjkj-wzxt-web/openapi/weighApply/saveOrUpdate";
        WeighApplyVO tbVO = (WeighApplyVO)((Object)BeanMapper.map((Object)((Object)entity), WeighApplyVO.class));
        tbVO.setPcCarInfoFlag(true);
        String postData = JSONObject.toJSONString((Object)((Object)tbVO));
        String systemId = entity.getSystemId();
        this.logger.info("\u53d1\u9001\u53c2\u6570===url:{},postData:[{}],systemId:{}", new Object[]{url, postData, systemId});
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, this.logger);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u53d1\u8d27\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<");
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(DeliveryCarEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        updateWrapper.set(DeliveryCarEntity::getWeighApplyId, (Object)entity.getId());
        updateWrapper.eq(BaseEntity::getId, (Object)deliveryCarVO.getId());
        this.deliveryCarService.update((Wrapper)updateWrapper);
        return (WeighApplyVO)((Object)BeanMapper.map((Object)((Object)entity), WeighApplyVO.class));
    }

    @Override
    public List<String> queryCarNumRecord(String openid) {
        return ((WeighApplyMapper)this.baseMapper).queryCarNumRecord(openid);
    }

    @Override
    public WeighApplyVO queryLastDetail(String openid) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(WeighApplyEntity::getOpenid, (Object)openid);
        queryWrapper.orderByDesc(WeighApplyEntity::getApplyDate);
        queryWrapper.last("limit 1");
        WeighApplyEntity weighApplyEntity = (WeighApplyEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
        return null != weighApplyEntity ? (WeighApplyVO)((Object)BeanMapper.map((Object)((Object)weighApplyEntity), WeighApplyVO.class)) : null;
    }

    @Override
    public WeighApplyVO testPush(Long id) {
        WeighApplyEntity entity = (WeighApplyEntity)((Object)this.selectById(id));
        entity.setSystemId(((DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()))).getSystemId());
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u8fc7\u78c5\u7533\u8bf7\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        String url = "/zjkj-wzxt-web/openapi/weighApply/saveOrUpdate";
        WeighApplyVO tbVO = (WeighApplyVO)((Object)BeanMapper.map((Object)((Object)entity), WeighApplyVO.class));
        String postData = JSONObject.toJSONString((Object)((Object)tbVO));
        String systemId = entity.getSystemId();
        this.logger.info("\u53d1\u9001\u53c2\u6570===url:{},postData:[{}],systemId:{}", new Object[]{url, postData, systemId});
        CommonResponse commonResponse = this.systemDataPushService.exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, this.logger);
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u53d1\u8d27\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<");
        return (WeighApplyVO)((Object)BeanMapper.map((Object)((Object)entity), WeighApplyVO.class));
    }

    private WeighApplyEntity fullPcAddData(DeliveryCarVO deliveryCarVO) {
        WeighApplyEntity entity = new WeighApplyEntity();
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.selectById(deliveryCarVO.getDeliveryId()));
        BeanUtils.copyProperties((Object)((Object)delivery), (Object)((Object)entity));
        DeliveryCarEntity deliveryInfoCar = (DeliveryCarEntity)((Object)this.deliveryCarService.selectById(deliveryCarVO.getDeliveryDetailId()));
        BeanUtils.copyProperties((Object)((Object)deliveryInfoCar), (Object)((Object)entity));
        entity.setMaterialAmount(deliveryInfoCar.getMaterialAmount());
        entity.setCarNumber(deliveryInfoCar.getDeliveryCarNumber());
        entity.setUpdateUserCode(null);
        entity.setUpdateTime(null);
        entity.setSystemId(delivery.getSystemId());
        return entity;
    }

    private WeighApplyEntity fullAddData(WeighApplyVO weighApplyVO) {
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.selectById(weighApplyVO.getDeliveryId()));
        WeighApplyEntity entity = new WeighApplyEntity();
        BeanUtils.copyProperties((Object)((Object)delivery), (Object)((Object)entity));
        entity.setDeliveryDetailId(weighApplyVO.getDeliveryDetailId());
        entity.setOpenid(weighApplyVO.getOpenid());
        entity.setCarNumber(weighApplyVO.getCarNumber());
        entity.setCarSerial(weighApplyVO.getCarSerial());
        entity.setSystemId(delivery.getSystemId());
        DeliveryDetailEntity deliveryInfo = (DeliveryDetailEntity)((Object)this.deliveryDetailService.selectById(entity.getDeliveryDetailId()));
        BeanUtils.copyProperties((Object)((Object)deliveryInfo), (Object)((Object)entity));
        entity.setUpdateUserCode(null);
        entity.setUpdateTime(null);
        return entity;
    }
}

