package com.ejianc.business.weigh.weighbill.api;

import com.ejianc.business.weigh.weighbill.hystrix.IWeighBillHystrix;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(
        name = "ejc-weigh-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-weigh-web",
        fallback = IWeighBillHystrix.class
)
public interface IWeighbillApi {

    /**
     *
     * 查询磅单信息
     */
    @RequestMapping(
            value = {"/api/weighbill/queryWeighbills"},
            method = {RequestMethod.GET}
    )
    CommonResponse<List<WeighbillVO>> queryWeighbills(@RequestParam("projectId") Long projectId,@RequestParam("weighIds") List<Long> weighIds);
    /**
     * 更新磅单验收状态
     *
     */
    @RequestMapping(
            value = {"/api/weighbill/updateWeighbills"},
            method = {RequestMethod.POST}
    )
    CommonResponse<String> updateWeighbills(@RequestBody List<WeighbillVO> weighbillVOList);


    /**
     *
     * 查询磅单数量
     */
    @RequestMapping(
            value = {"/api/weighbill/queryWeighBydeliveryId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<List<WeighbillVO>> queryWeighBydeliveryId(@RequestParam("deliveryIds") List<Long> deliveryIds);

}
