package com.ejianc.business.weigh.wagon.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 地磅类别集成
 *
 * @author generator
 *
 */
@ApiModel("地磅类别集成")
public class WagonIntegrateVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("地磅类别")
    private String wagonType;
    @ApiModelProperty("地磅类别名称")
    private String wagonTypeName;
    @ApiModelProperty("实现接口（多个用逗号隔开）")
    private String realizationInterface;
    @ApiModelProperty("实现类（多个用逗号隔开）")
    private String realizationClass;
    private Integer weighType; // 过磅类型（1-二维码  2-车牌识别）
    /**
     * 过磅申请发起接口（二维码过磅，会返回二维码）
     */
    private String weighApplyInterface;

    /**
     * 称重二维码状态查询接口，用于二维码过磅获取状态
     */
    private String weighQrcodeStatusInterface;

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 地磅类别
     */
    public String getWagonType() {
        return wagonType;
    }

    /**
     * 地磅类别
     */
    public void setWagonType(String wagonType) {
        this.wagonType = wagonType;
    }
    /**
     * 地磅类别名称
     */
    public String getWagonTypeName() {
        return wagonTypeName;
    }

    /**
     * 地磅类别名称
     */
    public void setWagonTypeName(String wagonTypeName) {
        this.wagonTypeName = wagonTypeName;
    }
    /**
     * 实现接口（多个用逗号隔开）
     */
    public String getRealizationInterface() {
        return realizationInterface;
    }

    /**
     * 实现接口（多个用逗号隔开）
     */
    public void setRealizationInterface(String realizationInterface) {
        this.realizationInterface = realizationInterface;
    }
    /**
     * 实现类（多个用逗号隔开）
     */
    public String getRealizationClass() {
        return realizationClass;
    }

    /**
     * 实现类（多个用逗号隔开）
     */
    public void setRealizationClass(String realizationClass) {
        this.realizationClass = realizationClass;
    }

    public Integer getWeighType() {
        return weighType;
    }

    public void setWeighType(Integer weighType) {
        this.weighType = weighType;
    }

    public String getWeighApplyInterface() {
        return weighApplyInterface;
    }

    public void setWeighApplyInterface(String weighApplyInterface) {
        this.weighApplyInterface = weighApplyInterface;
    }

    public String getWeighQrcodeStatusInterface() {
        return weighQrcodeStatusInterface;
    }

    public void setWeighQrcodeStatusInterface(String weighQrcodeStatusInterface) {
        this.weighQrcodeStatusInterface = weighQrcodeStatusInterface;
    }
}
