package com.ejianc.business.weigh.wagon.api;

import com.ejianc.business.weigh.wagon.hystrix.IWagonMaterialHystrix;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.business.weigh.wagon.vo.WagonProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(
        name = "zjkj-weigh-web",
        url = "${common.env.feign-client-url}",
        path = "zjkj-weigh-web",
        fallback = IWagonMaterialHystrix.class
)
public interface IWagonMaterialApi {

    /**
     * 查询项目下材料自动称重设置，本上查询，查询最近的设置
     *
     * @param projectId  项目id
     * @param materialId 材料id
     * @return 查询结果，如果未设置，返回空对象
     */
    @RequestMapping(
            value = {"/api/wagonMaterial/queryMaterialAutomaticWeigh"},
            method = {RequestMethod.GET}
    )
    CommonResponse<WagonMaterialVO> queryMaterialAutomaticWeigh(@RequestParam("projectId") Long projectId,
                                                                  @RequestParam("materialId") Long materialId);
    /**
     * 查询项目下材料自动称重设置，本上查询，查询最近的设置
     *
     * @param projectId  项目id
     * @param materialIdList 材料id集合
     * @return 查询结果，如果未设置，返回空集合
     */
    @RequestMapping(
            value = {"/api/wagonMaterial/queryMaterialAutomaticWeighList"},
            method = {RequestMethod.GET}
    )
    CommonResponse<List<WagonMaterialVO>> queryMaterialAutomaticWeighList(@RequestParam("projectId") Long projectId,
                                                                @RequestParam("materialIdList")  List<Long> materialIdList);

    /**
     * 查询项目下材料自动称重设置，本上查询，查询最近的设置
     *
     * @return 查询结果，如果未设置，返回空集合
     */
    @RequestMapping(
            value = {"/api/wagonMaterial/queryWeighTypeList"},
            method = {RequestMethod.POST}
    )
    CommonResponse<List<WagonMaterialVO>> queryWeighTypeList(@RequestBody WagonMaterialVO wagonMaterialVO);


    @RequestMapping(
            value = {"/api/wagonMaterial/queryProjConfig"},
            method = {RequestMethod.GET}
    )
    CommonResponse<WagonProjectVO> queryProjConfig(@RequestParam("projectId") Long projectId);
}
