/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;

public class YzSignUtils {
    private static final String CHARSET_UTF8 = "utf-8";

    public static String signRequest(Map<String, String> headers, String secret) throws IOException {
        Object[] keys = headers.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            String value = headers.get(key);
            if (!YzSignUtils.isNotEmpty((String)key) || !YzSignUtils.isNotEmpty(value)) continue;
            query.append("&").append((String)key).append("=").append(value);
        }
        query.append("&appsecret=").append(secret);
        String data = query.toString().substring(1).toLowerCase();
        byte[] bytes = YzSignUtils.encryptMD5(data);
        return YzSignUtils.byte2hex(bytes);
    }

    private static byte[] encryptMD5(String data) throws IOException {
        return YzSignUtils.encryptMD5(data.getBytes(CHARSET_UTF8));
    }

    private static byte[] encryptMD5(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    private static boolean isNotEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

