/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.weighbill.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.pub.RestMethods;
import com.ejianc.business.weigh.util.YzSignUtils;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.mapper.WeighbillMapper;
import com.ejianc.business.weigh.weighbill.service.IPushDataToThirdService;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.business.weigh.weighbill.vo.WeighApplyThirdVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service(value="pushDataToYzService")
public class PushDataToYzServiceImpl
extends BaseServiceImpl<WeighbillMapper, WeighbillEntity>
implements IPushDataToThirdService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String APPID = "RS_WJ_20211215";
    private static final String APPSECRET = "b1f974165e89c6ba80996c59894ce3dc";
    private RestTemplate restTemplate;

    public RestTemplate getRestTemplate() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
        }
        return this.restTemplate;
    }

    @Override
    public CommonResponse<String> pushDataToThird(DeliveryThirdVO deliveryThirdVO) {
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f");
    }

    @Override
    public CommonResponse<String> pushApplyToThird(WeighApplyThirdVO weighApply) {
        if (StringUtils.isBlank((CharSequence)weighApply.getPlatformCode())) {
            this.logger.error("\u8fc7\u78c5\u9879\u76ee\u7f16\u53f7\u4e3a\u7a7a");
            return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f");
        }
        JSONObject suppRequest = new JSONObject();
        suppRequest.put("thirdId", (Object)weighApply.getSupplierId());
        suppRequest.put("supplierName", (Object)weighApply.getSupplierName());
        suppRequest.put("contactName", null);
        suppRequest.put("contactPhone", null);
        suppRequest.put("contactMobilePhone", null);
        suppRequest.put("memo", null);
        suppRequest.put("supplierType", (Object)1);
        JSONObject prodRequest = new JSONObject();
        prodRequest.put("thirdId", (Object)weighApply.getMaterialId());
        prodRequest.put("productName", (Object)weighApply.getMaterialName());
        prodRequest.put("productModel", (Object)weighApply.getSpec());
        prodRequest.put("brandName", null);
        prodRequest.put("unitName", (Object)weighApply.getUnit());
        JSONArray prodList = new JSONArray();
        prodList.add((Object)prodRequest);
        JSONObject thirdInfo = new JSONObject();
        thirdInfo.put("supplier", (Object)suppRequest);
        thirdInfo.put("productList", (Object)prodList);
        JSONObject productRequest = new JSONObject();
        productRequest.put("usingSite", (Object)(weighApply.getMaterialName() + weighApply.getSpec()));
        productRequest.put("deliveryUnitName", (Object)"\u5428");
        productRequest.put("deliveryQuantity", (Object)weighApply.getMaterialAmount());
        productRequest.put("thirdProductId", (Object)weighApply.getMaterialId());
        JSONArray productList = new JSONArray();
        productList.add((Object)productRequest);
        JSONObject carRequest = new JSONObject();
        carRequest.put("carNumber", (Object)weighApply.getCarNumber());
        carRequest.put("productList", (Object)productList);
        JSONArray carList = new JSONArray();
        carList.add((Object)carRequest);
        JSONObject yzRequest = new JSONObject();
        yzRequest.put("thirdInfo", (Object)thirdInfo);
        yzRequest.put("thirdId", (Object)weighApply.getOtherId());
        yzRequest.put("deliveryDate", (Object)this.getCurrDate());
        yzRequest.put("projectSysNo", (Object)weighApply.getPlatformCode());
        yzRequest.put("orderSysNo", (Object)0);
        yzRequest.put("memo", (Object)weighApply.getSupplierName());
        yzRequest.put("thirdSupplierId", (Object)weighApply.getSupplierId());
        yzRequest.put("deliveryReceiptCarDetailList", (Object)carList);
        RestMethods restMethods = new RestMethods(this.getRestTemplate());
        JSONObject result = restMethods.postForYz(weighApply.getWeighApplyInterface(), yzRequest, this.getSign(yzRequest), APPID);
        return CommonResponse.success((String)result.getJSONObject("data").getString("deliveryReceiptCode"));
    }

    private String getSign(JSONObject applyRequest) {
        HashMap signHeader = Maps.newHashMap();
        signHeader.put("AppId", APPID);
        signHeader.put("Data", applyRequest.toJSONString());
        try {
            return YzSignUtils.signRequest(signHeader, APPSECRET);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    private String getCurrDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -30);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(calendar.getTime());
    }
}

