/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.weighbill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.bean.WeighbillImgEntity;
import com.ejianc.business.weigh.weighbill.mapper.WeighbillMapper;
import com.ejianc.business.weigh.weighbill.service.IWeighbillImgService;
import com.ejianc.business.weigh.weighbill.service.IWeighbillService;
import com.ejianc.business.weigh.weighbill.vo.DelWeighbillVO;
import com.ejianc.business.weigh.weighbill.vo.PushWeighbillVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

@Service(value="weighbillService")
public class WeighbillServiceImpl
extends BaseServiceImpl<WeighbillMapper, WeighbillEntity>
implements IWeighbillService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZJKJ-BOUND";
    private static final String BILL_TYPE = "EJCBT202407000007";
    private final String[] ALLOW_WEIGH_UNIT = new String[]{"\u5343\u514b", "\u516c\u65a4", "KG", "kg", "Kg", "T", "t", "\u5428"};
    private static final String PZ_SOURCETYPE = "pz_image";
    private static final String MZ_SOURCETYPE = "mz_image";
    @Autowired
    private IWeighbillImgService weighbillImgService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CommonResponse<String> saveWeigh(PushWeighbillVO weighVO) {
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        String sourceId = weighVO.getLpId();
        return CommonResponse.success((String)"\u6570\u636e\u63a8\u9001\u6210\u529f");
    }

    @Override
    public CommonResponse<String> deleteWeigh(DelWeighbillVO weighVO) {
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        WeighbillEntity weighEntity = (WeighbillEntity)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"third_weigh_id", (Object)weighVO.getThirdWeighId())).eq((Object)"source_system", (Object)weighVO.getSourceSystem())));
        if (null == weighEntity) {
            return CommonResponse.error((String)"\u8be5\u6570\u636e\u5728PM\u7cfb\u7edf\u672a\u88ab\u67e5\u8be2\u5230,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        if (null != weighEntity && null != weighEntity.getCheckId()) {
            return CommonResponse.error((String)"\u8be5\u6570\u636ePM\u7cfb\u7edf\u5df2\u88ab\u9a8c\u6536,\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c!");
        }
        super.removeById((Serializable)weighEntity.getId());
        return CommonResponse.success((String)"\u6570\u636e\u5220\u9664\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveWeighImgs(PushWeighbillVO weighVO) {
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        WeighbillEntity weighEntity = (WeighbillEntity)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"third_weigh_id", (Object)weighVO.getThirdWeighId())).eq((Object)"source_system", (Object)weighVO.getSource())));
        this.weighbillImgService.remove((Wrapper)new QueryWrapper().eq((Object)"weight_id", (Object)weighEntity.getId()));
        weighVO.setId(weighEntity.getId());
        weighVO.setId(weighEntity.getId());
        this.uploadImg(weighVO);
        this.uploadDetailImg(weighVO);
        return CommonResponse.success((String)"\u540c\u6b65\u78c5\u5355\u56fe\u7247\u6210\u529f");
    }

    public String uploadImg(PushWeighbillVO weighbillVO) {
        List imgVOList = weighbillVO.getWeighImgs();
        if (CollectionUtils.isNotEmpty((Collection)imgVOList)) {
            ArrayList list;
            AttachmentRequestVO attachmentVO;
            ArrayList mzListBase64 = new ArrayList();
            ArrayList mzList = new ArrayList();
            ArrayList pzListBase64 = new ArrayList();
            ArrayList pzList = new ArrayList();
            imgVOList.forEach(e -> {
                if (1 == e.getImageType()) {
                    if (this.isImageFromBase64(e.getImage())) {
                        mzListBase64.add(e.getImage());
                    } else {
                        mzList.add(e.getImage());
                    }
                } else if (2 == e.getImageType()) {
                    if (this.isImageFromBase64(e.getImage())) {
                        pzListBase64.add(e.getImage());
                    } else {
                        pzList.add(e.getImage());
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(mzListBase64)) {
                attachmentVO = new AttachmentRequestVO();
                attachmentVO.setBillType(BILL_TYPE);
                attachmentVO.setSourceId(weighbillVO.getId().toString());
                attachmentVO.setSourceType(MZ_SOURCETYPE);
                attachmentVO.setHandleImg(Boolean.valueOf(false));
                attachmentVO.setClearBeforeSave(Boolean.valueOf(false));
                attachmentVO.setFileList(mzListBase64);
                this.attachmentApi.uploadForBase64(attachmentVO);
            }
            if (CollectionUtils.isNotEmpty(pzListBase64)) {
                attachmentVO = new AttachmentRequestVO();
                attachmentVO.setBillType(BILL_TYPE);
                attachmentVO.setSourceId(weighbillVO.getId().toString());
                attachmentVO.setSourceType(PZ_SOURCETYPE);
                attachmentVO.setHandleImg(Boolean.valueOf(false));
                attachmentVO.setClearBeforeSave(Boolean.valueOf(false));
                attachmentVO.setFileList(pzListBase64);
                this.attachmentApi.uploadForBase64(attachmentVO);
            }
            if (CollectionUtils.isNotEmpty(mzList)) {
                list = new ArrayList();
                mzList.forEach(e -> {
                    AttachmentVO attachmentVO = new AttachmentVO();
                    attachmentVO.setBillType(BILL_TYPE);
                    attachmentVO.setSourceId(weighbillVO.getId());
                    attachmentVO.setSourceType(MZ_SOURCETYPE);
                    attachmentVO.setFilePath(e);
                    attachmentVO.setOnlinePath(e);
                    list.add(attachmentVO);
                });
                this.attachmentApi.insertBatch(list);
            }
            if (CollectionUtils.isNotEmpty(pzList)) {
                list = new ArrayList();
                pzList.forEach(e -> {
                    AttachmentVO attachmentVO = new AttachmentVO();
                    attachmentVO.setBillType(BILL_TYPE);
                    attachmentVO.setSourceId(weighbillVO.getId());
                    attachmentVO.setSourceType(PZ_SOURCETYPE);
                    attachmentVO.setFilePath(e);
                    attachmentVO.setOnlinePath(e);
                    list.add(attachmentVO);
                });
                this.attachmentApi.insertBatch(list);
            }
        }
        return "";
    }

    private boolean isImageFromBase64(String base64Str) {
        String[] baseStrs = base64Str.split(",");
        String base64 = baseStrs.length > 1 ? baseStrs[1] : baseStrs[0];
        boolean flag = false;
        try {
            BufferedImage bufImg = ImageIO.read(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(base64)));
            if (null == bufImg) {
                return flag;
            }
            flag = true;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return flag;
    }

    public String uploadDetailImg(PushWeighbillVO weighbillVO) {
        List imgVOList = weighbillVO.getWeighImgs();
        ArrayList imgEntities = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)imgVOList)) {
            imgVOList.forEach(e -> {
                WeighbillImgEntity weighbillImgEntity = (WeighbillImgEntity)((Object)((Object)BeanMapper.map((Object)e, WeighbillImgEntity.class)));
                weighbillImgEntity.setThirdWeighId(weighbillVO.getThirdWeighId());
                weighbillImgEntity.setSourceSystem(weighbillVO.getSource());
                weighbillImgEntity.setWeightId(weighbillVO.getId());
                imgEntities.add(weighbillImgEntity);
            });
            this.weighbillImgService.saveOrUpdateBatch(imgEntities);
        }
        return "";
    }
}

