/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.wagon.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.weigh.wagon.bean.WagonProjectEntity;
import com.ejianc.business.weigh.wagon.service.IWagonMaterialService;
import com.ejianc.business.weigh.wagon.service.IWagonProjectService;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.business.weigh.wagon.vo.WagonProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/wagonMaterial/"})
public class WagonMaterialApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWagonMaterialService service;
    @Autowired
    private IWagonProjectService wagonProjectService;

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\uff0c\u672c\u4e0a\u67e5\u8be2\uff0c\u67e5\u8be2\u6700\u8fd1\u7684\u8bbe\u7f6e")
    @RequestMapping(value={"/queryMaterialAutomaticWeigh"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WagonMaterialVO> queryMaterialAutomaticWeigh(@RequestParam(value="projectId") Long projectId, @RequestParam(value="materialId") Long materialId) {
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\uff0c\u9879\u76eeid\uff1a{}\uff0c\u6750\u6599id\uff1a{}", (Object)projectId, (Object)materialId);
        WagonMaterialVO vo = this.service.queryMaterialAutomaticWeigh(projectId, materialId);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\uff0c\u672c\u4e0a\u67e5\u8be2\uff0c\u67e5\u8be2\u6700\u8fd1\u7684\u8bbe\u7f6e-\u96c6\u5408")
    @RequestMapping(value={"/queryMaterialAutomaticWeighList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<WagonMaterialVO>> queryMaterialAutomaticWeighList(@RequestParam(value="projectId") Long projectId, @RequestParam(value="materialIdList") List<Long> materialIdList) {
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\uff0c\u9879\u76eeid\uff1a{}\uff0c\u6750\u6599id\uff1a{}", (Object)projectId, materialIdList);
        List<WagonMaterialVO> voList = this.service.queryMaterialAutomaticWeighList(projectId, materialIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(voList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", voList);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\uff0c\u672c\u4e0a\u67e5\u8be2\uff0c\u67e5\u8be2\u6700\u8fd1\u7684\u8bbe\u7f6e-\u96c6\u5408")
    @RequestMapping(value={"/queryWeighTypeList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<WagonMaterialVO>> queryWeighTypeList(@RequestBody WagonMaterialVO wagonMaterialVO) {
        List<WagonMaterialVO> voList = this.service.queryMaterialAutomaticWeighList(wagonMaterialVO.getProjectId(), wagonMaterialVO.getMaterialIdList());
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(voList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", voList);
    }

    @RequestMapping(value={"/queryProjConfig"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WagonProjectVO> queryProjConfig(@RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(WagonProjectEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(WagonProjectEntity::getStartFlag, (Object)0);
        WagonProjectEntity projectEntity = (WagonProjectEntity)((Object)this.wagonProjectService.getOne((Wrapper)queryWrapper, false));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", null != projectEntity ? (WagonProjectVO)BeanMapper.map((Object)((Object)projectEntity), WagonProjectVO.class) : null);
    }
}

