/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.weighbill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.bean.WeighbillImgEntity;
import com.ejianc.business.weigh.weighbill.mapper.WeighbillMapper;
import com.ejianc.business.weigh.weighbill.service.IWeighbillImgService;
import com.ejianc.business.weigh.weighbill.service.IWeighbillService;
import com.ejianc.business.weigh.weighbill.vo.DelWeighbillVO;
import com.ejianc.business.weigh.weighbill.vo.PushWeighbillVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.wzxt.delivery.api.IDeliveryApi;
import com.ejianc.wzxt.delivery.vo.DeliveryDetailVO;
import com.ejianc.wzxt.delivery.vo.DeliveryVO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

@Service(value="weighbillService")
public class WeighbillServiceImpl
extends BaseServiceImpl<WeighbillMapper, WeighbillEntity>
implements IWeighbillService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZJKJ-BOUND";
    private static final String BILL_TYPE = "EJCBT202407000007";
    private final String[] ALLOW_WEIGH_UNIT = new String[]{"\u5343\u514b", "\u516c\u65a4", "KG", "kg", "Kg", "T", "t", "\u5428"};
    private static final String PZ_SOURCETYPE = "pz_image";
    private static final String MZ_SOURCETYPE = "mz_image";
    @Autowired
    private IDeliveryApi deliveryApi;
    @Autowired
    private IWeighbillImgService weighbillImgService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CommonResponse<String> saveWeigh(PushWeighbillVO weighVO) {
        HashSet<String> set;
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        String sourceId = weighVO.getLpId();
        String[] ids = sourceId.split("@@");
        String deriveryId = "";
        String deriveryDetailId = "";
        if (!"".equals(ids) && ids.length > 0) {
            deriveryId = ids[0];
            deriveryDetailId = ids[1];
        }
        if (!(set = new HashSet<String>(Arrays.asList(this.ALLOW_WEIGH_UNIT))).contains(weighVO.getWeightUnit())) {
            return CommonResponse.error((String)"\u91cd\u91cf\u5355\u4f4d\u4e0d\u5408\u6cd5!");
        }
        CommonResponse commonResponse = this.deliveryApi.queryDeliveryByDetailSrcId(Long.valueOf(deriveryDetailId));
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)"PM\u67e5\u8be2\u6570\u636e\u5f02\u5e38,\u6570\u636e\u63a8\u9001\u5931\u8d25!");
        }
        DeliveryVO deliveryVO = (DeliveryVO)commonResponse.getData();
        if (null == deliveryVO || null == deliveryVO.getDeliveryDetailList() || deliveryVO.getDeliveryDetailList().size() <= 0) {
            return CommonResponse.error((String)"PM\u7cfb\u7edf\u672a\u67e5\u8be2\u5230\u6750\u6599\u4fe1\u606f,\u8bf7\u786e\u8ba4\u6570\u636e\u53c2\u6570\u5408\u6cd5\u6027!");
        }
        WeighbillEntity weighEntityDB = (WeighbillEntity)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"third_weigh_id", (Object)weighVO.getThirdWeighId())).eq((Object)"source", (Object)weighVO.getSource())));
        if (null != weighEntityDB) {
            if (null != weighEntityDB.getCheckId()) {
                return CommonResponse.error((String)"\u8be5\u6570\u636ePM\u7cfb\u7edf\u5df2\u88ab\u9a8c\u6536,\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c!");
            }
            super.removeById((Serializable)weighEntityDB.getId());
        }
        WeighbillEntity weighEntity = (WeighbillEntity)((Object)BeanMapper.map((Object)weighVO, WeighbillEntity.class));
        if (StringUtils.isEmpty((CharSequence)weighVO.getWeightCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)weighVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                weighEntity.setWeightCode((String)billCode.getData());
            } else {
                this.logger.info("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                return CommonResponse.error((String)"PM\u751f\u6210\u78c5\u5355\u7f16\u53f7\u5f02\u5e38,\u6570\u636e\u63a8\u9001\u5931\u8d25!");
            }
        }
        weighEntity = this.changeVo(weighEntity, deliveryVO, weighVO, deriveryDetailId);
        super.saveOrUpdate((Object)weighEntity, false);
        weighVO.setId(weighEntity.getId());
        this.uploadImg(weighVO);
        this.uploadDetailImg(weighVO);
        return CommonResponse.success((String)"\u6570\u636e\u63a8\u9001\u6210\u529f");
    }

    @Override
    public CommonResponse<String> deleteWeigh(DelWeighbillVO weighVO) {
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        WeighbillEntity weighEntity = (WeighbillEntity)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"third_weigh_id", (Object)weighVO.getThirdWeighId())).eq((Object)"source_system", (Object)weighVO.getSourceSystem())));
        if (null == weighEntity) {
            return CommonResponse.error((String)"\u8be5\u6570\u636e\u5728PM\u7cfb\u7edf\u672a\u88ab\u67e5\u8be2\u5230,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        if (null != weighEntity && null != weighEntity.getCheckId()) {
            return CommonResponse.error((String)"\u8be5\u6570\u636ePM\u7cfb\u7edf\u5df2\u88ab\u9a8c\u6536,\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c!");
        }
        super.removeById((Serializable)weighEntity.getId());
        return CommonResponse.success((String)"\u6570\u636e\u5220\u9664\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveWeighImgs(PushWeighbillVO weighVO) {
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        WeighbillEntity weighEntity = (WeighbillEntity)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"third_weigh_id", (Object)weighVO.getThirdWeighId())).eq((Object)"source_system", (Object)weighVO.getSource())));
        this.weighbillImgService.remove((Wrapper)new QueryWrapper().eq((Object)"weight_id", (Object)weighEntity.getId()));
        weighVO.setId(weighEntity.getId());
        weighVO.setId(weighEntity.getId());
        this.uploadImg(weighVO);
        this.uploadDetailImg(weighVO);
        return CommonResponse.success((String)"\u540c\u6b65\u78c5\u5355\u56fe\u7247\u6210\u529f");
    }

    public WeighbillEntity changeVo(WeighbillEntity weighEntity, DeliveryVO deliveryVO, PushWeighbillVO weighVO, String deriveryDetailId) {
        weighEntity.setDeliveryCode(deliveryVO.getBillCode());
        weighEntity.setProjectId(deliveryVO.getProjectId());
        weighEntity.setProjectCode(deliveryVO.getProjectCode());
        weighEntity.setProjectName(deliveryVO.getProjectName());
        weighEntity.setOrgId(deliveryVO.getOrgId());
        weighEntity.setOrgName(deliveryVO.getOrgName());
        weighEntity.setParentOrgId(deliveryVO.getParentOrgId());
        weighEntity.setParentOrgName(deliveryVO.getParentOrgName());
        weighEntity.setContractId(deliveryVO.getContractId());
        weighEntity.setContractCode(deliveryVO.getContractCode());
        weighEntity.setContractName(deliveryVO.getContractName());
        weighEntity.setSupplierId(deliveryVO.getSupplierId());
        weighEntity.setSupplierName(deliveryVO.getSupplierName());
        List deliveryDetailList = deliveryVO.getDeliveryDetailList();
        for (DeliveryDetailVO deliveryDetailVO : deliveryDetailList) {
            if (!String.valueOf(deliveryDetailVO.getId()).equals(deriveryDetailId)) continue;
            weighEntity.setDeliveryId(deliveryDetailVO.getDeliveryId());
            weighEntity.setDeliveryDetailId(deliveryDetailVO.getId());
            weighEntity.setMaterialTypeId(deliveryDetailVO.getMaterialTypeId());
            weighEntity.setMaterialTypeName(deliveryDetailVO.getMaterialTypeName());
            weighEntity.setMaterialId(deliveryDetailVO.getMaterialId());
            weighEntity.setMaterialCode(deliveryDetailVO.getMaterialCode());
            weighEntity.setMaterialName(deliveryDetailVO.getMaterialName());
            weighEntity.setSpec(deliveryDetailVO.getSpec());
            weighEntity.setUnit(deliveryDetailVO.getUnit());
            weighEntity.setUnitId(deliveryDetailVO.getUnitId());
        }
        weighEntity.setWeightDate(new Date());
        weighEntity.setCheckStatus(0);
        weighEntity.setGrossTime(new Date(weighVO.getGrossTime()));
        weighEntity.setTareTime(new Date(weighVO.getTareTime()));
        return weighEntity;
    }

    public String uploadImg(PushWeighbillVO weighbillVO) {
        List imgVOList = weighbillVO.getWeighImgs();
        if (CollectionUtils.isNotEmpty((Collection)imgVOList)) {
            ArrayList list;
            AttachmentRequestVO attachmentVO;
            ArrayList mzListBase64 = new ArrayList();
            ArrayList mzList = new ArrayList();
            ArrayList pzListBase64 = new ArrayList();
            ArrayList pzList = new ArrayList();
            imgVOList.forEach(e -> {
                if (1 == e.getImageType()) {
                    if (this.isImageFromBase64(e.getImage())) {
                        mzListBase64.add(e.getImage());
                    } else {
                        mzList.add(e.getImage());
                    }
                } else if (2 == e.getImageType()) {
                    if (this.isImageFromBase64(e.getImage())) {
                        pzListBase64.add(e.getImage());
                    } else {
                        pzList.add(e.getImage());
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(mzListBase64)) {
                attachmentVO = new AttachmentRequestVO();
                attachmentVO.setBillType(BILL_TYPE);
                attachmentVO.setSourceId(weighbillVO.getId().toString());
                attachmentVO.setSourceType(MZ_SOURCETYPE);
                attachmentVO.setHandleImg(Boolean.valueOf(false));
                attachmentVO.setClearBeforeSave(Boolean.valueOf(false));
                attachmentVO.setFileList(mzListBase64);
                this.attachmentApi.uploadForBase64(attachmentVO);
            }
            if (CollectionUtils.isNotEmpty(pzListBase64)) {
                attachmentVO = new AttachmentRequestVO();
                attachmentVO.setBillType(BILL_TYPE);
                attachmentVO.setSourceId(weighbillVO.getId().toString());
                attachmentVO.setSourceType(PZ_SOURCETYPE);
                attachmentVO.setHandleImg(Boolean.valueOf(false));
                attachmentVO.setClearBeforeSave(Boolean.valueOf(false));
                attachmentVO.setFileList(pzListBase64);
                this.attachmentApi.uploadForBase64(attachmentVO);
            }
            if (CollectionUtils.isNotEmpty(mzList)) {
                list = new ArrayList();
                mzList.forEach(e -> {
                    AttachmentVO attachmentVO = new AttachmentVO();
                    attachmentVO.setBillType(BILL_TYPE);
                    attachmentVO.setSourceId(weighbillVO.getId());
                    attachmentVO.setSourceType(MZ_SOURCETYPE);
                    attachmentVO.setFilePath(e);
                    attachmentVO.setOnlinePath(e);
                    list.add(attachmentVO);
                });
                this.attachmentApi.insertBatch(list);
            }
            if (CollectionUtils.isNotEmpty(pzList)) {
                list = new ArrayList();
                pzList.forEach(e -> {
                    AttachmentVO attachmentVO = new AttachmentVO();
                    attachmentVO.setBillType(BILL_TYPE);
                    attachmentVO.setSourceId(weighbillVO.getId());
                    attachmentVO.setSourceType(PZ_SOURCETYPE);
                    attachmentVO.setFilePath(e);
                    attachmentVO.setOnlinePath(e);
                    list.add(attachmentVO);
                });
                this.attachmentApi.insertBatch(list);
            }
        }
        return "";
    }

    private boolean isImageFromBase64(String base64Str) {
        String[] baseStrs = base64Str.split(",");
        String base64 = baseStrs.length > 1 ? baseStrs[1] : baseStrs[0];
        boolean flag = false;
        try {
            BufferedImage bufImg = ImageIO.read(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(base64)));
            if (null == bufImg) {
                return flag;
            }
            flag = true;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return flag;
    }

    public String uploadDetailImg(PushWeighbillVO weighbillVO) {
        List imgVOList = weighbillVO.getWeighImgs();
        ArrayList imgEntities = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)imgVOList)) {
            imgVOList.forEach(e -> {
                WeighbillImgEntity weighbillImgEntity = (WeighbillImgEntity)((Object)((Object)BeanMapper.map((Object)e, WeighbillImgEntity.class)));
                weighbillImgEntity.setThirdWeighId(weighbillVO.getThirdWeighId());
                weighbillImgEntity.setSourceSystem(weighbillVO.getSource());
                weighbillImgEntity.setWeightId(weighbillVO.getId());
                imgEntities.add(weighbillImgEntity);
            });
            this.weighbillImgService.saveOrUpdateBatch(imgEntities);
        }
        return "";
    }
}

