package com.ejianc.wzxt.order.service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.wzxt.order.bean.OrderEntity;
import com.ejianc.wzxt.order.vo.OrderVO;
import com.ejianc.wzxt.order.vo.SupOrderVO;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 材料订单主表
 *
 * @author generator
 *
 */
public interface IOrderService extends IBaseService<OrderEntity> {
    CommonResponse<OrderVO> saveOrUpdate(OrderVO saveOrUpdateVO);
    CommonResponse<OrderVO> queryDetail(Long id);
    CommonResponse<String> delete( List<OrderVO> vos);
    Map<String,Object> savaHintFlag(OrderVO orderVO);
    CommonResponse<OrderVO> updateReceived(SupOrderVO supOrderVO);
    /**
     * 单据推送到供方协同服务
     *
     * @param orderEntity 待推送单据
     * @param billTypeCode 待推送单据的单据类型编码
     * @return
     */
    boolean pushBillToSupCenter(OrderEntity orderEntity, String billTypeCode);
    CommonResponse<String> close(Long orderId);
    CommonResponse<String> updatePushBill(OrderEntity orderEntity, String billTypeCode,String url);
    CommonResponse<String> updateDeliver(Long orderId,Integer deliverState);
    BigDecimal getSurplusNumsSum (Long orderDetailId,Long projectId, Long materialId);
}
