package com.ejianc.wzxt.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.wzxt.check.bean.CheckDetailEntity;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.check.bean.CheckWeighEntity;
import com.ejianc.wzxt.check.mapper.CheckMapper;
import com.ejianc.wzxt.check.service.ICheckDetailService;
import com.ejianc.wzxt.check.service.ICheckService;
import com.ejianc.wzxt.check.service.ICheckWeighService;
import com.ejianc.wzxt.check.vo.*;
import com.ejianc.wzxt.delivery.bean.DeliveryDetailEntity;
import com.ejianc.wzxt.delivery.bean.DeliveryEntity;
import com.ejianc.wzxt.delivery.service.IDeliveryDetailService;
import com.ejianc.wzxt.delivery.service.IDeliveryService;
import com.ejianc.wzxt.delivery.vo.DeliveryTypeEnum;
import com.ejianc.wzxt.enums.BillPushStatusEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 消耗材-验收主表
 *
 * @author generator
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService {
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private ICheckWeighService checkWeighService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String CHECK_MNY_CODE = "P-2dnh8V0139";
    private static final String CHECK_SUB_MNY_CODE = "P-Tl9Zyr0141";

    private final String[] ALLOW_WEIGH_UNIT = new String[]{"千克", "公斤", "KG", "kg", "Kg", "T", "t", "吨"};


    private static final String BILL_CODE = "ZJKJ-CHECK-CODE";//此处需要根据实际修改
    private final String OPERATE = "ZJKJ_CHECK_SYNC";
    private static final String BILL_TYPE = "EJCBT202407000006";//此处需要根据实际修改

    //参数控制编码
    private static final String CHECK_PARAM_CODE = "P-44841Z56";//数量控制
    private static final String CHECK_MNY_CON_CODE = "P-n01oAU0146";//【施工合同金额】控【无合同验收、零星机械金额】


    @Override
    @Transactional
    public CheckVO saveOrUpdates(CheckVO saveOrUpdateVO) {

        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            }
        }
        // orgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
            }
        }
        CheckEntity entity = BeanMapper.map(saveOrUpdateVO, CheckEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (null == entity.getCheckWeighType()) {
                entity.setCheckWeighType(CheckWeighTypeEnum.否磅单验收.getCode());
            }
            if (null == entity.getAutomaticWeigh()) {// 自动称重设置（0：自动称重，1非自动称重）
                entity.setAutomaticWeigh(1);
            }
        }
        entity.setSignStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());

        //磅单验收回显磅单数据信息
        if (CheckWeighTypeEnum.是磅单验收.getCode().equals(entity.getCheckWeighType())) {
            List<CheckWeighEntity> checkWeighListDel = new ArrayList<>();
            for (CheckWeighEntity checkWeighEntity : entity.getCheckWeighList()) {
                if ("del".equals(checkWeighEntity.getRowState())) {
                    checkWeighListDel.add(checkWeighEntity);
                }
            }
            this.delWeighBill(checkWeighListDel);
        }
        super.saveOrUpdate(entity, false);
        //磅单验收回显磅单数据信息
        if (CheckWeighTypeEnum.是磅单验收.getCode().equals(entity.getCheckWeighType())) {
            this.addOrUpdateWeighBill(entity.getCheckDetailList(), entity.getCheckWeighList());
        }

        //回写发货单数据
        if (entity.getCheckType() == 3) {
            Integer checkStatus = 0;
            DeliveryEntity deliveryEntity = deliveryService.selectById(entity.getDeliveryId());
            //查询出所有的验收单详情,算出验收数据
            LambdaQueryWrapper<CheckDetailEntity> lambdaCheckDetail = Wrappers.<CheckDetailEntity>lambdaQuery();
            lambdaCheckDetail.eq(CheckDetailEntity::getSourceId, entity.getDeliveryId());
            List<CheckDetailEntity> checkDetailEntityList = checkDetailService.list(lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty(checkDetailEntityList)) {
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getSourceDetailId));
                LambdaQueryWrapper<DeliveryDetailEntity> lambdaDeliveryDetail = Wrappers.<DeliveryDetailEntity>lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, entity.getDeliveryId());
                List<DeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailService.list(lambdaDeliveryDetail);
                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNum)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null == deliveryDetailEntity.getCheckNum()) {
                        deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                    }
                }

                //判断发货单的验收状态
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                        (e.getCheckNum().compareTo(e.getDeliveryNum()) == -1));

                if (allCheck) {
                    checkStatus = 2;
                }
                if (anyCheck) {
                    checkStatus = 1;
                }
                //更新发货验收状态和验收数量
                deliveryEntity.setCheckStatus(checkStatus);
                deliveryService.updateById(deliveryEntity);
                deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }

            //推送供方
            //对单据进行加锁
            if (!DeliveryTypeEnum.自制送货单.getCode().equals(deliveryEntity.getDeliveryType())) {//自制发货单不推送供方
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("获取当前系统编码失败！");
                }
                Map<String, Object> map = new HashMap<>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, PUSH_BILL_SERVER_URL, RequestMethod.POST,
                        deliveryEntity.getSupplierId().toString(), OPERATE, BILL_TYPE);
                if (!updateSupplierStatus) {
                    throw new BusinessException("单据推送失败！");
                }
            }
        }
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return vo;
    }

    //保存删除回显磅单
    private void delWeighBill(List<CheckWeighEntity> checkWeighList) {
        List<WeighbillVO> upDateWeighBill = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {//验收删除磅单明细组合数据
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                weighbillVO.setCheckId(checkWeighEntity.getCheckId());
                weighbillVO.setCheckDetailId(checkWeighEntity.getId());
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(0);//("验收状态，0-未验收,1-已验收")
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            logger.info("保存删除回显磅单，数据信息：{}", JSONObject.toJSONString(upDateWeighBill));
            weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    //新增修改回显磅单
    private void addOrUpdateWeighBill(List<CheckDetailEntity> checkDetailList, List<CheckWeighEntity> checkWeighList) {
        List<WeighbillVO> upDateWeighBill = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {//循环验收明细和验收磅单明细组合数据
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                if (CollectionUtils.isNotEmpty(checkDetailList)) {
                    for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                        if (null != checkWeighEntity.getDeliveryDetailId() && checkWeighEntity.getDeliveryDetailId().equals(checkDetailEntity.getSourceDetailId())) {
                            weighbillVO.setCheckId(checkDetailEntity.getCheckId());
                            weighbillVO.setCheckDetailId(checkDetailEntity.getId());
                            //更新验收磅单信息
                            checkWeighEntity.setCheckDetailId(checkDetailEntity.getId());
                            checkWeighEntity.setCheckStatus(1);
                        }
                    }
                }
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(1);//("验收状态，0-未验收,1-已验收")
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            logger.info("新增修改更新验收磅单，数据信息：{}", JSONObject.toJSONString(checkWeighList));
            checkWeighService.updateBatchById(checkWeighList);
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            logger.info("新增修改回显磅单，数据信息：{}", JSONObject.toJSONString(upDateWeighBill));
            weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    @Transactional
    public void deletes(List<CheckVO> vos) {
        //删除回写逻辑, 回写发货单子表数据
        if (vos.size() > 1) {
            throw new BusinessException("验收单不允许批量删除!");
        }
        CheckVO checkVO = vos.get(0);
        CheckEntity checkEntity = super.selectById(checkVO.getId());
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        List<CheckWeighEntity> checkWeighList = checkEntity.getCheckWeighList();
        DeliveryEntity deliveryEntity = deliveryService.selectById(checkEntity.getDeliveryId());
        if (deliveryEntity != null) {
            List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
            Map<Long, CheckDetailEntity> checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getSourceDetailId, Function.identity()));
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                if (checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) {
                    CheckDetailEntity checkDetailEntity = checkDetailEntityMap.get(deliveryDetailEntity.getId());
                    deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
                }
            }

            //判断发货单的验收状态
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                    (e.getCheckNum().compareTo(e.getDeliveryNum()) == -1));
            Integer checkStatus = 0;
            if (allCheck) {
                checkStatus = 2;
            }
            if (anyCheck) {
                checkStatus = 1;
            }
            //更新发货验收状态和验收数量
            deliveryEntity.setCheckStatus(checkStatus);
            deliveryService.updateById(deliveryEntity);
            deliveryDetailService.updateBatchById(deliveryDetailList);

            //推送供方
            //对单据进行加锁
            if (!DeliveryTypeEnum.自制送货单.getCode().equals(deliveryEntity.getDeliveryType())) {//自制发货单不推送供方
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("获取当前系统编码失败！");
                }
                Map<String, Object> map = new HashMap<>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, PUSH_BILL_SERVER_URL, RequestMethod.POST,
                        deliveryEntity.getSupplierId().toString(), OPERATE, BILL_TYPE);
                if (!updateSupplierStatus) {
                    throw new BusinessException("单据推送失败！");
                }
            }
        }

        this.delWeighBill(checkWeighList);//删除回显磅单
        super.removeByIds(vos.stream().map(CheckVO::getId).collect(Collectors.toList()), true);
        return;

    }


    @Override
    public boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate, String url) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", datInfo);

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(sourceId, null, null, null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
//                Map<String, String> fileSourceTypeMap = new HashMap<>();
//                List<Long> fileIds = new ArrayList<>();
//
//                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
//                for (AttachmentVO attach : fileList) {
//                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
//                    fileIds.add(attach.getId());
//                }

//                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));

                //当前单据携带有附件信息
//                if (CollectionUtils.isNotEmpty(fileList)) {
//                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
//                    fileMap.keySet().stream().forEach(fileKey -> {
//                        Map<String, InputStream> file = new HashMap<>(1);
//                        file.put(fileKey, fileMap.get(fileKey));
//                        files.put(fileKey, file);
//                    });
//                }
                logger.info("向供应商-{}推送计量单据参数-{}", supplierId, JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url,
                        paramMap,
                        supplierId.toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送验收单据id-{}失败, {}", supplierId, sourceId, billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送验收单据id-{}给供方id-{}失败, {}", sourceId, supplierId, syncReqResp.getMsg());
                }
            } else {
                logger.error("获取验收单据id-{}对应附件信息失败, {}", sourceId, fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送验收单据id-{}给供方id-{} 异常，", sourceId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        CheckEntity checkEntity = super.selectById(billId);
        //设置供方签字信息
//        checkEntity.setSupOperateTime(supOperateTime);
//        checkEntity.setSupOperatorName(supOperatorName);
//        checkEntity.setSupOperatorPhone(supOperatorPhone);
//        checkEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + checkEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", checkEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, checkEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            checkEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：1-未签字、2-待乙方签字、3-待甲方签字、4-已签字
            // 乙方已签字状态即待甲方签字
            checkEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(checkEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", checkEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    /**
     * 通知用户消息
     *
     * @param
     */
    private String sendMsg(CheckEntity checkEntity, String subject, String content) {

//        String[] msgRecUserIds = new String[]{checkEntity.getCreateUserId().toString(), settleEntity.getEmployeeId().toString()};

//        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
//        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(subject);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(checkEntity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }


    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(CheckVO vo, ParamsCheckVO paramsCheckVO2) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*预警参数添加域*/
        if (null != vo.getContractId()) {//有合同预警域
//            ContractEntity contractEntity = contractService.selectById(vo.getContractId());
//            //数量  proMaterial-1 - 大宗(主要)   proMaterial-2-周转  proMaterial-3-零星   混凝土不走
//            if (("proMaterial-1".equals(vo.getCheckType()))) {
//                paramsCheckVOS.addAll(this.checkParamsNum(contractEntity, vo));//数量
//            }
        } else {//无合同控制区域
//            if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
//                paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//【施工合同金额】控【无合同验收、零星机械金额】
//            }
        }
        //材料验收、混凝土验收—无合同验收-单次无合同验收金额控制
        if (vo.getContractId() == null) {
            //获取验收金额
            List<CheckDetailVO> checkDetailList = vo.getCheckDetailList();
            if (CollectionUtils.isNotEmpty(checkDetailList)) {
                BigDecimal checkTaxMny = checkDetailList.stream().map(CheckDetailVO::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                BigDecimal oldTaxMny = this.getSupplierNoContractMny(vo.getProjectId(), vo.getSupplierId());
//                BigDecimal taxMny = ComputeUtil.safeAdd(checkTaxMny,oldTaxMny); // 本期+以往
//                paramsCheckVOS.addAll(this.checkParamsCheckNum(checkTaxMny, vo.getOrgId()));
            }
        }
        //材料验收、混凝土验收—无合同验收-单个供应商无合同验收金额控制
        if (vo.getContractId() == null) {
//            2、单个供应商无合同验收金额：根据项目+供应商查询所有状态的无合同材料验收+无合同混凝土验收金额+本期金额】
            List<CheckDetailVO> checkDetailList = vo.getCheckDetailList();
            BigDecimal currentMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(checkDetailList)) {
                currentMny = checkDetailList.stream().map(CheckDetailVO::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            LambdaQueryWrapper<CheckEntity> checkLambda = Wrappers.<CheckEntity>lambdaQuery();
            checkLambda.eq(CheckEntity::getProjectId, vo.getProjectId());
//            checkLambda.eq(CheckEntity::getContractId,null);
            checkLambda.isNull(CheckEntity::getContractId);
            checkLambda.eq(CheckEntity::getSupplierId, vo.getSupplierId());
            List<CheckEntity> checkEntityList = super.list(checkLambda);
            BigDecimal checkAll = currentMny;
            if (CollectionUtils.isNotEmpty(checkEntityList)) {
                List<Long> checkIds = checkEntityList.stream().map(CheckEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<CheckDetailEntity> checkDetailLambda = Wrappers.<CheckDetailEntity>lambdaQuery();
                checkDetailLambda.in(CheckDetailEntity::getCheckId, checkIds);
                List<CheckDetailEntity> checkDetailEntityList = checkDetailService.list(checkDetailLambda);
                if (CollectionUtils.isNotEmpty(checkDetailEntityList)) {
//                    BigDecimal checkTaxMny = checkDetailEntityList.stream().map(CheckDetailEntity::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal checkTaxMny = BigDecimal.ZERO;
                    checkAll = currentMny.add(checkTaxMny);
                }

            }
//            paramsCheckVOS.addAll(this.checkParamsCheckSubNum(currentMny, checkAll, vo.getOrgId()));//数量
        }
        //成本参数
        if (paramsCheckVO2 != null) {
            logger.info("目标成本控制结果--------" + JSONObject.toJSONString(paramsCheckVO2));
            paramsCheckVOS.add(paramsCheckVO2);
        }
//        ParamsCheckVO priceParams = this.priceCheckParams(vo);
        ParamsCheckVO priceParams = null;
        if (priceParams != null) {//价格库控制
            logger.info("价格库控制--------" + JSONObject.toJSONString(priceParams));
            paramsCheckVOS.add(priceParams);
        }
        if (!"proMaterial-3".equals(vo.getCheckType())) {//零星材料，不控制
//            ParamsCheckVO costParams = this.costPriceCheckParams(vo);
            ParamsCheckVO costParams = null;
            if (costParams != null) {//目标成本价格库控制
                logger.info("目标成本价格库控制--------" + JSONObject.toJSONString(costParams));
                paramsCheckVOS.add(costParams);
            }
        }


        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }

        return paramsCheckVO;
    }

    /*
     * 【施工合同金额】控【无合同验收、零星机械金额】*/
/*    @Override
    public List<ParamsCheckVO> checkParamsConstruction(CheckVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;//施工合同金额
        BigDecimal mny = null == vo.getCheckAllTaxMny() ? BigDecimal.ZERO : vo.getCheckAllTaxMny();//本次验收金额
        BigDecimal totalMny = mny;//无合同验收金额+临时设备记录使用金额   默认赋值本次结算金额
        //根据项目查询该项目下所有状态的 物资/混凝土验收金额累计
        LambdaQueryWrapper<CheckEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(CheckEntity::getProjectId, vo.getProjectId());
        wrapper.isNull(CheckEntity::getContractId);
        if (null != vo.getId()) {
            wrapper.ne(CheckEntity::getId, vo.getId());
        }
        List<CheckEntity> list = super.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            BigDecimal totalTaxMny = list.stream().filter(e -> null != e.getCheckAllTaxMny()).map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd(totalMny, totalTaxMny);//累加消耗材无合同验收金额
        }
        LambdaQueryWrapper<ConcreteCheckEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(ConcreteCheckEntity::getProjectId, vo.getProjectId());
        wrapper2.isNull(ConcreteCheckEntity::getContractId);
        List<ConcreteCheckEntity> list2 = concreteCheckService.list(wrapper2);
        if (CollectionUtils.isNotEmpty(list2)) {
            BigDecimal totalTaxMny = list2.stream().filter(e -> null != e.getCheckAllTaxMny()).map(ConcreteCheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd(totalMny, totalTaxMny);//累加混凝土无合同验收金额
        }
        //根据项目查询该项目下所有状态的【临时设备使用记录金额】
        CommonResponse<JSONObject> response = temporaryUseRecordApi.queryProTemporaryUseRecordMny(vo.getProjectId());
        logger.info("该项目：{}-下所有状态的【临时设备使用记录金额】金额结果:{}", vo.getProjectId(), JSONObject.toJSONString(response));
        if (response.isSuccess() && null != response.getData()) {
            BigDecimal useMny = response.getData().getBigDecimal("useMny");
            totalMny = ComputeUtil.safeAdd(totalMny, useMny);//累加 临时设备使用记录金额
        }
        //根据项目查询施工合同金额
        CommonResponse<ContractRegisterVO> commonResponse = proincomeContrantApi.queryContranctMny(vo.getProjectId());
        logger.info("该项目:{}-下生效的最新正式施工合同:{}", vo.getProjectId(), JSONObject.toJSONString(commonResponse));
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            contractTaxMny = null == commonResponse.getData().getContractTaxMny() ? BigDecimal.ZERO : commonResponse.getData().getContractTaxMny();
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【施工合同金额】控【无合同验收、零星机械金额】信息返回：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    //施工合同百分比 后的金额
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("无合同验收、临机费用超施工合同额");
                        paramsCheckDsVO.setWarnName("无合同验收、临机费用累计金额超施工合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次零材、零机发生金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    //价格库合同参数控制
    @Override
    public ParamsCheckVO priceCheckParams(CheckVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
//        switch (vo.getSettlementType()){
//            case 0: materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.消耗材结算.getCode());break;
//            case 1: materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.混凝土结算.getCode());break;
//        }
        materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.消耗材验收.getCode());
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(vo.getCheckDetailList())) {
            for (CheckDetailVO detailVO : vo.getCheckDetailList()) {
                if (!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId() != null) {
                    MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getCheckPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getCheckTaxPrice());
                    priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                    priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                    priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                    priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO costPriceCheckParams(CheckVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.消耗材验收.getCode());
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(vo.getCheckDetailList())) {
            for (CheckDetailVO detailVO : vo.getCheckDetailList()) {
                if (!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId() != null) {
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getCheckPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getCheckTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = contractService.costPriceParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    */
    /*
     * 材料验收、混凝土验收—无合同验收-单次无合同验收金额控制*//*

    @Override
    public List<ParamsCheckVO> checkParamsCheckNum(BigDecimal checkTaxMny, Long orgId) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("消耗材-单次无合同验收金额控制控制：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("本次验收金额超过限定金额");
                        paramsCheckDsVO.setWarnName("单次无合同材料验收金额超限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(checkTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(checkTaxMny, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    */
    /*
     * 材料验收、混凝土验收—无合同验收-单个供应商无合同验收金额控制
     *//*

    @Override
    public List<ParamsCheckVO> checkParamsCheckSubNum(BigDecimal currentMny, BigDecimal checkTaxMnyAll, Long orgId) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUB_MNY_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
//            logger.info("消耗材-单个供应商无合同验收金额控制：本次金额：{}，含本次累计总金额：{}",currentMny,checkTaxMnyAll);
            logger.info("消耗材-单个供应商无合同验收金额控制：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMnyAll.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("供应商无合同验收金额超过限定金额");
                        paramsCheckDsVO.setWarnName("供应商无合同验收金额超过限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(currentMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计验收金额：").append(checkTaxMnyAll.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(checkTaxMnyAll, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
*/

    /**
     * 单据管控-累计入库数量大于合同数量
     *
     * @return
     */
  /*  @Override
    public List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, CheckVO vo) {
        String purchaseType = contractEntity.getPurchaseType();//采购类型 1-自采，2-集采
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        if (PurchaseTypeEnum.公司集采.getCode().equals(purchaseType)) {
            // 集采合同直接赋值为不控制
            return paramsCheckVOS;
        }
        //查询结算累计子表
        List<CheckDetailVO> detail = baseMapper.getDetail(contractEntity.getId(), vo.getId());
        Map<Long, CheckDetailVO> detailSettleMap = detail.stream().collect(Collectors.toMap(CheckDetailVO::getMaterialId, item -> item, (v1, v2) -> v2));
        //合同分类
        Map<Long, ContractDetailEntity> typeMap = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() == null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        //合同明细
        Map<Long, ContractDetailEntity> map = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        //结算分类数量 分类数量 = 累计结算+本次 都不在的合同明细的明细数量累加
        Map<Long, BigDecimal> detailTypeMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(detail)) {
            for (CheckDetailVO detailVO : detail) {
                if (!map.containsKey(detailVO.getMaterialId())) {//不属于明细
                    BigDecimal num = detailTypeMap.get(detailVO.getMaterialTypeId());
                    if (detailTypeMap.containsKey(detailVO.getMaterialTypeId())) {//存在累加更新
                        detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd(num, detailVO.getCheckNum()));
                    } else {//不存在，添加
                        detailTypeMap.put(detailVO.getMaterialTypeId(), detailVO.getCheckNum());
                    }
                }
            }
        }
        //当前单据吗明细 去重过累加过的的
        Map<Long, CheckDetailVO> detailMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(vo.getCheckDetailList())) {
            for (CheckDetailVO detailVO : vo.getCheckDetailList()) {
                if (!"del".equals(detailVO.getRowState())) {
                    CheckDetailVO mapVO = detailMap.get(detailVO.getMaterialId());
                    if (Objects.nonNull(mapVO)) {
                        detailVO.setCheckNum(ComputeUtil.safeAdd(mapVO.getCheckNum(), detailVO.getCheckNum()));
                        detailMap.put(detailVO.getMaterialId(), detailVO);
                    } else {
                        detailMap.put(detailVO.getMaterialId(), detailVO);
                    }
                    if (!map.containsKey(detailVO.getMaterialId())) {//不属于明细
                        BigDecimal num = detailTypeMap.get(detailVO.getMaterialTypeId());
                        if (detailTypeMap.containsKey(detailVO.getMaterialTypeId())) {//存在累加更新
                            detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd(num, detailVO.getCheckNum()));
                        } else {//不存在，添加
                            detailTypeMap.put(detailVO.getMaterialTypeId(), detailVO.getCheckNum());
                        }
                    }
                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("入库数量控制信息返回：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (CollectionUtils.isNotEmpty(detailMap.values())) {
                        for (CheckDetailVO detailVO : detailMap.values()) {
                            BigDecimal num = detailSettleMap.containsKey(detailVO.getMaterialId()) ? detailSettleMap.get(detailVO.getMaterialId()).getCheckNum() : BigDecimal.ZERO;
                            //含本次结算数量
                            BigDecimal totalNum = ComputeUtil.safeAdd(num, detailVO.getCheckNum()).setScale(4, BigDecimal.ROUND_HALF_UP);
                            //含本次结算分类明细
                            BigDecimal numType = detailTypeMap.containsKey(detailVO.getMaterialTypeId()) ? detailTypeMap.get(detailVO.getMaterialTypeId()) : BigDecimal.ZERO;
                            //合同数量
                            BigDecimal comNum = BigDecimal.ZERO;

                            //是否属于合同明细
                            if (map.containsKey(detailVO.getMaterialId())) {
                                ContractDetailEntity detailEntity = map.get(detailVO.getMaterialId());
                                //合同数量
                                comNum = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(detailEntity.getNum(), roleValue), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                            }//是否属于合同分类
                            else if (typeMap.containsKey(detailVO.getMaterialTypeId())) {
                                ContractDetailEntity detailEntity = typeMap.get(detailVO.getMaterialTypeId());
                                //合同数量
                                comNum = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(detailEntity.getNum(), roleValue), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                                totalNum = numType;
                            }//不在合同内不预警
                            else {
                                continue;
                            }
                            if (totalNum.compareTo(comNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + "+" + detailVO.getSpec());
                                paramsCheckDsVO.setWarnName("入库数量大于合同数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次入库数量：").append(detailVO.getCheckNum().setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("，含本次累计入库数量：").append(totalNum.setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("，合同数量*").append(roleValue).append("%:").append(comNum.setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(ComputeUtil.safeSub(totalNum, comNum).setScale(4, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOS;
    }*/
    @Override
    public CheckVO queryDetailWeigh(CheckVO vo) {
        CheckVO checkVO = deliveryService.queryDetailToCheck(vo.getDeliveryId());
        logger.info("----磅单验收原数据 ：{}", JSONObject.toJSONString(checkVO));
        List<CheckDetailVO> checkDetailList = checkVO.getCheckDetailList();
        List<CheckWeighVO> checkWeighList = vo.getCheckWeighList();
        List<CheckWeighVO> checkWeighVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            List<Long> collect = checkWeighList.stream().filter(item -> null != item.getId()).map(item -> item.getId()).collect(Collectors.toList());
            CommonResponse<List<WeighbillVO>> listCommonResponse = weighbillApi.queryWeighbills(checkVO.getProjectId(), collect);
            if (!listCommonResponse.isSuccess()) {
                throw new BusinessException("查询磅单失败！错误信息：" + listCommonResponse.getMsg());
            }
            List<WeighbillVO> data = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(data)) {
                for (WeighbillVO weighbillVO : data) {
                    CheckWeighVO checkWeighVO = BeanMapper.map(weighbillVO, CheckWeighVO.class);
                    BigDecimal netWeight = weighbillVO.getNetWeight();//净重
                    BigDecimal coefficient = weighbillVO.getCoefficient();//换算系数
                    String weightUnit = weighbillVO.getWeightUnit();
                    Map<String, BigDecimal> checkNumMap = getCheckNum(weightUnit, netWeight, coefficient);
                    checkWeighVO.setCheckNum(checkNumMap.get("checkNum"));
                    checkWeighVO.setDetailNetWeightCoefficient(checkNumMap.get("detailNetWeightCoefficient"));
                    checkWeighVO.setWeightId(weighbillVO.getId());
                    checkWeighVO.setCheckId(null);
                    checkWeighVO.setId(null);
                    checkWeighVO.setWeighMemo(weighbillVO.getMemo());
                    checkWeighVO.setRowState("add");
                    checkWeighVOS.add(checkWeighVO);
                }
                Map<Long, List<CheckWeighVO>> weighMap = checkWeighVOS.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(CheckWeighVO::getDeliveryDetailId));
                if (CollectionUtils.isNotEmpty(checkDetailList)) {
                    for (CheckDetailVO checkDetailVO : checkDetailList) {
                        List<CheckWeighVO> checkWeighS = weighMap.get(checkDetailVO.getDeliveryDetailId());
                        if (null != checkWeighS && CollectionUtils.isNotEmpty(checkWeighS)) {
                            BigDecimal checkNum = checkWeighS.stream().map(CheckWeighVO::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal detailNetWeightCoefficient = checkWeighS.stream().map(CheckWeighVO::getDetailNetWeightCoefficient).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal netWeight = checkWeighS.stream().map(CheckWeighVO::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            checkDetailVO.setDetailNetWeight(netWeight);
                            checkDetailVO.setDetailNetWeightCoefficient(detailNetWeightCoefficient);
                            checkDetailVO.setDetailCoefficient(ComputeUtil.safeDiv(detailNetWeightCoefficient, checkNum));
                            checkDetailVO.setCheckNum(checkNum);
                        } else {
                            checkDetailVO.setDetailNetWeightCoefficient(BigDecimal.ZERO);
                            checkDetailVO.setDetailNetWeight(BigDecimal.ZERO);
                            checkDetailVO.setDetailCoefficient(BigDecimal.ZERO);
                            checkDetailVO.setCheckNum(BigDecimal.ZERO);
                        }
                    }
                }
            }
        }
        checkVO.setCheckWeighType(CheckWeighTypeEnum.是磅单验收.getCode());
        checkVO.setCheckDetailList(checkDetailList);
        checkVO.setCheckWeighList(checkWeighVOS);
        return checkVO;
    }

    public Map<String, BigDecimal> getCheckNum(String weighUnit, BigDecimal netWeight, BigDecimal coefficient) {
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        Map<String, BigDecimal> map = new HashMap<>();
        if (null == coefficient) {
            coefficient = BigDecimal.ZERO;
        }
        if (null == netWeight) {
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if (StringUtils.isNotEmpty(weighUnit)) {
            billStateCode = WeighUnitEnum.getEnumByStateCode(weighUnit).getBillStateCode();
        }
        switch (billStateCode) {
            case 0:
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv(detailNetWeightCoefficient, coefficient);
                break;
            case 1:
                detailNetWeightCoefficient = ComputeUtil.safeMultiply(netWeight, new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv(detailNetWeightCoefficient, coefficient);
                ;
                break;
        }
        map.put("checkNum", checkNum);
        map.put("detailNetWeightCoefficient", detailNetWeightCoefficient);
        return map;
    }


    /**
     * 根据项目id、验收日期查询消耗材、混凝土单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     * @return Map<String, Integer>
     */
    @Override
    public Map<String, Integer> countBillNum(Long projectId, Date checkDate) {
        HashMap<String, Integer> resultMap = new HashMap<>();

        LambdaQueryWrapper<CheckEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(CheckEntity::getProjectId, projectId)
                .eq(CheckEntity::getCheckDate, checkDate);
        int checkCount = super.count(lambdaQuery);
        resultMap.put("消耗材", checkCount);
        return resultMap;
    }
}
