package com.ejianc.wzxt.order.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.weigh.wagon.api.IWagonMaterialApi;
import com.ejianc.business.weigh.wagon.vo.WagonProjectVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.wzxt.enums.DeliverStateEnum;
import com.ejianc.wzxt.enums.OrderFlagEnum;
import com.ejianc.wzxt.enums.ReceiveStateEnum;
import com.ejianc.wzxt.order.bean.OrderDetailEntity;
import com.ejianc.wzxt.order.bean.OrderEntity;
import com.ejianc.wzxt.order.mapper.OrderMapper;
import com.ejianc.wzxt.order.service.IOrderDetailService;
import com.ejianc.wzxt.order.service.IOrderService;
import com.ejianc.wzxt.order.vo.OrderDetailVO;
import com.ejianc.wzxt.order.vo.OrderVO;
import com.ejianc.wzxt.order.vo.SupOrderDetailVO;
import com.ejianc.wzxt.order.vo.SupOrderVO;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.utils.CommonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料订单主表
 *
 * @author generator
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWagonMaterialApi wagonMaterialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZJKJ_ORDER";//此处需要根据实际修改
    @Autowired
    private IOrderService service;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IOutcontractApi outcontractApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private final String OPERATE = "MATERIAL_ORDER_SYNC";

    private final String PUSH_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/order/saveOrUpdate";

    private final String UPDATE_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/order/updateOrderCloseFlag";

    /*
     * 新增（修改）保存
     * */
    @Override
    public CommonResponse<OrderVO> saveOrUpdate(OrderVO saveOrUpdateVO) {
        afterProject(saveOrUpdateVO.getProjectId());

        savaHintFlag(saveOrUpdateVO);

        OrderEntity entity = BeanMapper.map(saveOrUpdateVO, OrderEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if (!flag) {
            return CommonResponse.error("该供应商未开通协同权限，无法新增订单。 请先到供应商库—生成协同账号再进行订单操作。");
        }

        List<OrderDetailEntity> orderDetailList = entity.getOrderDetailList();
        ArrayList<OrderDetailEntity> delOrderDetailList = new ArrayList<>();//删除子表父级
        ArrayList<OrderDetailEntity> addOrderDetailList = new ArrayList<>();//新增子表父级
        ArrayList<OrderDetailEntity> updateOrderDetailList = new ArrayList<>();//修改子表父级
        if (entity.getId() == null || entity.getId() == 0) {
            if (CollectionUtils.isNotEmpty(orderDetailList)) {
                for (OrderDetailEntity detail : orderDetailList) {
                    addOrderDetailList.add(detail);
                }
            }
        } else {
            if (CollectionUtils.isNotEmpty(orderDetailList)) {
                for (OrderDetailEntity detail : orderDetailList) {
                    if (detail.getId() != null) {
                        if ("del".equals(detail.getRowState())) {//删除
                            delOrderDetailList.add(detail);
                        } else {//修改
                            OrderDetailEntity byId = orderDetailService.getById(detail.getId());
                            BigDecimal orderNumsSum = detail.getOrderNumSum() == null ? BigDecimal.ZERO : detail.getOrderNumSum();
                            BigDecimal byNumsSum = byId.getOrderNumSum() == null ? BigDecimal.ZERO : byId.getOrderNumSum();
                            if (orderNumsSum.compareTo(byNumsSum) != 0) {//量有变化
                                updateOrderDetailList.add(detail);
                            }
                        }
                    } else {//新增
                        addOrderDetailList.add(detail);
                    }
                }
            }
        }
        entity.setOrderFlag(OrderFlagEnum.正常.getCode());
        if (entity.getAutomaticWeigh().compareTo(0) == 0) {
            CommonResponse<WagonProjectVO> response = wagonMaterialApi.queryProjConfig(entity.getProjectId());
            if (response.isSuccess() && null != response.getData()) {
                entity.setPlatformCode(response.getData().getWagonTypeCode());
                entity.setPlatformType(response.getData().getWagonCode());
            }
        }
        super.saveOrUpdate(entity, false);
        OrderVO vo = BeanMapper.map(entity, OrderVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /*
     * 查询详情
     * */
    @Override
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity entity = service.selectById(id);
        OrderVO orderVO = BeanMapper.map(entity, OrderVO.class);
        return CommonResponse.success("查询详情数据成功！", orderVO);
    }

    /*
     * 删除
     * */
    @Override
    public CommonResponse<String> delete(List<OrderVO> vos) {
        List<Long> ids = vos.stream().map(OrderVO::getId).collect(Collectors.toList());
        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }

    /*
     * 保存校验:清单物料编码必须在所选的采购合同清单中
     * */
    private void savaHintFlag(OrderVO orderVO) {
        List<String> errList = new ArrayList<>();//合同明细
        CommonResponse<OutcontractVO> response = outcontractApi.queryDetail(orderVO.getContractId());
        if (response.isSuccess() && null != response.getData() && CollectionUtils.isNotEmpty(orderVO.getOrderDetailList())) {
            //合同明细转为map
            Map<Long, OutcontractMaterialVO> detailVOMap = response.getData().getOutcontractMaterialList().stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(OutcontractMaterialVO::getMaterialId, item -> item, (v1, v2) -> v2));
            for (OrderDetailVO orderDetailVO : orderVO.getOrderDetailList()) {
                if (!"del".equals(orderDetailVO.getRowState())) {
                    if (!detailVOMap.containsKey(orderDetailVO.getMaterialId())) {//比较是否在合同明细
                        errList.add(orderDetailVO.getMaterialCode());
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(errList)) {
            throw new BusinessException("材料编码[" + StringUtils.join(errList, ",") + "]不在采购合同范围内，请变更合同清单!");
        }
    }

    /*
     * 接受
     * @param orderVO - 供方推送的订单vo
     * */
    @Override
    public CommonResponse<OrderVO> updateReceived(SupOrderVO orderVO) {
        logger.info("---接收开始---", JSONObject.toJSONString(orderVO));
        OrderEntity orderEntity = super.selectById(orderVO.getId());
        if (null != orderEntity && null != orderEntity.getReceiveState() && orderEntity.getReceiveState() > 0 && 4 != orderVO.getReceiveState()) {
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }

        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        String frontendBaseHost = "";
        if (StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !"null".equals(BASE_HOST_FRONTEND)) {
            frontendBaseHost = BASE_HOST_FRONTEND;
        } else {
            frontendBaseHost = baseHost;
        }

        logger.info("发送信息给发布人:>----------" + sender + frontendBaseHost);
        String formurl = frontendBaseHost + "zjkj-wzxt-mobile/#/purchaseOrder/card?id=" + orderEntity.getId();
        String subject = "";
        String content = "";
        //全部接收
        if (1 == orderVO.getReceiveState()) {
            logger.info("---全部接受开始---");
            orderEntity.setReceiveState(ReceiveStateEnum.全部接收.getCode());//全部接收
            orderEntity.setDeliverState(DeliverStateEnum.待送货.getCode());//待发货
            subject = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】全部接收。";
            content = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】全部接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            orderEntity.getOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(vo.getOrderNumSum());//接收数量
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        } else if (2 == orderVO.getReceiveState()) {
            logger.info("---部分接受开始---");
            //部分接收
            orderEntity.setReceiveState(ReceiveStateEnum.部分接收.getCode());
            orderEntity.setDeliverState(DeliverStateEnum.待送货.getCode());//待发货
            subject = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】部分接收。";
            content = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderVO.getOrderDetailList())) {
                Map<Long, BigDecimal> map = orderVO.getOrderDetailList().stream().collect(Collectors.toMap(SupOrderDetailVO::getId, SupOrderDetailVO::getReceiveNumsSum));
                logger.debug("map------" + map);
                orderEntity.getOrderDetailList().forEach(vo -> {
                    vo.setReceiveNumsSum(map.get(vo.getId()));
                    logger.debug("ReceiveNumsSum------" + vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                });
            }
        } else if (3 == orderVO.getReceiveState()) {
            logger.info("---不予接受开始---");
            //已拒绝
            orderEntity.setReceiveState(ReceiveStateEnum.不予接收.getCode());//拒绝
            orderEntity.setReceiveReason(orderVO.getReceiveReason());
            subject = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】拒绝接收。";
            content = "您的订单【" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + orderEntity.getSupplierName() + "】拒绝接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            orderEntity.getOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getTenantId()), orderEntity);
        logger.debug("-----主键" + orderEntity.getId());
        super.saveOrUpdate(orderEntity, false);
        if(2 == orderVO.getReceiveState() || 3 == orderVO.getReceiveState()){
            reveiveWriteOrder(orderEntity);
        }
        return CommonResponse.success("操作成功");
    }

    private void reveiveWriteOrder(OrderEntity orderEntity){
        List<OrderDetailEntity> orderDetailList = orderEntity.getOrderDetailList();
        MonthPlanEntity monthPlanEntity = monthPlanService.selectById(orderDetailList.get(0).getSourceId());
        List<MonthPlanDetailEntity> monthPlanDetailList = monthPlanEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(monthPlanDetailList)) {
            Map<Long, MonthPlanDetailEntity> map = monthPlanDetailList.stream().collect(Collectors.toMap(MonthPlanDetailEntity::getId, Function.identity(), (key1, key2) -> key1));
            List<MonthPlanDetailEntity> list = new ArrayList<>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if(map.containsKey(detailEntity.getSourceDetailId())){
                    MonthPlanDetailEntity entity = map.get(detailEntity.getSourceDetailId());
                    entity.setOrderNum(ComputeUtil.safeAdd(entity.getOrderNum(), ComputeUtil.safeSub(detailEntity.getReceiveNumsSum(), detailEntity.getOrderNumSum())));
                    list.add(entity);
                }
            }
            if (CollectionUtils.isNotEmpty(list)) {
                monthPlanDetailService.saveOrUpdateBatch(list);
            }
        }

        LambdaQueryWrapper<MasterPlanEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, orderEntity.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        MasterPlanEntity planEntity = masterPlanService.getOne(queryWrapper, false);
        MasterPlanEntity masterPlanEntity = masterPlanService.selectById(planEntity.getId());
        List<MasterPlanDetailEntity> masterPlanDetailList = masterPlanEntity.getMasterPlanDetailList();
        if (CollectionUtils.isNotEmpty(masterPlanDetailList)) {
            Map<Long, MasterPlanDetailEntity> map = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
            List<MasterPlanDetailEntity> list = new ArrayList<>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if(map.containsKey(detailEntity.getMaterialId())){
                    MasterPlanDetailEntity entity = map.get(detailEntity.getMaterialId());
                    entity.setOrderNum(ComputeUtil.safeAdd(entity.getOrderNum(), ComputeUtil.safeSub(detailEntity.getReceiveNumsSum(), detailEntity.getOrderNumSum())));
                    list.add(entity);
                }
            }
            if (CollectionUtils.isNotEmpty(list)) {
                masterPlanDetailService.saveOrUpdateBatch(list);
            }
        }
    }

    /*
     * 供方修改送货状态
     * */
    @Override
    public CommonResponse<String> updateDeliver(Long orderId, Integer deliverState) {
        logger.info("订单id:-{},修改发货状态开始!", orderId);
        OrderEntity byId = super.getById(orderId);
        byId.setDeliverState(deliverState);
        super.saveOrUpdate(byId);
        logger.info("订单id:-{},修改发货状态为:-{}成功!", orderId, deliverState);
        return CommonResponse.success("订单id:" + orderId + "修改发货状态为：" + deliverState + "成功!");
    }

    /*
     * 获取最新的计划剩余数量
     * */
    @Override
    public BigDecimal getSurplusNumsSum(Long orderDetailId, Long projectId, Long materialId) {
        //TODO
//        BigDecimal surplusNumsSum = planDetailService.getSurplusNumsSum(projectId, materialId);
        BigDecimal surplusNumsSum = BigDecimal.ZERO;
        if (orderDetailId != null) {
            OrderDetailEntity orderDetailEntity = orderDetailService.selectById(orderDetailId);
            BigDecimal orderNumsSum = orderDetailEntity.getOrderNumSum() == null ? BigDecimal.ZERO : orderDetailEntity.getOrderNumSum();
            surplusNumsSum = orderNumsSum.add(surplusNumsSum);
        }
        return surplusNumsSum;
    }

    @Override
    public CommonResponse<String> afterProject(Long projectId) {
        LambdaQueryWrapper<MonthPlanEntity> lambdaMaster = Wrappers.<MonthPlanEntity>lambdaQuery();
        lambdaMaster.eq(MonthPlanEntity::getProjectId, projectId);
        lambdaMaster.in(MonthPlanEntity::getBillState, 1, 3);
        lambdaMaster.likeRight(MonthPlanEntity::getPlanDate, DateUtil.format(new Date(), "yyyy-MM"));
        if(monthPlanService.count(lambdaMaster) > 0){
            throw new BusinessException("当前月度无月度计划，请先编制月度!");
        }
        return CommonResponse.success("校验成功!");
    }

    @Override
    public void writeBackMonthPlan(OrderEntity orderEntity, boolean isCommit) {
        List<OrderDetailEntity> orderDetailList = orderEntity.getOrderDetailList();
        MonthPlanEntity monthPlanEntity = monthPlanService.selectById(orderDetailList.get(0).getSourceId());
        List<MonthPlanDetailEntity> monthPlanDetailList = monthPlanEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(monthPlanDetailList)) {
            Map<Long, MonthPlanDetailEntity> map = monthPlanDetailList.stream().collect(Collectors.toMap(MonthPlanDetailEntity::getId, Function.identity(), (key1, key2) -> key1));
            List<MonthPlanDetailEntity> list = new ArrayList<>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if(map.containsKey(detailEntity.getSourceDetailId())){
                    MonthPlanDetailEntity entity = map.get(detailEntity.getSourceDetailId());
                    if (isCommit) {
                        entity.setOrderNum(ComputeUtil.safeAdd(entity.getOrderNum(), detailEntity.getOrderNumSum()));
                    }else {
                        entity.setOrderNum(ComputeUtil.safeSub(entity.getOrderNum(), detailEntity.getOrderNumSum()));
                    }
                    list.add(entity);
                }
            }
            if (CollectionUtils.isNotEmpty(list)) {
                monthPlanDetailService.saveOrUpdateBatch(list);
            }
        }

        LambdaQueryWrapper<MasterPlanEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, orderEntity.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        MasterPlanEntity planEntity = masterPlanService.getOne(queryWrapper, false);
        MasterPlanEntity masterPlanEntity = masterPlanService.selectById(planEntity.getId());
        List<MasterPlanDetailEntity> masterPlanDetailList = masterPlanEntity.getMasterPlanDetailList();
        if (CollectionUtils.isNotEmpty(masterPlanDetailList)) {
            Map<Long, MasterPlanDetailEntity> map = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
            List<MasterPlanDetailEntity> list = new ArrayList<>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if(map.containsKey(detailEntity.getMaterialId())){
                    MasterPlanDetailEntity entity = map.get(detailEntity.getMaterialId());
                    if (isCommit) {
                        entity.setOrderNum(ComputeUtil.safeAdd(entity.getOrderNum(), detailEntity.getOrderNumSum()));
                    }else {
                        entity.setOrderNum(ComputeUtil.safeSub(entity.getOrderNum(), detailEntity.getOrderNumSum()));
                    }
                    list.add(entity);
                }
            }
            if (CollectionUtils.isNotEmpty(list)) {
                masterPlanDetailService.saveOrUpdateBatch(list);
            }
        }
    }

    /*
     * 关闭查询验收-对比-回显计划
     * */
    @Override
    public CommonResponse<String> close(Long orderId) {
        OrderEntity orderEntity = super.selectById(orderId);
        CommonResponse<String> res = updatePushBill(orderEntity, "EJCBT202407000004", UPDATE_BILL_SERVER_URL);
        orderEntity.setOrderFlag(OrderFlagEnum.已关闭.getCode());//修改状态为关闭

        List<OrderDetailEntity> orderDetailList = orderEntity.getOrderDetailList();
        MonthPlanEntity monthPlanEntity = monthPlanService.selectById(orderDetailList.get(0).getSourceId());
        List<MonthPlanDetailEntity> monthPlanDetailList = monthPlanEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(monthPlanDetailList)) {
            Map<Long, MonthPlanDetailEntity> map = monthPlanDetailList.stream().collect(Collectors.toMap(MonthPlanDetailEntity::getId, Function.identity(), (key1, key2) -> key1));
            List<MonthPlanDetailEntity> list = new ArrayList<>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if(map.containsKey(detailEntity.getSourceDetailId())){
                    MonthPlanDetailEntity entity = map.get(detailEntity.getSourceDetailId());
                    entity.setOrderNum(ComputeUtil.safeAdd(entity.getOrderNum(), ComputeUtil.safeSub(detailEntity.getCheckNumsSum(), detailEntity.getOrderNumSum())));
                    list.add(entity);
                }
            }
            if (CollectionUtils.isNotEmpty(list)) {
                monthPlanDetailService.saveOrUpdateBatch(list);
            }
        }

        LambdaQueryWrapper<MasterPlanEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, orderEntity.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        MasterPlanEntity planEntity = masterPlanService.getOne(queryWrapper, false);
        MasterPlanEntity masterPlanEntity = masterPlanService.selectById(planEntity.getId());
        List<MasterPlanDetailEntity> masterPlanDetailList = masterPlanEntity.getMasterPlanDetailList();
        if (CollectionUtils.isNotEmpty(masterPlanDetailList)) {
            Map<Long, MasterPlanDetailEntity> map = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
            List<MasterPlanDetailEntity> list = new ArrayList<>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if(map.containsKey(detailEntity.getMaterialId())){
                    MasterPlanDetailEntity entity = map.get(detailEntity.getMaterialId());
                    entity.setOrderNum(ComputeUtil.safeAdd(entity.getOrderNum(), ComputeUtil.safeSub(detailEntity.getCheckNumsSum(), detailEntity.getOrderNumSum())));
                    list.add(entity);
                }
            }
            if (CollectionUtils.isNotEmpty(list)) {
                masterPlanDetailService.saveOrUpdateBatch(list);
            }
        }
        super.updateById(orderEntity);
        return CommonResponse.success("关闭成功");
    }

    /*
     * 提交推送供方
     */
    @Override
    public boolean pushBillToSupCenter(OrderEntity orderEntity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + orderEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", orderEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        orderEntity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupOrderVO supOrderVO = BeanMapper.map(orderEntity, SupOrderVO.class);
            List<SupOrderDetailVO> supOrderDetailVOS = BeanMapper.mapList(orderEntity.getOrderDetailList(), SupOrderDetailVO.class);
            supOrderVO.setOrderDetailList(supOrderDetailVOS);
            paramMap.put("order", JSONObject.toJSONString(supOrderVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(orderEntity.getId(), "EJCBT202407000004", "material-order-attaches", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送计量单据参数-{}", orderEntity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        orderEntity.getSupplierId().toString(),
                        files);
                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
//                if (syncReqResp.isSuccess()) {
//                    JSONObject jsonObject = JSONObject.parseObject(syncReqResp.getData());
//                    // 如果返回的结果包含code
//                    if(StringUtils.isNotEmpty(syncReqResp.getData())&& jsonObject.containsKey("code")){
//                        CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
//                        if (billPushResp.isSuccess()) {
//                            syncFlag = true;
//                        } else {
//                            logger.error("供方id-{}处理推送订单单据id-{}失败, {}", orderEntity.getSupplierId(), orderEntity.getId(), billPushResp.getMsg());
//                            throw new BusinessException(billPushResp.getMsg());
//                        }
//                    }else {
//                        throw new BusinessException();
//                    }
//
//                } else {
//                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", orderEntity.getId(), orderEntity.getSupplierId(), syncReqResp.getMsg());
//                    throw new BusinessException(syncReqResp.getMsg());
//                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", orderEntity.getId(), fileResp.getMsg());
                throw new BusinessException(fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", orderEntity.getId(), orderEntity.getSupplierId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(OrderEntity orderEntity, String billTypeCode, String url) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + orderEntity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", orderEntity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        orderEntity.setSystemId(ejcCloudSystemCode.getData());

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", orderEntity.getId().toString());
            paramMap.put("systemId", orderEntity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", orderEntity.getSupplierId(), orderEntity.getId());

            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    orderEntity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", orderEntity.getSupplierId(), orderEntity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", orderEntity.getSupplierId(), orderEntity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", orderEntity.getId(), e);
            throw e;
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId, OrderEntity orderEntity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


//        if (messageType.contains("wjy")) {
//            JSONObject wjyMsgParams  = new JSONObject();
//            wjyMsgParams.put("appid", appid);
//            wjyMsgParams.put("from", "供方平台");
//            wjyMsgParams.put("msg", subject);
//            wjyMsgParams.put("url", wjyPath+"cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id="+orderEntity.getId()+"&userid={userid}");
//            parameter.setWjyMsgParams(wjyMsgParams);
//        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
