package com.ejianc.wzxt.plan.controller.api;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 月
 */
@Controller
@RequestMapping("api/plan/")
public class PlanApiController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;

    /**
     *
     */
    @RequestMapping(value = "getMasterByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> getMasterByProjectId(@RequestParam(value = "projectId") Long projectId) {

        //获取项目下物资分类id
        LambdaQueryWrapper<MasterPlanEntity> lambdaQueryWrapper = Wrappers.<MasterPlanEntity>lambdaQuery();
        lambdaQueryWrapper.eq(MasterPlanEntity::getProjectId, projectId);
        lambdaQueryWrapper.in(MasterPlanEntity::getBillState, 1,3);
        MasterPlanEntity masterPlanEntity = masterPlanService.getOne(lambdaQueryWrapper);
        Map<Long, BigDecimal> numMap = new HashMap<>();
        if (masterPlanEntity != null) {
            Long id = masterPlanEntity.getId();
            LambdaQueryWrapper<MasterPlanDetailEntity> lambdaQuery = Wrappers.<MasterPlanDetailEntity>lambdaQuery();
            lambdaQuery.eq(MasterPlanDetailEntity::getMaterialMasterPlanId, id);
            List<MasterPlanDetailEntity> masterPlanDetailEntities = masterPlanDetailService.list(lambdaQuery);
            if(CollectionUtils.isNotEmpty(masterPlanDetailEntities)){
                numMap = masterPlanDetailEntities.stream().collect(Collectors.groupingBy(MasterPlanDetailEntity::getMaterialCategoryId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanTotalNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
        }
        return CommonResponse.success("查询成功！",numMap);
    }

}
