package com.ejianc.wzxt.plan.service.impl;

import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.enums.ChangeTypeEnum;
import com.ejianc.wzxt.plan.service.IMasterPlanChangeService;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.vo.MasterPlanContrastVO;
import com.ejianc.wzxt.plan.vo.MasterPlanDetailVO;
import com.ejianc.wzxt.plan.vo.MasterPlanVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MasterPlanMapper;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 材料总控计划-主表
 * 
 * @author generator
 * 
 */
@Service("masterPlanService")
public class MasterPlanServiceImpl extends BaseServiceImpl<MasterPlanMapper, MasterPlanEntity> implements IMasterPlanService{
    private static final String BILL_CODE = "ZJKJ_MASTER_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IMasterPlanChangeService masterPlanChangeService;

    @Autowired
    private MasterPlanMapper masterPlanMapper;


    @Override
    public MasterPlanVO saveOrUpdate(MasterPlanVO saveOrUpdateVO) {

        MasterPlanEntity entity = BeanMapper.map(saveOrUpdateVO, MasterPlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setPlanCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(null == saveOrUpdateVO.getId()) {
            entity.setId(IdWorker.getId());
            //设置为未变更
            entity.setChangeState(0);
            //设置为自由态
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            entity.setChangeVersion(1);
            //设置编制人
//            saveEntity.setCreateUserName(userContext.getUserName());
        }
        List<MasterPlanDetailEntity> detailEntities = entity.getMasterPlanDetailList();
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            for (MasterPlanDetailEntity masterPlanDetailEntity : detailEntities) {
                masterPlanDetailEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
        }

        super.saveOrUpdate(entity, false);
        MasterPlanVO vo = BeanMapper.map(entity, MasterPlanVO.class);
        return vo;
    }

    @Override
    public MasterPlanVO queryDetail(Long id) {

        MasterPlanEntity masterPlanEntity = super.selectById(id);
        MasterPlanVO masterPlanVO =  BeanMapper.map(masterPlanEntity, MasterPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MasterPlanDetailEntity> detailEntityListDb = masterPlanDetailService.queryList(queryParam, false);
        List<MasterPlanDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(MasterPlanDetailEntity cdEntity : detailEntityList){
                cdEntity.setRowState("edit");
            }
            List<MasterPlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class);
            masterPlanVO.setMasterPlanDetailList(resultMapList);

        } else {
            masterPlanVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class));
        }

        if(null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0){
            //masterPlanVO.setRecordList(masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
            masterPlanVO.setMasterPlanChangeHisList(masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }
        return masterPlanVO;

    }

    @Override
    public List<MasterPlanContrastVO> getContrastInfo(Long materialMasterPlanId, Long oldMaterialMasterPlanId) {
        return  masterPlanMapper.getContrastInfo(materialMasterPlanId,oldMaterialMasterPlanId);
    }

}
