package com.ejianc.wzxt.supplier.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.wzxt.supplier.bean.EvalMonthlyScoreEntity;
import com.ejianc.wzxt.supplier.service.IEvalMonthlyScoreService;
import com.ejianc.wzxt.supplier.vo.EvalMonthlyScoreVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.wzxt.supplier.bean.EvalMonthlyEntity;
import com.ejianc.wzxt.supplier.service.IEvalMonthlyService;
import com.ejianc.wzxt.supplier.vo.EvalMonthlyVO;

/**
 * 供应商月度评价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("evalMonthly")
public class EvalMonthlyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private static final String BILL_CODE = "zjkj-wzxt-supplier-monthly-eval001";//此处需要根据实际修改
    private static final DateFormat sdf = new SimpleDateFormat("yyyy-MM");
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IEvalMonthlyService service;
    @Autowired
    private IEvalMonthlyScoreService scoreService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EvalMonthlyVO> saveOrUpdate(@RequestBody EvalMonthlyVO saveOrUpdateVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        queryParam.getParams().put("period", new Parameter(QueryParam.EQ, saveOrUpdateVO.getPeriod()));
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getContractId()));
        List<EvalMonthlyEntity> list = service.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.error("合同【"+saveOrUpdateVO.getContractName() +"】已存在周期为【"+sdf.format(list.get(0).getPeriod())+"】的月度评价记录，单据编码是【"+list.get(0).getCode()+"】！");
        }
    	EvalMonthlyEntity entity = BeanMapper.map(saveOrUpdateVO, EvalMonthlyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	EvalMonthlyVO vo = BeanMapper.map(entity, EvalMonthlyVO.class);
        queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getOrderMap().put("rowNum",QueryParam.ASC);
        List<EvalMonthlyScoreEntity> scoreEntities = scoreService.queryList(queryParam,false);
        vo.setEvalMonthlyScoreList(BeanMapper.mapList(scoreEntities, EvalMonthlyScoreVO.class));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EvalMonthlyVO> queryDetail(Long id) {
    	EvalMonthlyEntity entity = service.selectById(id);
    	EvalMonthlyVO vo = BeanMapper.map(entity, EvalMonthlyVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getOrderMap().put("rowNum",QueryParam.ASC);
        List<EvalMonthlyScoreEntity> scoreEntities = scoreService.queryList(queryParam,false);
        vo.setEvalMonthlyScoreList(BeanMapper.mapList(scoreEntities, EvalMonthlyScoreVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EvalMonthlyVO> vos) {
        service.removeByIds(vos.stream().map(EvalMonthlyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EvalMonthlyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<EvalMonthlyEntity> page = service.queryPage(param,false);
        IPage<EvalMonthlyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EvalMonthlyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 根据合同ID查询评估月报列表。
     * 该方法通过GET请求访问，路径为/queryListByContractId，用于根据提供的合同ID检索相关的评估月报列表。
     * @param contractId 合同ID，作为查询条件，指定要查询的合同。
     * @return CommonResponse对象，包含查询结果列表和操作成功的信息。
     */
    @RequestMapping(value = "/queryListByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<EvalMonthlyVO>> queryListByContractId(@RequestParam Long contractId) {
        // 创建查询参数对象，并设置查询条件为合同ID
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,2,3,5"));
        // 设置排序条件为按期数降序
        param.getOrderMap().put("period", QueryParam.DESC);
        // 执行查询，获取原始数据列表
        List<EvalMonthlyEntity> page = service.queryList(param, false);
        // 将原始数据列表映射为视图对象列表
        List<EvalMonthlyVO> pageData = null;
        if (ListUtil.isNotEmpty(page)) {
            pageData = BeanMapper.mapList(page, EvalMonthlyVO.class);
        }
        // 返回查询结果，包含成功信息和映射后的数据列表
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EvalMonthlyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EvalMonthly-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEvalMonthlyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EvalMonthlyVO>> refEvalMonthlyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EvalMonthlyEntity> page = service.queryPage(param,false);
        IPage<EvalMonthlyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EvalMonthlyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
