package com.ejianc.wzxt.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.wzxt.supplier.bean.EvalMonthlyEntity;
import com.ejianc.wzxt.supplier.bean.EvalSeasonEntity;
import com.ejianc.wzxt.supplier.bean.EvalYearEntity;
import com.ejianc.wzxt.supplier.mapper.EvalYearMapper;
import com.ejianc.wzxt.supplier.service.IEvalMonthlyService;
import com.ejianc.wzxt.supplier.service.IEvalSeasonService;
import com.ejianc.wzxt.supplier.service.IEvalYearService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 分供方半年度履约评价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("halfYear")
public class HalfYearPromiseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private EvalYearMapper evalYearMapper;
    @Autowired
    private IEvalYearService yearService;
    @Autowired
    private IEvalMonthlyService monthlyService;
    @Autowired
    private IEvalSeasonService seasonService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/queryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryData(@RequestParam(required = false) String searchText,
                                                      @RequestParam String year,
                                                      @RequestParam(required = false) String halfYear) {
        CommonResponse<List<JSONObject>> response = new CommonResponse<>();
        if(StringUtils.isEmpty(year)){
            return response;
        }
        String yearDate = year+"-01-01";
        String betweenStartDateStr = year+"-01-01";
        String betweenEndDateStr = year+"-06-30";
        String seasonInDateStr = "'一季度','二季度'";
        if(StringUtils.isNotEmpty(halfYear)){
            if(halfYear.equals("下")){
                betweenStartDateStr = year+"-07-01";
                betweenEndDateStr = year+"-12-31";
                seasonInDateStr = "'三季度','四季度'";
            }
        }
        List<JSONObject> list = evalYearMapper.queryHalfYearPromiseList(searchText,yearDate,betweenStartDateStr,betweenEndDateStr,seasonInDateStr);
        List<JSONObject> result = Lists.newArrayList();
        if(ListUtil.isNotEmpty(list)){
            Map<Long,List<JSONObject>> supplierMap = Maps.newConcurrentMap();
            Map<Long,BigDecimal> supplierInfoMap = Maps.newConcurrentMap();
            for (JSONObject jsonObject : list){
                Long supplierId = jsonObject.getLong("supplierId");
                List<JSONObject> contractList = supplierMap.get(supplierId);
                //处理供应商年度资质评分
                if(ListUtil.isEmpty(contractList)){
                    contractList = Lists.newArrayList();
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("supplierId", Parameter.getEqInstance(supplierId));
                    queryParam.getParams().put("period", Parameter.getEqInstance(yearDate));
                    queryParam.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
                    List<EvalYearEntity> entityList = yearService.queryList(queryParam,false);
                    if(ListUtil.isEmpty(entityList)){
                        supplierInfoMap.put(supplierId,new BigDecimal(0));
                    }else {
                        supplierInfoMap.put(supplierId,entityList.get(0).getScoreTotal());
                    }

                }
                //处理合同月度季度评价得分均值
                if(StringUtils.isNotEmpty(jsonObject.getString("contractId"))){
                    //月度数据处理
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("contractId", Parameter.getEqInstance(jsonObject.getString("contractId")));
                    queryParam.getParams().put("period", new Parameter(QueryParam.BETWEEN,betweenStartDateStr+","+betweenEndDateStr));
                    queryParam.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
                    List<EvalMonthlyEntity> monthlyEntities = monthlyService.queryList(queryParam,false);
                    if(ListUtil.isNotEmpty(monthlyEntities)){
                        BigDecimal scoreTotal = new BigDecimal(0);
                        for (EvalMonthlyEntity monthlyEntity : monthlyEntities) {
                            scoreTotal = scoreTotal.add(monthlyEntity.getScoreTotal());
                        }
                        scoreTotal = scoreTotal.divide(new BigDecimal(monthlyEntities.size()),2, RoundingMode.HALF_UP);
                        jsonObject.put("monthlyScoreAvg",scoreTotal);
                    }else {
                        jsonObject.put("monthlyScoreAvg",0);
                    }
                    //季度数据处理
                    queryParam.getParams().put("period", Parameter.getEqInstance(yearDate));

                    seasonInDateStr = "一季度,二季度";
                    if(StringUtils.isNotEmpty(halfYear)){
                        if(halfYear.equals("下")){
                            seasonInDateStr = "三季度,四季度";
                        }
                    }

                    queryParam.getParams().put("season", new Parameter(QueryParam.IN,seasonInDateStr));
                    List<EvalSeasonEntity> seasonEntities = seasonService.queryList(queryParam,false);
                    if(ListUtil.isNotEmpty(seasonEntities)){
                        BigDecimal scoreTotal = new BigDecimal(0);
                        for (EvalSeasonEntity seasonEntity : seasonEntities) {
                            scoreTotal = scoreTotal.add(seasonEntity.getScoreTotal());
                        }
                        scoreTotal = scoreTotal.divide(new BigDecimal(seasonEntities.size()),2, RoundingMode.HALF_UP);
                        jsonObject.put("seasonScoreAvg",scoreTotal);
                    }else {
                        jsonObject.put("seasonScoreAvg",0);
                    }
                    jsonObject.put("zzScore",supplierInfoMap.get(supplierId));
                    //计算该条数据的 半年度履约得分 = 月度得分*0.6 + 季度得分*0.3 + 资质评分*0.1 保留两位小数
                    BigDecimal halfYearScore = jsonObject.getBigDecimal("monthlyScoreAvg").multiply(new BigDecimal("0.6")).add(jsonObject.getBigDecimal("seasonScoreAvg").multiply(new BigDecimal("0.3"))).add(jsonObject.getBigDecimal("zzScore").multiply(new BigDecimal("0.1"))).setScale(2,RoundingMode.HALF_UP);
                    jsonObject.put("halfYearScore",halfYearScore);
                }else {
                    jsonObject.put("monthlyScoreAvg",0);
                    jsonObject.put("seasonScoreAvg",0);
                    jsonObject.put("zzScore",supplierInfoMap.get(supplierId));
                    BigDecimal halfYearScore = jsonObject.getBigDecimal("zzScore").multiply(new BigDecimal("0.1")).setScale(2,RoundingMode.HALF_UP);
                    jsonObject.put("halfYearScore",halfYearScore);
                }
                contractList.add(jsonObject);
                supplierMap.put(supplierId,contractList);
            }
            //循环 supplierMap
            int rowNum = 1;
            for (Long supplierId : supplierMap.keySet()) {
                List<JSONObject> contractList = supplierMap.get(supplierId);
                // 计算供应商 半年度综合得分 = 半年度履约得分总和/评价合同份数
                BigDecimal halfYearScoreTotal = new BigDecimal(0);
                for (JSONObject jsonObject : contractList) {
                    halfYearScoreTotal = halfYearScoreTotal.add(jsonObject.getBigDecimal("halfYearScore"));
                }
                halfYearScoreTotal = halfYearScoreTotal.divide(new BigDecimal(contractList.size()),2, RoundingMode.HALF_UP);
                for (int i = 0; i < contractList.size(); i++) {
                    JSONObject jsonObject = contractList.get(i);
                    jsonObject.put("halfYearScoreTotal",halfYearScoreTotal);
                    jsonObject.put("rowNum",rowNum);
                    if(i == 0){
                        jsonObject.put("supplierRow",contractList.size());
                    }else {
                        jsonObject.put("supplierRow",0);
                    }
                    result.add(jsonObject);
                    rowNum++;
                }
            }
        }
    	return CommonResponse.success("保存或修改单据成功！",result);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/queryDataList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryDataList(@RequestBody QueryParam queryParam) {
        if(queryParam.getParams().get("year") == null){
            return CommonResponse.success("查询条件为空！",new ArrayList<>());
        }
        String year = queryParam.getParams().get("year").getValue().toString();
        String halfYear = queryParam.getParams().get("halfYear") == null ? null :queryParam.getParams().get("halfYear").getValue().toString();
        String searchText = queryParam.getSearchText() == null ? null :queryParam.getSearchText();
    	return queryData(searchText, year, halfYear);
    }

}
