package com.ejianc.wzxt.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailChangeEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.vo.MasterPlanChangeHisVO;
import com.ejianc.wzxt.plan.vo.MasterPlanChangeVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MasterPlanChangeMapper;
import com.ejianc.wzxt.plan.bean.MasterPlanChangeEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanChangeService;

import java.util.ArrayList;
import java.util.List;

/**
 * 材料总控计划变更-主表
 * 
 * @author generator
 * 
 */
@Service("masterPlanChangeService")
public class MasterPlanChangeServiceImpl extends BaseServiceImpl<MasterPlanChangeMapper, MasterPlanChangeEntity> implements IMasterPlanChangeService{
    @Autowired
    private IMasterPlanChangeService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private MasterPlanChangeMapper planChangeMapper;

    @Autowired
    private IMasterPlanService masterPlanService;


    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_MASTER_PLAN_CHANGE";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Override
    public MasterPlanChangeVO saveOrUpdate(MasterPlanChangeVO planVo) {
        //校验项目是否存在未完成的变更计划单存在
        MasterPlanChangeEntity planChangeEntity = service.getUnFinishedChange(planVo.getSourcePlanId());

        if (null != planChangeEntity && (null == planVo.getId() || !planChangeEntity.getId().equals(planVo.getId()))) {
            throw new BusinessException("保存失败，该项目存在未完成的材料总计划变更单！");
        }
        MasterPlanEntity masterPlan = masterPlanService.getById(planVo.getSourcePlanId());
        UserContext userContext = sessionManager.getUserContext();
        MasterPlanChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = BeanMapper.map(planVo, MasterPlanChangeEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());

//            saveEntity.setPlanCode(masterPlan.getPlanCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());

        }
        else {
            saveEntity = service.getById(planVo.getId());
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
//            saveEntity.setPlanCode(planVo.getPlanCode());
//            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMasterPlanDetailList(BeanMapper.mapList(planVo.getMasterPlanDetailList(), MasterPlanDetailChangeEntity.class));
        }

        //保存前清空主键和父主键，重新生成
        List<MasterPlanDetailChangeEntity> beforeDetails = saveEntity.getMasterPlanDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == saveEntity.getId()) {
            for (MasterPlanDetailChangeEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
            }
        }


//        MasterPlanChangeEntity entity = BeanMapper.map(planVo, MasterPlanChangeEntity.class);
        if(saveEntity.getId() == null || saveEntity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),planVo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                saveEntity.setPlanCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        service.saveOrUpdate(saveEntity, false);
        MasterPlanChangeVO vo = BeanMapper.map(saveEntity, MasterPlanChangeVO.class);
        return vo;
    }


    @Override
    public MasterPlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper<MasterPlanChangeEntity> query = new QueryWrapper<>();
        query.eq("source_plan_id", sourcePlanId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return planChangeMapper.selectOne(query);
    }

    @Override
    public List<MasterPlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<MasterPlanChangeEntity> lambda = Wrappers.<MasterPlanChangeEntity>lambdaQuery();
        lambda.eq(MasterPlanChangeEntity::getSourcePlanId, id);
        lambda.in(MasterPlanChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<MasterPlanChangeEntity> entities = super.list(lambda);
        List<MasterPlanChangeHisVO> recordVOList = BeanMapper.mapList(entities, MasterPlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-0" + recordVO.getChangeVersion());
            }else {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-" + recordVO.getChangeVersion());
            }
            recordVO.setChangeCode(recordVO.getPlanCode());
                }
        );
        return recordVOList;
    }

}
