package com.ejianc.wzxt.plan.service.impl;

import com.ejianc.wzxt.plan.mapper.MasterPlanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MasterPlanDetailMapper;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;

import java.util.List;

/**
 * 材料总控计划-子表
 * 
 * @author generator
 * 
 */
@Service("masterPlanDetailService")
public class MasterPlanDetailServiceImpl extends BaseServiceImpl<MasterPlanDetailMapper, MasterPlanDetailEntity> implements IMasterPlanDetailService{

    @Autowired
    private MasterPlanDetailMapper masterPlanDetailMapper;

    @Autowired
    private MasterPlanMapper masterPlanMapper;

    @Override
    public void delByPlanIdAndDetailIds(List<Long> delDetailIds, Long planId) {
        if(CollectionUtils.isNotEmpty(delDetailIds)) {
            masterPlanDetailMapper.delByPlanIdAndDetailIds(delDetailIds, planId);
        }
    }
}
