package com.ejianc.wzxt.supplier.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商资质评价
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_year_evaluate")
public class EvalYearEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="period")
    private Date period; // 年份
    @TableField(value="score_total")
    private BigDecimal scoreTotal; // 评估总得分
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_id")
    private Long createUserId; // 编制人id
    @TableField(value="create_user_name")
    private String createUserName; // 编制人名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="evalYearScoreService")
    private List<EvalYearScoreEntity> evalYearScoreList = new ArrayList<>(); // 供应商资质评价得分
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getPeriod() {
        return period;
    }

    public void setPeriod(Date period) {
        this.period = period;
    }
    public BigDecimal getScoreTotal() {
        return scoreTotal;
    }

    public void setScoreTotal(BigDecimal scoreTotal) {
        this.scoreTotal = scoreTotal;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    

    public List<EvalYearScoreEntity> getEvalYearScoreList() {
        return evalYearScoreList;
    }

    public void setEvalYearScoreList(List<EvalYearScoreEntity> evalYearScoreList) {
        this.evalYearScoreList = evalYearScoreList;
    }
}
