package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.wzxt.plan.bean.*;
import com.ejianc.wzxt.plan.service.*;
import com.ejianc.wzxt.plan.vo.MonthPlanChangeDetailVO;
import com.ejianc.wzxt.plan.vo.MonthPlanVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("monthPlanChange") 
public class MonthPlanChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IMonthPlanChangeService monthPlanChangeService;
	@Autowired
	private IMonthPlanDetailService monthPlanDetailService;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IMasterPlanDetailService masterPlanDetailService;


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IMonthPlanService monthPlanService;

	@Autowired
	private IMonthPlanChangeHisService monthPlanChangeHisService;

	@Autowired
	private IMasterPlanService masterPlanService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//此处billId即为单据Id
		MonthPlanChangeEntity entity =monthPlanChangeService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		//设置提交人信息
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(userContext.getUserCode());
		entity.setCommitUserName(userContext.getUserName());

		monthPlanChangeService.saveOrUpdate(entity, false);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("总计划变更撤回回调处理：billId: {}, state: {}", billId, state);
		MonthPlanChangeEntity planChange = monthPlanChangeService.selectById(billId);

		//清空总计划变更提交人信息
		planChange.setCommitUserName(null);
		planChange.setCommitUserCode(null);
		planChange.setCommitDate(null);

		monthPlanChangeService.saveOrUpdate(planChange, false);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("总计划变更审批完成回调处理：billId: {}, state: {}", billId, state);
		//查询变更计划
		MonthPlanChangeEntity planChange = monthPlanChangeService.selectById(billId);
		MonthPlanEntity newPlanEntity = null;
		//查询原计划
		MonthPlanEntity oldPlan = monthPlanService.selectById(planChange.getSourcePlanId());
		//变更计划附件复制到主计划
		CommonResponse<String> stringCommonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "EJCBT202408000002", "materPlan001", String.valueOf(oldPlan.getId()), "EJCBT202408000001", "materPlan001");
		if(!stringCommonResponse.isSuccess()){
			logger.info("消耗材变更附件复制到主附件------", JSONObject.toJSONString(stringCommonResponse));
		}else {
			logger.info("消耗材更附件复制到主附件------", JSONObject.toJSONString(stringCommonResponse));
		}
		/*处理变更计划主表信息*/
		if(state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
			//直审时记录
			UserContext userContext = sessionManager.getUserContext();
			//设置提交人信息
			planChange.setCommitDate(new Date());
			planChange.setCommitUserCode(userContext.getUserCode());
			planChange.setCommitUserName(userContext.getUserName());
		}

		//设置总计划变更单据生效时间
		planChange.setEffectiveDate(new Date());

		//1、复制计划信息到计划记录
		MonthPlanChangeHisEntity recordEntity = BeanMapper.map(oldPlan, MonthPlanChangeHisEntity.class);
		logger.info("总计划变更审批完成回调, 总计划变更信息：【{}】, 变更前总计划信息: 【{}】", JSON.toJSONString(planChange), JSON.toJSONString(oldPlan));

		//设置总计划Id
		recordEntity.setSourcePlanId(oldPlan.getId());
		//Id置为空
		recordEntity.setId(null);
		//子表处理
		if(CollectionUtils.isNotEmpty(recordEntity.getMonthPlanDetailList())) {
			recordEntity.getMonthPlanDetailList().stream().forEach(detail -> {
				detail.setTargetId(detail.getId());
				detail.setId(null);
			});
		}

		/*记录主表信息处理*/
		//设置编制人等信息
		recordEntity.setCreateUserCode(planChange.getCreateUserCode());
		recordEntity.setCreateTime(planChange.getCreateTime());
		recordEntity.setCreateUserName(planChange.getCreateUserName());
		recordEntity.setModifyUserName(planChange.getModifyUserName());
		recordEntity.setUpdateTime(planChange.getUpdateTime());
		recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
		recordEntity.setCommitDate(planChange.getCommitDate());
		recordEntity.setCommitUserCode(planChange.getCommitUserCode());
		recordEntity.setCommitUserName(planChange.getCommitUserName());
		recordEntity.setEffectiveDate(planChange.getEffectiveDate());
		recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
		recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
//		recordEntity.setTenderMny(planChange.getTenderMny());
//		recordEntity.setOriginaltenderMny(oldPlan.getTenderMny());
		recordEntity.setChangePlanId(planChange.getId());
		recordEntity.setChangeUserName(planChange.getChangeUserName());
		recordEntity.setChangeReason(planChange.getChangeReason());

		if(null == recordEntity.getTotalPlanAmt()) {
			recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
		}
		if(null == recordEntity.getOriginalPlanAmt()) {
			recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
		}
		recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
		if(recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
			recordEntity.setChangeRatio(0d);
		} else {
			recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
		}

//		//总计划变更记录保存
//		monthPlanChangeHisService.saveOrUpdate(recordEntity, false);
//总计划变更记录再次保存更新
		monthPlanChangeHisService.saveOrUpdate(recordEntity, false);

		//变更计划信息更新
		monthPlanChangeService.saveOrUpdate(planChange, false);

		//修改总计划字段  复制变更计划{回显原计划用}
		newPlanEntity = BeanMapper.map(planChange, MonthPlanEntity.class);
		/*
		 * 更新主表信息
		 * */
		//变更状态-已变更
		newPlanEntity.setChangeState(MonthPlanVO.PLAN_CHANGE_STATE_CHANGED);
		//清空当前变更计划id
		newPlanEntity.setCurChangingPlanId(null);
		//合同初始创建信息
		newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
		newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
		newPlanEntity.setCreateTime(oldPlan.getCreateTime());
		newPlanEntity.setId(oldPlan.getId());
		newPlanEntity.setVersion(oldPlan.getVersion());
		newPlanEntity.setChangeVersion(planChange.getChangeVersion());

		//子表信息设置

		List<Long> delDetailIds = new ArrayList<>();//原计划要删除的子表

		List<MonthPlanDetailEntity> updatePlanDetail = new ArrayList<>();//要更新的子表


		//		("变更类型: 1-增补项，2-删除项，3-变更项,0-未变更")
		List<MonthPlanDetailEntity> oldList = oldPlan.getMonthPlanDetailList();//原计划 子表
		Map<Long, MonthPlanDetailEntity> map1 = oldList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(MonthPlanDetailEntity::getId, item -> item, (v1, v2) -> v2));
		if(CollectionUtils.isNotEmpty(newPlanEntity.getMonthPlanDetailList())) {//遍历变更计划子表
			for (MonthPlanDetailEntity detail : newPlanEntity.getMonthPlanDetailList()) {
				if(detail.getChangeType()==2){//删除
					delDetailIds.add(detail.getTargetId());
				}else {
					if(null!=detail.getTargetId()){//修改
						if(map1.containsKey(detail.getTargetId())){
							MonthPlanDetailEntity monthPlanDetail = map1.get(detail.getTargetId());
							monthPlanDetail.setChangeType(detail.getChangeType());
//							monthPlanDetail.setTenderNum(detail.getTenderNum());
//							monthPlanDetail.setTenderPrice(detail.getTenderPrice());
//							monthPlanDetail.setTenderAmount(detail.getTenderAmount());
							monthPlanDetail.setPlanTotalNum(detail.getPlanTotalNum());
//							monthPlanDetail.setResponseSurplusNum(detail.getResponseSurplusNum());
							updatePlanDetail.add(monthPlanDetail);
						}

					}else {//新增
						detail.setId(null);
						updatePlanDetail.add(detail);
					}
				}
			}
		}

		if(CollectionUtils.isNotEmpty(updatePlanDetail)){
			monthPlanDetailService.saveOrUpdateBatch(updatePlanDetail);
		}
		newPlanEntity.setMonthPlanDetailList(updatePlanDetail);
		if(CollectionUtils.isNotEmpty(delDetailIds)){
			monthPlanDetailService.removeByIds(delDetailIds);//原计划删除
		}

		//回写总计中的月计划量,释放上月的月计划量
		MonthPlanChangeEntity monthPlanChangeEntity = monthPlanChangeService.selectById(billId);
		LambdaQueryWrapper<MonthPlanEntity> lambda = Wrappers.<MonthPlanEntity>lambdaQuery();
		lambda.eq(MonthPlanEntity::getProjectId, monthPlanChangeEntity.getProjectId());
		lambda.in(MonthPlanEntity::getBillState, 1,3);
		lambda.notIn(MonthPlanEntity::getId, monthPlanChangeEntity.getSourcePlanId());
		List<MonthPlanEntity> monthPlanEntities = monthPlanService.list(lambda);
		Map<Long, BigDecimal> orderNumMap = new HashMap<>();
		Map<Long, BigDecimal> selfCheckNumMap = new HashMap<>();

		if (CollectionUtils.isNotEmpty(monthPlanEntities)){
			List<Long> ids = monthPlanEntities.stream().map(MonthPlanEntity::getId).collect(Collectors.toList());

			LambdaQueryWrapper<MonthPlanDetailEntity> lambdaDetail = Wrappers.<MonthPlanDetailEntity>lambdaQuery();
			lambdaDetail.in(MonthPlanDetailEntity::getMaterialMonthPlanId, ids);
			List<MonthPlanDetailEntity> monthPlanDetailEntities = monthPlanDetailService.list(lambdaDetail);
			if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthPlanDetailEntities)){
				orderNumMap = monthPlanDetailEntities.stream().filter(s -> s.getOrderNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId,
						Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getOrderNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
				selfCheckNumMap = monthPlanDetailEntities.stream().filter(s -> s.getSelfCheckNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId,
						Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getSelfCheckNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
			}
		}

		//本期月计划量
		Map<Long, BigDecimal> planMonthNumMap = new HashMap<>();
		List<MonthPlanChangeDetailEntity> monthPlanDetailList = monthPlanChangeEntity.getMonthPlanDetailList();
		if (CollectionUtils.isNotEmpty(monthPlanDetailList)){
			planMonthNumMap = monthPlanDetailList.stream().filter(s -> s.getPlanMonthNum() != null).collect(Collectors.groupingBy(MonthPlanChangeDetailEntity::getMaterialId,
					Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanMonthNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
		}

		//回写总计划
		LambdaQueryWrapper<MasterPlanEntity> lambdaMaster = Wrappers.<MasterPlanEntity>lambdaQuery();
		lambdaMaster.eq(MasterPlanEntity::getProjectId, monthPlanChangeEntity.getProjectId());
		lambdaMaster.in(MasterPlanEntity::getBillState, 1,3);
		MasterPlanEntity masterPlanEntity = masterPlanService.getOne(lambdaMaster);
		if (masterPlanEntity != null){
			LambdaQueryWrapper<MasterPlanDetailEntity> lambdaMasterDetail = Wrappers.<MasterPlanDetailEntity>lambdaQuery();
			lambdaMasterDetail.in(MasterPlanDetailEntity::getMaterialMasterPlanId, masterPlanEntity.getId());
			List<MasterPlanDetailEntity> masterPlanDetailEntities = masterPlanDetailService.list(lambdaMasterDetail);
			if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(masterPlanDetailEntities)){
				for (MasterPlanDetailEntity masterPlanDetailEntity : masterPlanDetailEntities){
					BigDecimal planMonthNum = BigDecimal.ZERO;
					if (orderNumMap.containsKey(masterPlanDetailEntity.getMaterialId())){
						BigDecimal orderNum = orderNumMap.get(masterPlanDetailEntity.getMaterialId());
						planMonthNum = ComputeUtil.safeAdd(planMonthNum, orderNum);
					}
					if (orderNumMap.containsKey(masterPlanDetailEntity.getMaterialId())){
						BigDecimal selfCheckNum = selfCheckNumMap.get(masterPlanDetailEntity.getMaterialId());
						planMonthNum = ComputeUtil.safeAdd(planMonthNum, selfCheckNum);
					}
					if (planMonthNumMap.containsKey(masterPlanDetailEntity.getMaterialId())){
						BigDecimal planMonthNumNum = planMonthNumMap.get(masterPlanDetailEntity.getMaterialId());
						planMonthNum = ComputeUtil.safeAdd(planMonthNum, planMonthNumNum);
					}
					masterPlanDetailEntity.setPlanMonthNum(planMonthNum);
				}
				masterPlanDetailService.saveOrUpdateBatch(masterPlanDetailEntities);

			}
		}

		logger.info("回显原计划子表结束！");
		monthPlanService.saveOrUpdate(newPlanEntity, false);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		if(state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
			CommonResponse.success("有审批流程的变更总计划无法执行该操作！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("总计划变更弃审回调处理：billId: {}, state: {}", billId, state);
		MonthPlanChangeEntity planChange = monthPlanChangeService.selectById(billId);
//清空总计划变更提交人信息
		planChange.setCommitUserName(null);
		planChange.setCommitUserCode(null);
		planChange.setCommitDate(null);

		QueryWrapper<MonthPlanChangeHisEntity> hisQuery = new QueryWrapper<>();
		hisQuery.eq("change_plan_id", billId);
		MonthPlanChangeHisEntity hisEntity = monthPlanChangeHisService.getOne(hisQuery);
		if(null != hisEntity) {
			//数据恢复至审批完成前的数据状态
			MonthPlanEntity newPlanEntity = null;
			MonthPlanEntity oldPlan = monthPlanService.selectById(planChange.getSourcePlanId());

			logger.info("总计划执行弃审数据恢复逻辑，当前数据【{}】，待恢复数据【{}】", oldPlan, hisEntity);
			//数据恢复
			newPlanEntity = BeanMapper.map(hisEntity, MonthPlanEntity.class);
			newPlanEntity.setCurChangingPlanId(hisEntity.getChangePlanId());
			//恢复创建人等信息
			newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
			newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
			newPlanEntity.setCreateTime(oldPlan.getCreateTime());
			newPlanEntity.setId(oldPlan.getId());
			newPlanEntity.setVersion(oldPlan.getVersion());
			newPlanEntity.setChangeVersion(planChange.getChangeVersion());

			//变更状态-变更中
			newPlanEntity.setChangeState(MonthPlanVO.PLAN_CHANGE_STATE_CHANGING);
			//总计划金额
			newPlanEntity.setTotalPlanAmt(hisEntity.getOriginalPlanAmt());
			newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);

			//子表信息设置
			List<Long> delDetailIds = new ArrayList<>();
			if(CollectionUtils.isNotEmpty(planChange.getMonthPlanDetailList())) {
				List<MonthPlanDetailEntity> list = new ArrayList<>();
				MonthPlanDetailEntity tmp = null;
				Map<Long, Integer> map = oldPlan.getMonthPlanDetailList().stream().collect(Collectors.toMap(MonthPlanDetailEntity::getId, MonthPlanDetailEntity::getVersion));

				for(MonthPlanChangeDetailEntity detail : planChange.getMonthPlanDetailList()) {
					tmp = BeanMapper.map(detail, MonthPlanDetailEntity.class);

					if(null != detail.getTargetId()) {
						tmp.setVersion(map.get(detail.getTargetId()));
						tmp.setId(detail.getTargetId());
						if(detail.getChangeType().equals(MonthPlanChangeDetailVO.CHANGE_TYPE_ADD)) {
							//删除新增项
							delDetailIds.add(detail.getId());
						} else {
							list.add(tmp);
						}
					} else {
						//删除新增项
						delDetailIds.add(detail.getId());
					}
				}

				newPlanEntity.setMonthPlanDetailList(list);
			}

			//删除已有子表
			if(CollectionUtils.isNotEmpty(delDetailIds)) {
				monthPlanDetailService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
			}

			//删除变更记录
			monthPlanChangeHisService.removeById(hisEntity.getId(), false);

			monthPlanService.saveOrUpdate(newPlanEntity, false);
		}

		if(monthPlanChangeService.saveOrUpdate(planChange, false)) {
			return CommonResponse.success("回调业务处理成功！");
		}

		return CommonResponse.success();
	}

}
