package com.ejianc.wzxt.plan.service.impl;

import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.enums.ChangeTypeEnum;
import com.ejianc.wzxt.plan.service.IMonthPlanChangeService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailService;
import com.ejianc.wzxt.plan.vo.MonthPlanContrastVO;
import com.ejianc.wzxt.plan.vo.MonthPlanDetailVO;
import com.ejianc.wzxt.plan.vo.MonthPlanVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MonthPlanMapper;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.service.IMonthPlanService;

import java.util.ArrayList;
import java.util.List;

/**
 * 材料月计划-主表
 * 
 * @author generator
 * 
 */
@Service("monthPlanService")
public class MonthPlanServiceImpl extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity> implements IMonthPlanService{
    private static final String BILL_CODE = "MONTHPLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IMonthPlanChangeService monthPlanChangeService;

    @Autowired
    private MonthPlanMapper monthPlanMapper;


    @Override
    public MonthPlanVO saveOrUpdate(MonthPlanVO saveOrUpdateVO) {

        MonthPlanEntity entity = BeanMapper.map(saveOrUpdateVO, MonthPlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setPlanCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(null == saveOrUpdateVO.getId()) {
            entity.setId(IdWorker.getId());
            //设置为未变更
            entity.setChangeState(0);
            //设置为自由态
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            entity.setChangeVersion(1);
            //设置编制人
//            saveEntity.setCreateUserName(userContext.getUserName());
        }
        List<MonthPlanDetailEntity> detailEntities = entity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            for (MonthPlanDetailEntity monthPlanDetailEntity : detailEntities) {
                monthPlanDetailEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
        }

        super.saveOrUpdate(entity, false);
        MonthPlanVO vo = BeanMapper.map(entity, MonthPlanVO.class);
        return vo;
    }

    @Override
    public MonthPlanVO queryDetail(Long id) {

        MonthPlanEntity monthPlanEntity = super.selectById(id);
        MonthPlanVO monthPlanVO =  BeanMapper.map(monthPlanEntity, MonthPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMonthPlanId", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MonthPlanDetailEntity> detailEntityListDb = monthPlanDetailService.queryList(queryParam, false);
        List<MonthPlanDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(MonthPlanDetailEntity cdEntity : detailEntityList){
                cdEntity.setRowState("edit");
            }
            List<MonthPlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, MonthPlanDetailVO.class);
            monthPlanVO.setMonthPlanDetailList(resultMapList);

        } else {
            monthPlanVO.setMonthPlanDetailList(BeanMapper.mapList(detailEntityList, MonthPlanDetailVO.class));
        }

        if(null != monthPlanEntity.getChangeVersion() && monthPlanEntity.getChangeVersion() > 0){
            monthPlanVO.setMonthPlanChangeHisList(monthPlanChangeService.queryDetailRecord(monthPlanEntity.getId()));
        }
        return monthPlanVO;

    }

    @Override
    public List<MonthPlanContrastVO> getContrastInfo(Long materialMonthPlanId, Long oldMaterialMonthPlanId) {
        return  monthPlanMapper.getContrastInfo(materialMonthPlanId,oldMaterialMonthPlanId);
    }
}
