package com.ejianc.wzxt.supplier.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 供应商资质评价
 * 
 * @author generator
 * 
 */
public class EvalYearVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date period; // 年份
    private BigDecimal scoreTotal; // 评估总得分
    private String memo; // 备注
    private Integer billState; // 单据状态
    private Long createUserId; // 编制人id

    private List<EvalYearScoreVO> evalYearScoreList = new ArrayList<>(); // 供应商资质评价得分

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getPeriod() {
        return period;
    }

    public void setPeriod(Date period) {
        this.period = period;
    }
    public BigDecimal getScoreTotal() {
        return scoreTotal;
    }

    public void setScoreTotal(BigDecimal scoreTotal) {
        this.scoreTotal = scoreTotal;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getCreateUserId() {
        return createUserId;
    }

    @ReferDeserialTransfer
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

     public List<EvalYearScoreVO> getEvalYearScoreList() {
        return evalYearScoreList;
     }

     public void setEvalYearScoreList(List<EvalYearScoreVO> evalYearScoreList) {
        this.evalYearScoreList = evalYearScoreList;
     }
}
