package com.ejianc.wzxt.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.wzxt.plan.bean.MonthPlanChangeDetailEntity;
/**
 * 材料月计划变更-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_month_plan_change")
public class MonthPlanChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="plan_code")
    private String planCode; // 计划编码
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="change_user_name")
    private String changeUserName; // 变更人
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="total_plan_amt")
    private BigDecimal totalPlanAmt; // 现计划金额
    @TableField(value="original_plan_amt")
    private BigDecimal originalPlanAmt; // 原计划金额
    @TableField(value="source_plan_id")
    private Long sourcePlanId; // 源计划数据Id
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="modify_user_name")
    private String modifyUserName; // 修改人名称
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="operator_id")
    private Long operatorId; // 编制人
    @TableField(value="operator_name")
    private String operatorName; // 编制人
    @TableField(value="bill_date")
    private Date billDate; // 编制日期
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="plan_type")
    private Integer planType; // 计划类型（0-消耗材，1-混泥土）
    @TableField(value="plan_date")
    private Date planDate; // 申请日期
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="monthPlanChangeDetailService",pidName = "materialMonthPlanId")//此处有pid="xxx"，默认值pid="pid"
    private List<MonthPlanChangeDetailEntity> monthPlanDetailList = new ArrayList<>(); // 材料月计划变更-子表
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeUserName() {
        return changeUserName;
    }

    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public BigDecimal getTotalPlanAmt() {
        return totalPlanAmt;
    }

    public void setTotalPlanAmt(BigDecimal totalPlanAmt) {
        this.totalPlanAmt = totalPlanAmt;
    }
    public BigDecimal getOriginalPlanAmt() {
        return originalPlanAmt;
    }

    public void setOriginalPlanAmt(BigDecimal originalPlanAmt) {
        this.originalPlanAmt = originalPlanAmt;
    }
    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getPlanType() {
        return planType;
    }

    public void setPlanType(Integer planType) {
        this.planType = planType;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<MonthPlanChangeDetailEntity> getMonthPlanDetailList() {
        return monthPlanDetailList;
    }

    public void setMonthPlanDetailList(List<MonthPlanChangeDetailEntity> monthPlanDetailList) {
        this.monthPlanDetailList = monthPlanDetailList;
    }
}
