package com.ejianc.wzxt.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.wzxt.plan.bean.SmallPlanDetailEntity;
/**
 * 零星材料计划-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_small_plan")
public class SmallPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="plan_code")
    private String planCode; // 计划编码
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="operator_id")
    private Long operatorId; // 编制人
    @TableField(value="operator_name")
    private String operatorName; // 编制人
    @TableField(value="bill_date")
    private Date billDate; // 编制日期
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="plan_date")
    private Date planDate; // 计划时间
    @TableField(value="org_code")
    private String orgCode; // 项目部编码

    @TableField(exist=false)
    @SubEntity(serviceName="smallPlanDetailService",pidName = "smallId")//此处有pid="xxx"，默认值pid="pid"
    private List<SmallPlanDetailEntity> smallPlanDetailList = new ArrayList<>(); // 零星材料计划-子表
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    
    public List<SmallPlanDetailEntity> getSmallPlanDetailList() {
        return smallPlanDetailList;
    }

    public void setSmallPlanDetailList(List<SmallPlanDetailEntity> smallPlanDetailList) {
        this.smallPlanDetailList = smallPlanDetailList;
    }
}
