package com.ejianc.wzxt.plan.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeEntity;
import com.ejianc.wzxt.plan.vo.MonthPlanChangeHisVO;
import com.ejianc.wzxt.plan.vo.MonthPlanChangeVO;

import java.util.List;

/**
 * 材料月计划变更-主表
 * 
 * @author generator
 * 
 */
public interface IMonthPlanChangeService extends IBaseService<MonthPlanChangeEntity> {
    MonthPlanChangeVO saveOrUpdate(MonthPlanChangeVO saveOrUpdateVO);
    /**
     * 查询指定计划对应的未完成的变更
     *
     * @param sourcePlanId
     * @return
     */
    MonthPlanChangeEntity getUnFinishedChange(Long sourcePlanId);


    List<MonthPlanChangeHisVO> queryDetailRecord(Long id);

    /**
     * 根据Id删除对应的变更单据，并恢复计划单据的变更信息
     *
     * @param changeIds
     */
    void deleteChangePlan(List<Long> changeIds);
}
