/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.material.api.IMaterialapproachApi;
import com.ejianc.foundation.material.vo.MaterialapproachVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.check.service.ICheckService;
import com.ejianc.wzxt.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.wzxt.check.vo.SupplierPushCheckVO;
import com.ejianc.wzxt.delivery.service.IDeliveryService;
import com.ejianc.wzxt.enums.BillPushStatusEnum;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IMaterialapproachApi materialapproachApi;
    private final String OPERATE = "ZJKJ_CHECK_SYNC";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IDeliveryService deliveryService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "EJCBT202407000006";
    private final String PUSH_DELETE_URL = "/zjkj-supbusiness-web/openapi/check/deleteCheck";
    private final String PUSH_SAVE_URL = "/zjkj-supbusiness-web/openapi/check/saveCheck";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        checkEntity.setCheckState(1);
        SupplierPushCheckVO supplierPushCheckVO = (SupplierPushCheckVO)BeanMapper.map((Object)((Object)checkEntity), SupplierPushCheckVO.class);
        supplierPushCheckVO.setSourceId(checkEntity.getId());
        List checkDetailList = supplierPushCheckVO.getCheckDetailList();
        for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
            supplierPushCheckDetailVO.setSourceId(checkEntity.getId());
            supplierPushCheckDetailVO.setSourcedetailId(supplierPushCheckDetailVO.getId());
            supplierPushCheckDetailVO.setId(null);
        }
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        } else {
            supplierPushCheckVO.setSystemId((String)ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString((Object)supplierPushCheckVO);
            boolean b = this.checkService.pushBillToSupCenter(dataInfo, checkEntity.getSupplierId(), checkEntity.getId(), BILL_TYPE, null, "/zjkj-supbusiness-web/openapi/check/saveCheck");
            if (!b) {
                this.logger.error("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)dataInfo);
            } else {
                checkEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            }
        }
        this.checkService.updateById((Object)checkEntity);
        this.checkService.pushMaterial(checkEntity);
        this.checkService.writeBackPlan(checkEntity, true);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if (checkEntity.getSignStatus() == 1) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5df2\u7b7e\u5b57,\u65e0\u6cd5\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        CommonResponse response = this.materialapproachApi.queryByCheckId(billId);
        if (response.isSuccess() && null != response.getData() && 1 == ((MaterialapproachVO)response.getData()).getUseFlag()) {
            throw new BusinessException("\u8be5\u5355\u636e\u5bf9\u5e94\u5546\u52a1\u7cfb\u7edf\u4e2d\u7684\u3010\u7269\u8d44\u8fdb\u573a\u9a8c\u8bc1\u8bb0\u5f55\u3011\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(checkEntity.getBillPushFlag())) {
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(billId, dataInfo, "/zjkj-supbusiness-web/openapi/check/deleteCheck", RequestMethod.POST, checkEntity.getSupplierId().toString(), "ZJKJ_CHECK_SYNC", BILL_TYPE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
            checkEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.checkService.saveOrUpdate((Object)checkEntity, false);
            this.materialapproachApi.delPush(billId);
            this.checkService.writeBackPlan(checkEntity, false);
        }
        return CommonResponse.success();
    }
}

