/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.DeliveryDetailThirdVO;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.wzxt.check.vo.CheckDetailVO;
import com.ejianc.wzxt.check.vo.CheckVO;
import com.ejianc.wzxt.delivery.bean.DeliveryDetailEntity;
import com.ejianc.wzxt.delivery.bean.DeliveryEntity;
import com.ejianc.wzxt.delivery.mapper.DeliveryMapper;
import com.ejianc.wzxt.delivery.service.IDeliveryService;
import com.ejianc.wzxt.delivery.vo.DeliveryVO;
import com.ejianc.wzxt.enums.CheckTypeEnum;
import com.ejianc.wzxt.order.bean.OrderDetailEntity;
import com.ejianc.wzxt.order.bean.OrderEntity;
import com.ejianc.wzxt.order.service.IOrderService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    @Autowired
    private IDeliveryService deliveryService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String PUSH_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/delivery/saveMaterialDeliveryState";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushThirdDataApi pushThirdDataApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_CODE = "ZJKJ-DELIVERY-CODE";
    private final String OPERATE = "ZJKJ_DELIVERY_SYNC";
    private static final String BILL_TYPE_CODE = "EJCBT202407000005";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CheckVO queryDetailToCheck(Long id) {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        CheckVO checkVO = new CheckVO();
        checkVO.setOrderId(deliveryEntity.getOrderId());
        checkVO.setDeliveryId(deliveryEntity.getId());
        checkVO.setCheckState(Integer.valueOf(0));
        checkVO.setContractId(deliveryEntity.getContractId());
        checkVO.setContractName(deliveryEntity.getContractName());
        checkVO.setContractCode(deliveryEntity.getContractCode());
        checkVO.setProjectCode(deliveryEntity.getProjectCode());
        checkVO.setProjectId(deliveryEntity.getProjectId());
        checkVO.setProjectName(deliveryEntity.getProjectName());
        checkVO.setSupplierId(deliveryEntity.getSupplierId());
        checkVO.setSupplierName(deliveryEntity.getSupplierName());
        checkVO.setDepartmentId(deliveryEntity.getDepartmentId());
        checkVO.setDepartmentName(deliveryEntity.getDepartmentName());
        checkVO.setLicensePlate(deliveryEntity.getLicensePlate());
        checkVO.setOrgId(deliveryEntity.getOrgId());
        checkVO.setOrgName(deliveryEntity.getOrgName());
        checkVO.setCheckType(CheckTypeEnum.\u53d1\u8d27\u9a8c\u6536.getCode());
        checkVO.setParentOrgId(deliveryEntity.getParentOrgId());
        checkVO.setParentOrgName(deliveryEntity.getParentOrgName());
        checkVO.setDeliveryCode(deliveryEntity.getBillCode());
        checkVO.setAutomaticWeigh(deliveryEntity.getAutomaticWeigh());
        checkVO.setDeliveryType(deliveryEntity.getDeliveryType());
        List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        List deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getDeliveryNum().compareTo(s.getCheckNum() == null ? BigDecimal.ZERO : s.getCheckNum()) == 1).collect(Collectors.toList());
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(deliveryEntity.getOrderId()));
        Map deliveryOrderMap = orderEntity.getOrderDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (k1, k2) -> k1));
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)) {
            ArrayList<CheckDetailVO> checkDetailVOS = new ArrayList<CheckDetailVO>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                CheckDetailVO checkDetailVO = new CheckDetailVO();
                checkDetailVO.setCheckType(CheckTypeEnum.\u53d1\u8d27\u9a8c\u6536.getCode());
                checkDetailVO.setSourceId(deliveryEntity.getId());
                checkDetailVO.setSourceDetailId(deliveryDetailEntity.getId());
                OrderDetailEntity detailEntity = (OrderDetailEntity)((Object)deliveryOrderMap.get(deliveryDetailEntity.getOrderDetailId()));
                checkDetailVO.setMonthPlanId(detailEntity.getSourceId());
                checkDetailVO.setMonthPlanDetailId(detailEntity.getSourceDetailId());
                checkDetailVO.setMaterialId(deliveryDetailEntity.getMaterialId());
                checkDetailVO.setMaterialName(deliveryDetailEntity.getMaterialName());
                checkDetailVO.setMaterialTypeId(deliveryDetailEntity.getMaterialTypeId());
                checkDetailVO.setMaterialTypeName(deliveryDetailEntity.getMaterialTypeName());
                checkDetailVO.setMaterialCode(deliveryDetailEntity.getMaterialCode());
                checkDetailVO.setUnit(deliveryDetailEntity.getUnit());
                checkDetailVO.setUnitId(deliveryDetailEntity.getUnitId());
                checkDetailVO.setSpec(deliveryDetailEntity.getSpec());
                checkDetailVO.setDetailAutomaticWeigh(deliveryDetailEntity.getDetailAutomaticWeigh());
                checkDetailVO.setDeliverNum(deliveryDetailEntity.getDeliveryNum());
                checkDetailVO.setCheckNum(ComputeUtil.safeSub((BigDecimal)deliveryDetailEntity.getDeliveryNum(), (BigDecimal)deliveryDetailEntity.getCheckNum()));
                checkDetailVOS.add(checkDetailVO);
            }
            checkVO.setCheckDetailList(checkDetailVOS);
        }
        return checkVO;
    }

    @Override
    @Transactional
    public DeliveryVO closeDelivery(Long id) {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)super.selectById((Serializable)id));
        deliveryEntity.setCloseFlag(1);
        super.updateById((Object)deliveryEntity);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", deliveryEntity.getSourceId());
        map.put("closeFlag", 1);
        map.put("systemId", ejcCloudSystemCode.getData());
        String dataInfo = JSONObject.toJSONString(map);
        Boolean updateSupplierStatus = this.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/zjkj-supbusiness-web/openapi/delivery/saveMaterialDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "ZJKJ_DELIVERY_SYNC", BILL_TYPE_CODE);
        if (!updateSupplierStatus.booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
        }
        return (DeliveryVO)BeanMapper.map((Object)((Object)deliveryEntity), DeliveryVO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean updateSupplierStatus(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode) {
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = this.jedisPool.getResource();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)operate, (int)600);
            if (!locked.booleanValue()) {
                this.releaseLock(jedis, false, key, operate);
                this.logger.error("\u5355\u636e{}\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25-{}\uff01", (Object)billId, (Object)locked);
                Boolean bl = false;
                return bl;
            }
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, method, dataInfo, supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, billPushResp.getMsg()});
                }
            } else {
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u53d1\u8d27\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{billId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    @Override
    public DeliveryVO saveOrUpdates(DeliveryVO saveOrUpdateVO) {
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeliveryEntity.class));
        List materialDeliveryDetailList = saveOrUpdateVO.getMaterialDeliveryDetailList();
        List deliveryDetailEntityList = BeanMapper.mapList((Iterable)materialDeliveryDetailList, DeliveryDetailEntity.class);
        entity.setDeliveryDetailList(deliveryDetailEntityList);
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCloseFlag(0);
        super.saveOrUpdate((Object)entity, false);
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return vo;
    }

    @Override
    public DeliveryVO savePushThirdData(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)super.selectById((Serializable)id));
        if (null != entity.getAutomaticWeigh() && 0 == entity.getAutomaticWeigh()) {
            DeliveryThirdVO thirdVO = (DeliveryThirdVO)BeanMapper.map((Object)((Object)entity), DeliveryThirdVO.class);
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.getById(entity.getOrderId()));
            thirdVO.setEmployeeName(orderEntity.getEmployeeName() == null ? orderEntity.getCreateUserCode() : orderEntity.getEmployeeName());
            thirdVO.setOrderAddress(orderEntity.getOrderAddress());
            thirdVO.setDeliverType("CL");
            List<DeliveryDetailEntity> detailList = entity.getDeliveryDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
            }
            this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
            CommonResponse thirdRes = this.pushThirdDataApi.pushThirdData(thirdVO);
            if (thirdRes.isSuccess()) {
                this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("sucPushed");
            } else {
                entity.setUnSucReason(thirdRes.getMsg());
            }
            super.updateById((Object)entity);
        }
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

