/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.wzxt.enums.ReceiveStateEnum;
import com.ejianc.wzxt.order.bean.OrderEntity;
import com.ejianc.wzxt.order.service.IOrderService;
import com.ejianc.wzxt.order.vo.OrderExportVO;
import com.ejianc.wzxt.order.vo.OrderVO;
import com.ejianc.wzxt.order.vo.SupOrderVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"order"})
@Api(value="\u6750\u6599\u8ba2\u5355\u4e3b\u8868", tags={"\u6750\u6599\u8ba2\u5355\u4e3b\u8868"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOrderService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private final String billTypeCode = "EJCBT202407000004";
    private final String mobileBillShareFrontUrl = "/zjkj-supbusiness-mobile/#/materialOrder/card";

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OrderVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(@RequestParam Long id) {
        return this.service.queryDetail(id);
    }

    @RequestMapping(value={"/afterProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> afterProject(@RequestParam Long projectId) {
        return this.service.afterProject(projectId);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        return this.service.delete(vos);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u624b\u673a\u53f7")
    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }

    @ApiOperation(value="\u63a5\u6536")
    @RequestMapping(value={"/updateReceived"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> updateReceived(@RequestBody SupOrderVO supOrderVO) {
        return this.service.updateReceived(supOrderVO);
    }

    @ApiOperation(value="\u64a4\u56de\u4f9b\u65b9\u672c\u5730\u6d4b\u8bd5")
    @RequestMapping(value={"/chgf"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> chgf(@RequestParam Long id) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(id));
        CommonResponse<String> response = this.service.updatePushBill(orderEntity, "EJCBT202407000004", "/zjkj-supbusiness-web/openapi/order/deleteOrder");
        return response;
    }

    @ApiOperation(value="\u63a8\u9001\u4f9b\u65b9\u672c\u5730\u6d4b\u8bd5")
    @RequestMapping(value={"/tsgf"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> tsgf(@RequestParam Long id) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(id));
        Boolean pushFlag = this.service.pushBillToSupCenter(orderEntity, "EJCBT202407000004");
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
        if (!pushFlag.booleanValue()) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5931\u8d25");
        }
        orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        orderEntity.setReceiveState(ReceiveStateEnum.\u5f85\u63a5\u6536.getCode());
        this.service.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    @ApiOperation(value="\u4fee\u6539\u53d1\u8d27\u72b6\u6001")
    @RequestMapping(value={"/updateDeliver"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<String> updateDeliver(@RequestBody OrderVO orderVO) {
        return this.service.updateDeliver(orderVO.getId(), orderVO.getDeliverState());
    }

    @ApiOperation(value="\u83b7\u53d6\u6700\u65b0\u7684\u8ba1\u5212\u5269\u4f59\u6570\u91cf")
    @RequestMapping(value={"/getSurplusNumsSum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getSurplusNumsSum(@RequestParam Long orderDetailId, @RequestParam Long projectId, @RequestParam Long materialId) {
        BigDecimal surplusNumsSum = this.service.getSurplusNumsSum(orderDetailId, projectId, materialId);
        return CommonResponse.success((String)"\u83b7\u53d6\u6700\u65b0\u7684\u8ba1\u5212\u5269\u4f59\u6570\u91cf\u6210\u529f", (Object)surplusNumsSum);
    }

    @ApiOperation(value="\u5173\u95ed")
    @RequestMapping(value={"/close"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> close(@RequestParam Long orderId) {
        return this.service.close(orderId);
    }

    @ApiOperation(value="\u83b7\u53d6\u534f\u540c\u94fe\u63a5")
    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(id));
        return this.shareCooperateApi.getShareLink(id, "EJCBT202407000004", entity.getSupplierId().toString(), "/zjkj-supbusiness-mobile/#/materialOrder/card", null);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("parentOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("parentOrgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        ArrayList<OrderExportVO> voList = new ArrayList<OrderExportVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrderEntity orderEntity : list) {
                OrderExportVO map = (OrderExportVO)BeanMapper.map((Object)((Object)orderEntity), OrderExportVO.class);
                map.setBillState(BillStateEnum.getEnumByStateCode((Integer)orderEntity.getBillState()).getDescription());
                if (null != orderEntity.getExpiryDate()) {
                    map.setOrderExpiryDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)orderEntity.getExpiryDate()));
                }
                if (null != orderEntity.getReceiveState()) {
                    switch (orderEntity.getReceiveState()) {
                        case 0: {
                            map.setReceiveState("\u5f85\u63a5\u6536");
                            break;
                        }
                        case 2: {
                            map.setReceiveState("\u90e8\u5206\u63a5\u6536");
                            break;
                        }
                        case 1: {
                            map.setReceiveState("\u5168\u90e8\u63a5\u6536");
                            break;
                        }
                        case 3: {
                            map.setReceiveState("\u4e0d\u4e88\u63a5\u6536");
                        }
                    }
                }
                if (null != orderEntity.getDeliverState()) {
                    switch (orderEntity.getDeliverState()) {
                        case 0: {
                            map.setDeliverState("\u5f85\u9001\u8d27");
                            break;
                        }
                        case 1: {
                            map.setDeliverState("\u90e8\u5206\u9001\u8d27");
                            break;
                        }
                        case 2: {
                            map.setDeliverState("\u5df2\u9001\u8d27");
                        }
                    }
                }
                if (null != orderEntity.getOrderFlag()) {
                    switch (orderEntity.getOrderFlag()) {
                        case 0: {
                            map.setOrderFlag("\u6b63\u5e38");
                            break;
                        }
                        case 1: {
                            map.setOrderFlag("\u5df2\u5173\u95ed");
                        }
                    }
                }
                voList.add(map);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("Order-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refOrderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> refOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody OrderVO orderVO) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(orderVO);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }
}

