/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.order.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.weigh.wagon.api.IWagonMaterialApi;
import com.ejianc.business.weigh.wagon.vo.WagonProjectVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.wzxt.enums.DeliverStateEnum;
import com.ejianc.wzxt.enums.OrderFlagEnum;
import com.ejianc.wzxt.enums.ReceiveStateEnum;
import com.ejianc.wzxt.order.bean.OrderDetailEntity;
import com.ejianc.wzxt.order.bean.OrderEntity;
import com.ejianc.wzxt.order.mapper.OrderMapper;
import com.ejianc.wzxt.order.service.IOrderDetailService;
import com.ejianc.wzxt.order.service.IOrderService;
import com.ejianc.wzxt.order.vo.OrderDetailVO;
import com.ejianc.wzxt.order.vo.OrderVO;
import com.ejianc.wzxt.order.vo.SupOrderDetailVO;
import com.ejianc.wzxt.order.vo.SupOrderVO;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.utils.CommonUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWagonMaterialApi wagonMaterialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZJKJ_ORDER";
    @Autowired
    private IOrderService service;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOutcontractApi outcontractApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private final String OPERATE = "MATERIAL_ORDER_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/order/saveOrUpdate";
    private final String UPDATE_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/order/updateOrderCloseFlag";
    private static final String CHECK_NUM_CODE = "P-Is9ntQ0298";
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public CommonResponse<OrderVO> saveOrUpdate(OrderVO saveOrUpdateVO) {
        CommonResponse response;
        this.afterProject(saveOrUpdateVO.getProjectId());
        this.savaHintFlag(saveOrUpdateVO);
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OrderEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setOrderFlag(OrderFlagEnum.\u6b63\u5e38.getCode());
        if (0 == entity.getAutomaticWeigh() && (response = this.wagonMaterialApi.queryProjConfig(entity.getProjectId())).isSuccess() && null != response.getData()) {
            entity.setPlatformCode(((WagonProjectVO)response.getData()).getWagonTypeCode());
            entity.setPlatformType(((WagonProjectVO)response.getData()).getWagonCode());
        }
        if ((response = this.outcontractApi.queryDetail(entity.getContractId())).isSuccess() && null != response.getData() && CollectionUtils.isNotEmpty(entity.getOrderDetailList())) {
            ArrayList<String> nameList = new ArrayList<String>();
            Map<Long, OutcontractMaterialVO> detailVOMap = ((OutcontractVO)response.getData()).getOutcontractMaterialList().stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(OutcontractMaterialVO::getMaterialId, item -> item, (v1, v2) -> v2));
            for (OrderDetailEntity detailEntity : entity.getOrderDetailList()) {
                if ("del".equals(detailEntity.getRowState())) continue;
                if (!detailVOMap.containsKey(detailEntity.getMaterialId())) {
                    detailEntity.setContractDetailId(detailVOMap.get(detailEntity.getMaterialId()).getId());
                }
                nameList.add(detailEntity.getMaterialName());
            }
            if (CollectionUtils.isNotEmpty(nameList)) {
                entity.setMaterialName(StringUtils.join(nameList, (String)","));
            }
        }
        super.saveOrUpdate((Object)entity, false);
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(id));
        OrderVO orderVO = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)orderVO);
    }

    @Override
    public CommonResponse<String> delete(List<OrderVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private void savaHintFlag(OrderVO orderVO) {
        ArrayList<String> errList = new ArrayList<String>();
        CommonResponse response = this.outcontractApi.queryDetail(orderVO.getContractId());
        if (response.isSuccess() && null != response.getData() && CollectionUtils.isNotEmpty((Collection)orderVO.getOrderDetailList())) {
            Map<Long, OutcontractMaterialVO> detailVOMap = ((OutcontractVO)response.getData()).getOutcontractMaterialList().stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(OutcontractMaterialVO::getMaterialId, item -> item, (v1, v2) -> v2));
            for (OrderDetailVO orderDetailVO : orderVO.getOrderDetailList()) {
                if ("del".equals(orderDetailVO.getRowState()) || detailVOMap.containsKey(orderDetailVO.getMaterialId())) continue;
                errList.add(orderDetailVO.getMaterialCode());
            }
        }
        if (CollectionUtils.isNotEmpty(errList)) {
            throw new BusinessException("\u6750\u6599\u7f16\u7801[" + StringUtils.join(errList, (String)",") + "]\u4e0d\u5728\u91c7\u8d2d\u5408\u540c\u8303\u56f4\u5185\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u6e05\u5355!");
        }
    }

    @Override
    public CommonResponse<OrderVO> updateReceived(SupOrderVO orderVO) {
        this.logger.info("---\u63a5\u6536\u5f00\u59cb---", (Object)JSONObject.toJSONString((Object)orderVO));
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)orderVO.getId()));
        if (null != orderEntity && null != orderEntity.getReceiveState() && orderEntity.getReceiveState() > 0 && 4 != orderVO.getReceiveState()) {
            return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u64cd\u4f5c,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + frontendBaseHost);
        String formurl = frontendBaseHost + "zjkj-wzxt-mobile/#/purchaseOrder/card?id=" + orderEntity.getId();
        String subject = "";
        String content = "";
        if (1 == orderVO.getReceiveState()) {
            this.logger.info("---\u5168\u90e8\u63a5\u53d7\u5f00\u59cb---");
            orderEntity.setReceiveState(ReceiveStateEnum.\u5168\u90e8\u63a5\u6536.getCode());
            orderEntity.setDeliverState(DeliverStateEnum.\u5f85\u9001\u8d27.getCode());
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u5168\u90e8\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u5168\u90e8\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            orderEntity.getOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(vo.getOrderNumSum());
                vo.setDeliverNumsSum(BigDecimal.ZERO);
            });
        } else if (2 == orderVO.getReceiveState()) {
            this.logger.info("---\u90e8\u5206\u63a5\u53d7\u5f00\u59cb---");
            orderEntity.setReceiveState(ReceiveStateEnum.\u90e8\u5206\u63a5\u6536.getCode());
            orderEntity.setDeliverState(DeliverStateEnum.\u5f85\u9001\u8d27.getCode());
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getOrderDetailList())) {
                Map<Long, BigDecimal> map = orderVO.getOrderDetailList().stream().collect(Collectors.toMap(SupOrderDetailVO::getId, SupOrderDetailVO::getReceiveNumsSum));
                this.logger.debug("map------" + map);
                orderEntity.getOrderDetailList().forEach(vo -> {
                    vo.setReceiveNumsSum((BigDecimal)map.get(vo.getId()));
                    this.logger.debug("ReceiveNumsSum------" + vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);
                });
            }
        } else if (3 == orderVO.getReceiveState()) {
            this.logger.info("---\u4e0d\u4e88\u63a5\u53d7\u5f00\u59cb---");
            orderEntity.setReceiveState(ReceiveStateEnum.\u4e0d\u4e88\u63a5\u6536.getCode());
            orderEntity.setReceiveReason(orderVO.getReceiveReason());
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u62d2\u7edd\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u62d2\u7edd\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            orderEntity.getOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(BigDecimal.ZERO);
                vo.setDeliverNumsSum(BigDecimal.ZERO);
            });
        }
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getTenantId()), orderEntity);
        this.logger.debug("-----\u4e3b\u952e" + orderEntity.getId());
        super.saveOrUpdate((Object)orderEntity, false);
        if (2 == orderVO.getReceiveState() || 3 == orderVO.getReceiveState()) {
            this.reveiveWriteOrder(orderEntity);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    private void reveiveWriteOrder(OrderEntity orderEntity) {
        MasterPlanEntity masterPlanEntity;
        List<MasterPlanDetailEntity> masterPlanDetailList;
        List<OrderDetailEntity> orderDetailList = orderEntity.getOrderDetailList();
        MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(orderDetailList.get(0).getSourceId()));
        List<MonthPlanDetailEntity> monthPlanDetailList = monthPlanEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(monthPlanDetailList)) {
            Map map = monthPlanDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key1));
            ArrayList<MonthPlanDetailEntity> list = new ArrayList<MonthPlanDetailEntity>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if (!map.containsKey(detailEntity.getSourceDetailId())) continue;
                MonthPlanDetailEntity entity = (MonthPlanDetailEntity)((Object)map.get(detailEntity.getSourceDetailId()));
                entity.setOrderNum(ComputeUtil.safeAdd((BigDecimal)entity.getOrderNum(), (BigDecimal)ComputeUtil.safeSub((BigDecimal)detailEntity.getReceiveNumsSum(), (BigDecimal)detailEntity.getOrderNumSum())));
                list.add(entity);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.monthPlanDetailService.saveOrUpdateBatch(list);
            }
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, (Object)orderEntity.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        MasterPlanEntity planEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)queryWrapper, false));
        if (null != planEntity && CollectionUtils.isNotEmpty(masterPlanDetailList = (masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.selectById(planEntity.getId()))).getMasterPlanDetailList())) {
            Map map = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
            ArrayList<MasterPlanDetailEntity> list = new ArrayList<MasterPlanDetailEntity>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if (!map.containsKey(detailEntity.getMaterialId())) continue;
                MasterPlanDetailEntity entity = (MasterPlanDetailEntity)((Object)map.get(detailEntity.getMaterialId()));
                entity.setOrderNum(ComputeUtil.safeAdd((BigDecimal)entity.getOrderNum(), (BigDecimal)ComputeUtil.safeSub((BigDecimal)detailEntity.getReceiveNumsSum(), (BigDecimal)detailEntity.getOrderNumSum())));
                list.add(entity);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.masterPlanDetailService.saveOrUpdateBatch(list);
            }
        }
    }

    @Override
    public CommonResponse<String> updateDeliver(Long orderId, Integer deliverState) {
        this.logger.info("\u8ba2\u5355id:-{},\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u5f00\u59cb!", (Object)orderId);
        OrderEntity byId = (OrderEntity)((Object)super.getById((Serializable)orderId));
        byId.setDeliverState(deliverState);
        super.saveOrUpdate((Object)byId);
        this.logger.info("\u8ba2\u5355id:-{},\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u4e3a:-{}\u6210\u529f!", (Object)orderId, (Object)deliverState);
        return CommonResponse.success((String)("\u8ba2\u5355id:" + orderId + "\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u4e3a\uff1a" + deliverState + "\u6210\u529f!"));
    }

    @Override
    public BigDecimal getSurplusNumsSum(Long orderDetailId, Long projectId, Long materialId) {
        BigDecimal surplusNumsSum = BigDecimal.ZERO;
        if (orderDetailId != null) {
            OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)this.orderDetailService.selectById(orderDetailId));
            BigDecimal orderNumsSum = orderDetailEntity.getOrderNumSum() == null ? BigDecimal.ZERO : orderDetailEntity.getOrderNumSum();
            surplusNumsSum = orderNumsSum.add(surplusNumsSum);
        }
        return surplusNumsSum;
    }

    @Override
    public CommonResponse<String> afterProject(Long projectId) {
        LambdaQueryWrapper lambdaMaster = Wrappers.lambdaQuery();
        lambdaMaster.eq(MonthPlanEntity::getProjectId, (Object)projectId);
        lambdaMaster.in(MonthPlanEntity::getBillState, new Object[]{1, 3});
        lambdaMaster.likeRight(MonthPlanEntity::getPlanDate, (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
        if (this.monthPlanService.count((Wrapper)lambdaMaster) <= 0) {
            throw new BusinessException("\u5f53\u524d\u6708\u5ea6\u65e0\u6708\u5ea6\u8ba1\u5212\uff0c\u8bf7\u5148\u7f16\u5236\u6708\u5ea6!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f!");
    }

    @Override
    public void writeBackMonthPlan(OrderEntity orderEntity, boolean isCommit) {
        MasterPlanEntity masterPlanEntity;
        List<MasterPlanDetailEntity> masterPlanDetailList;
        List<OrderDetailEntity> orderDetailList = orderEntity.getOrderDetailList();
        MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(orderDetailList.get(0).getSourceId()));
        List<MonthPlanDetailEntity> monthPlanDetailList = monthPlanEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(monthPlanDetailList)) {
            Map map = monthPlanDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key1));
            ArrayList<MonthPlanDetailEntity> list = new ArrayList<MonthPlanDetailEntity>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if (!map.containsKey(detailEntity.getSourceDetailId())) continue;
                MonthPlanDetailEntity entity = (MonthPlanDetailEntity)((Object)map.get(detailEntity.getSourceDetailId()));
                if (isCommit) {
                    entity.setOrderNum(ComputeUtil.safeAdd((BigDecimal)entity.getOrderNum(), (BigDecimal)detailEntity.getOrderNumSum()));
                } else {
                    entity.setOrderNum(ComputeUtil.safeSub((BigDecimal)entity.getOrderNum(), (BigDecimal)detailEntity.getOrderNumSum()));
                }
                list.add(entity);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.monthPlanDetailService.saveOrUpdateBatch(list);
            }
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, (Object)orderEntity.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        MasterPlanEntity planEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)queryWrapper, false));
        if (null != planEntity && CollectionUtils.isNotEmpty(masterPlanDetailList = (masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.selectById(planEntity.getId()))).getMasterPlanDetailList())) {
            Map map = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
            ArrayList<MasterPlanDetailEntity> list = new ArrayList<MasterPlanDetailEntity>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if (!map.containsKey(detailEntity.getMaterialId())) continue;
                MasterPlanDetailEntity entity = (MasterPlanDetailEntity)((Object)map.get(detailEntity.getMaterialId()));
                if (isCommit) {
                    entity.setOrderNum(ComputeUtil.safeAdd((BigDecimal)entity.getOrderNum(), (BigDecimal)detailEntity.getOrderNumSum()));
                } else {
                    entity.setOrderNum(ComputeUtil.safeSub((BigDecimal)entity.getOrderNum(), (BigDecimal)detailEntity.getOrderNumSum()));
                }
                list.add(entity);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.masterPlanDetailService.saveOrUpdateBatch(list);
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(OrderVO orderVO) {
        ParamsCheckVO result = new ParamsCheckVO();
        result.setWarnType("none");
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_NUM_CODE, orderVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6e05\u5355\u91cf\u5927\u4e8e\u6708\u5ea6\u8ba1\u5212\u5269\u4f59\u91cf\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (OrderDetailVO detailVO : orderVO.getOrderDetailList()) {
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        BigDecimal roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        BigDecimal compareNum = ComputeUtil.safeMultiply((BigDecimal)detailVO.getSurplusNumsSum(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getOrderNumSum(), (BigDecimal)compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u91cf\u8d85\u8fc7\u6708\u5ea6\u8ba1\u5212\u5269\u4f59\u91cf");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u91cf\u5927\u4e8e\u6708\u5ea6\u8ba1\u5212\u5269\u4f59\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u6e05\u5355\u7f16\u7801[").append(detailVO.getMaterialCode()).append("]\u7684\u8ba2\u5355\u91cf:").append(detailVO.getOrderNumSum().setScale(3, 4)).append("\uff0c\u6708\u5ea6\u8ba1\u5212\u5269\u4f59\u91cf:").append(compareNum.setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getOrderNumSum(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOList)) {
            for (ParamsCheckVO checkVO : paramsCheckVOList) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            result.setWarnType(s);
            result.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)result.getDataSource())) {
                result.setWarnType("none");
                continue;
            }
            return result;
        }
        return result;
    }

    @Override
    public CommonResponse<String> close(Long orderId) {
        MasterPlanEntity masterPlanEntity;
        List<MasterPlanDetailEntity> masterPlanDetailList;
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)orderId));
        CommonResponse<String> res = this.updatePushBill(orderEntity, "EJCBT202407000004", "/zjkj-supbusiness-web/openapi/order/updateOrderCloseFlag");
        orderEntity.setOrderFlag(OrderFlagEnum.\u5df2\u5173\u95ed.getCode());
        List<OrderDetailEntity> orderDetailList = orderEntity.getOrderDetailList();
        MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(orderDetailList.get(0).getSourceId()));
        List<MonthPlanDetailEntity> monthPlanDetailList = monthPlanEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(monthPlanDetailList)) {
            Map map = monthPlanDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key1));
            ArrayList<MonthPlanDetailEntity> list = new ArrayList<MonthPlanDetailEntity>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if (!map.containsKey(detailEntity.getSourceDetailId())) continue;
                MonthPlanDetailEntity entity = (MonthPlanDetailEntity)((Object)map.get(detailEntity.getSourceDetailId()));
                entity.setOrderNum(ComputeUtil.safeAdd((BigDecimal)entity.getOrderNum(), (BigDecimal)ComputeUtil.safeSub((BigDecimal)detailEntity.getCheckNumsSum(), (BigDecimal)detailEntity.getOrderNumSum())));
                list.add(entity);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.monthPlanDetailService.saveOrUpdateBatch(list);
            }
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, (Object)orderEntity.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        MasterPlanEntity planEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)queryWrapper, false));
        if (null != planEntity && CollectionUtils.isNotEmpty(masterPlanDetailList = (masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.selectById(planEntity.getId()))).getMasterPlanDetailList())) {
            Map map = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
            ArrayList<MasterPlanDetailEntity> list = new ArrayList<MasterPlanDetailEntity>();
            for (OrderDetailEntity detailEntity : orderDetailList) {
                if (!map.containsKey(detailEntity.getMaterialId())) continue;
                MasterPlanDetailEntity entity = (MasterPlanDetailEntity)((Object)map.get(detailEntity.getMaterialId()));
                entity.setOrderNum(ComputeUtil.safeAdd((BigDecimal)entity.getOrderNum(), (BigDecimal)ComputeUtil.safeSub((BigDecimal)detailEntity.getCheckNumsSum(), (BigDecimal)detailEntity.getOrderNumSum())));
                list.add(entity);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.masterPlanDetailService.saveOrUpdateBatch(list);
            }
        }
        super.updateById((Object)orderEntity);
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f");
    }

    @Override
    public boolean pushBillToSupCenter(OrderEntity orderEntity, String billTypeCode) {
        boolean syncFlag;
        block11: {
            boolean locked = false;
            syncFlag = false;
            Jedis jedis = this.jedisPool.getResource();
            String key = billTypeCode + "::" + orderEntity.getId().toString();
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)orderEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
                return false;
            }
            orderEntity.setSystemId((String)ejcCloudSystemCode.getData());
            try {
                locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MATERIAL_ORDER_SYNC", (int)600);
                if (!locked) {
                    this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                    this.releaseLock(jedis, false, key, "MATERIAL_ORDER_SYNC");
                    boolean bl = false;
                    return bl;
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                SupOrderVO supOrderVO = (SupOrderVO)BeanMapper.map((Object)((Object)orderEntity), SupOrderVO.class);
                List supOrderDetailVOS = BeanMapper.mapList(orderEntity.getOrderDetailList(), SupOrderDetailVO.class);
                supOrderVO.setOrderDetailList(supOrderDetailVOS);
                paramMap.put("order", JSONObject.toJSONString((Object)supOrderVO));
                CommonResponse fileResp = this.attachmentApi.queryListBySourceId(orderEntity.getId(), "EJCBT202407000004", "material-order-attaches", null);
                if (fileResp.isSuccess()) {
                    HashMap files = new HashMap();
                    List fileList = (List)fileResp.getData();
                    ArrayList<Long> fileIds = new ArrayList<Long>();
                    for (AttachmentVO attach : fileList) {
                        fileIds.add(attach.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                        Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                        fileMap.keySet().stream().forEach(fileKey -> {
                            HashMap file = new HashMap(1);
                            file.put((String)fileKey, fileMap.get(fileKey));
                            files.put("file", file);
                        });
                    }
                    this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)orderEntity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                    CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/zjkj-supbusiness-web/openapi/order/saveOrUpdate", paramMap, orderEntity.getSupplierId().toString(), files);
                    syncFlag = CommonUtils.checkCommonResponse(syncReqResp, this.logger);
                    break block11;
                }
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)orderEntity.getId(), (Object)fileResp.getMsg());
                throw new BusinessException(fileResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{orderEntity.getId(), orderEntity.getSupplierId(), e});
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
            finally {
                this.releaseLock(jedis, locked, key, "MATERIAL_ORDER_SYNC");
            }
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(OrderEntity orderEntity, String billTypeCode, String url) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = billTypeCode + "::" + orderEntity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)orderEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        orderEntity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MATERIAL_ORDER_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "MATERIAL_ORDER_SYNC");
                var8_8 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var8_8;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", orderEntity.getId().toString());
            paramMap.put("systemId", orderEntity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)orderEntity.getSupplierId(), (Object)orderEntity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, RequestMethod.POST, JSONObject.toJSONString(paramMap), orderEntity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl32
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var11_13 = supHandleResp;
                return var11_13;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{orderEntity.getSupplierId(), orderEntity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl32:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{orderEntity.getSupplierId(), orderEntity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)orderEntity.getId(), (Object)e);
                throw e;
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "MATERIAL_ORDER_SYNC");
        }
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId, OrderEntity orderEntity) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

