/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanChangeEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanChangeHisEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailChangeEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanChangeHisService;
import com.ejianc.wzxt.plan.service.IMasterPlanChangeService;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.vo.MasterPlanVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="masterPlanChange")
public class MasterPlanChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMasterPlanChangeService masterPlanChangeService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanChangeHisService masterPlanChangeHisService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MasterPlanChangeEntity entity = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.masterPlanChangeService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u64a4\u56de\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MasterPlanChangeEntity planChange = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        this.masterPlanChangeService.saveOrUpdate((Object)planChange, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MasterPlanChangeEntity planChange = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        MasterPlanEntity newPlanEntity = null;
        MasterPlanEntity oldPlan = (MasterPlanEntity)((Object)this.masterPlanService.selectById(planChange.getSourcePlanId()));
        CommonResponse stringCommonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "EJCBT202408000002", "materPlan001", String.valueOf(oldPlan.getId()), "EJCBT202408000001", "materPlan001");
        if (!stringCommonResponse.isSuccess()) {
            this.logger.info("\u6d88\u8017\u6750\u53d8\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        } else {
            this.logger.info("\u6d88\u8017\u6750\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        if (state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            UserContext userContext = this.sessionManager.getUserContext();
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userContext.getUserCode());
            planChange.setCommitUserName(userContext.getUserName());
        }
        planChange.setEffectiveDate(new Date());
        MasterPlanChangeHisEntity recordEntity = (MasterPlanChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldPlan), MasterPlanChangeHisEntity.class));
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03, \u603b\u8ba1\u5212\u53d8\u66f4\u4fe1\u606f\uff1a\u3010{}\u3011, \u53d8\u66f4\u524d\u603b\u8ba1\u5212\u4fe1\u606f: \u3010{}\u3011", (Object)JSON.toJSONString((Object)((Object)planChange)), (Object)JSON.toJSONString((Object)((Object)oldPlan)));
        recordEntity.setSourcePlanId(oldPlan.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getMasterPlanDetailList())) {
            recordEntity.getMasterPlanDetailList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
        recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
        recordEntity.setTenderMny(planChange.getTenderMny());
        recordEntity.setOriginaltenderMny(oldPlan.getTenderMny());
        recordEntity.setChangePlanId(planChange.getId());
        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if (null == recordEntity.getTotalPlanAmt()) {
            recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (null == recordEntity.getOriginalPlanAmt()) {
            recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
        if (recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(0.0);
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, 4).multiply(new BigDecimal(100)).setScale(2, 4).doubleValue());
        }
        this.masterPlanChangeHisService.saveOrUpdate((Object)recordEntity, false);
        this.masterPlanChangeService.saveOrUpdate((Object)planChange, false);
        newPlanEntity = (MasterPlanEntity)((Object)BeanMapper.map((Object)((Object)planChange), MasterPlanEntity.class));
        newPlanEntity.setChangeState(MasterPlanVO.PLAN_CHANGE_STATE_CHANGED);
        newPlanEntity.setCurChangingPlanId(null);
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        ArrayList<MasterPlanDetailEntity> updatePlanDetail = new ArrayList<MasterPlanDetailEntity>();
        List<MasterPlanDetailEntity> oldList = oldPlan.getMasterPlanDetailList();
        Map<Long, MasterPlanDetailEntity> map1 = oldList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(BaseEntity::getId, item -> item, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty(newPlanEntity.getMasterPlanDetailList())) {
            for (MasterPlanDetailEntity detail2 : newPlanEntity.getMasterPlanDetailList()) {
                if (detail2.getChangeType() == 2) {
                    delDetailIds.add(detail2.getTargetId());
                    continue;
                }
                if (null != detail2.getTargetId()) {
                    if (!map1.containsKey(detail2.getTargetId())) continue;
                    MasterPlanDetailEntity masterPlanDetail = map1.get(detail2.getTargetId());
                    masterPlanDetail.setChangeType(detail2.getChangeType());
                    masterPlanDetail.setTenderNum(detail2.getTenderNum());
                    masterPlanDetail.setTenderPrice(detail2.getTenderPrice());
                    masterPlanDetail.setTenderAmount(detail2.getTenderAmount());
                    masterPlanDetail.setPlanTotalNum(detail2.getPlanTotalNum());
                    masterPlanDetail.setResponseSurplusNum(detail2.getResponseSurplusNum());
                    updatePlanDetail.add(masterPlanDetail);
                    continue;
                }
                detail2.setId(null);
                updatePlanDetail.add(detail2);
            }
        }
        if (CollectionUtils.isNotEmpty(updatePlanDetail)) {
            this.masterPlanDetailService.saveOrUpdateBatch(updatePlanDetail);
        }
        newPlanEntity.setMasterPlanDetailList(updatePlanDetail);
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.masterPlanDetailService.removeByIds(delDetailIds);
        }
        this.logger.info("\u56de\u663e\u539f\u8ba1\u5212\u5b50\u8868\u7ed3\u675f\uff01");
        this.masterPlanService.saveOrUpdate((Object)newPlanEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            CommonResponse.success((String)"\u6709\u5ba1\u6279\u6d41\u7a0b\u7684\u53d8\u66f4\u603b\u8ba1\u5212\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MasterPlanChangeEntity planChange = (MasterPlanChangeEntity)((Object)this.masterPlanChangeService.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"change_plan_id", (Object)billId);
        MasterPlanChangeHisEntity hisEntity = (MasterPlanChangeHisEntity)((Object)this.masterPlanChangeHisService.getOne((Wrapper)hisQuery));
        if (null != hisEntity) {
            MasterPlanEntity newPlanEntity = null;
            MasterPlanEntity oldPlan = (MasterPlanEntity)((Object)this.masterPlanService.selectById(planChange.getSourcePlanId()));
            this.logger.info("\u603b\u8ba1\u5212\u6267\u884c\u5f03\u5ba1\u6570\u636e\u6062\u590d\u903b\u8f91\uff0c\u5f53\u524d\u6570\u636e\u3010{}\u3011\uff0c\u5f85\u6062\u590d\u6570\u636e\u3010{}\u3011", (Object)oldPlan, (Object)hisEntity);
            newPlanEntity = (MasterPlanEntity)((Object)BeanMapper.map((Object)((Object)hisEntity), MasterPlanEntity.class));
            newPlanEntity.setCurChangingPlanId(hisEntity.getChangePlanId());
            newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
            newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
            newPlanEntity.setCreateTime(oldPlan.getCreateTime());
            newPlanEntity.setId(oldPlan.getId());
            newPlanEntity.setVersion(oldPlan.getVersion());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion());
            newPlanEntity.setChangeState(MasterPlanVO.PLAN_CHANGE_STATE_CHANGING);
            newPlanEntity.setTotalPlanAmt(hisEntity.getOriginalPlanAmt());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);
            ArrayList<Long> delDetailIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(planChange.getMasterPlanDetailList())) {
                ArrayList<MasterPlanDetailEntity> list = new ArrayList<MasterPlanDetailEntity>();
                MasterPlanDetailEntity tmp = null;
                Map<Long, Integer> map = oldPlan.getMasterPlanDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                for (MasterPlanDetailChangeEntity detail : planChange.getMasterPlanDetailList()) {
                    tmp = (MasterPlanDetailEntity)((Object)BeanMapper.map((Object)((Object)detail), MasterPlanDetailEntity.class));
                    if (null != detail.getTargetId()) {
                        tmp.setVersion(map.get(detail.getTargetId()));
                        tmp.setId(detail.getTargetId());
                        if (detail.getChangeType().equals("1")) {
                            delDetailIds.add(detail.getId());
                            continue;
                        }
                        list.add(tmp);
                        continue;
                    }
                    delDetailIds.add(detail.getId());
                }
                newPlanEntity.setMasterPlanDetailList(list);
            }
            if (CollectionUtils.isNotEmpty(delDetailIds)) {
                this.masterPlanDetailService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
            }
            this.masterPlanChangeHisService.removeById(hisEntity.getId(), false);
            this.masterPlanService.saveOrUpdate((Object)newPlanEntity, false);
        }
        if (this.masterPlanChangeService.saveOrUpdate((Object)planChange, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success();
    }
}

