/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeHisEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanChangeHisService;
import com.ejianc.wzxt.plan.service.IMonthPlanChangeService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.plan.vo.MonthPlanVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="monthPlanChange")
public class MonthPlanChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMonthPlanChangeService monthPlanChangeService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanChangeHisService monthPlanChangeHisService;
    @Autowired
    private IMasterPlanService masterPlanService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MonthPlanChangeEntity entity = (MonthPlanChangeEntity)((Object)this.monthPlanChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.monthPlanChangeService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u64a4\u56de\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MonthPlanChangeEntity planChange = (MonthPlanChangeEntity)((Object)this.monthPlanChangeService.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        this.monthPlanChangeService.saveOrUpdate((Object)planChange, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MonthPlanChangeEntity planChange = (MonthPlanChangeEntity)((Object)this.monthPlanChangeService.selectById(billId));
        MonthPlanEntity newPlanEntity = null;
        MonthPlanEntity oldPlan = (MonthPlanEntity)((Object)this.monthPlanService.selectById(planChange.getSourcePlanId()));
        CommonResponse stringCommonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "EJCBT202408000002", "materPlan001", String.valueOf(oldPlan.getId()), "EJCBT202408000001", "materPlan001");
        if (!stringCommonResponse.isSuccess()) {
            this.logger.info("\u6d88\u8017\u6750\u53d8\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        } else {
            this.logger.info("\u6d88\u8017\u6750\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        if (state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            UserContext userContext = this.sessionManager.getUserContext();
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userContext.getUserCode());
            planChange.setCommitUserName(userContext.getUserName());
        }
        planChange.setEffectiveDate(new Date());
        MonthPlanChangeHisEntity recordEntity = (MonthPlanChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldPlan), MonthPlanChangeHisEntity.class));
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03, \u603b\u8ba1\u5212\u53d8\u66f4\u4fe1\u606f\uff1a\u3010{}\u3011, \u53d8\u66f4\u524d\u603b\u8ba1\u5212\u4fe1\u606f: \u3010{}\u3011", (Object)JSON.toJSONString((Object)((Object)planChange)), (Object)JSON.toJSONString((Object)((Object)oldPlan)));
        recordEntity.setSourcePlanId(oldPlan.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getMonthPlanDetailList())) {
            recordEntity.getMonthPlanDetailList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
        recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
        recordEntity.setChangePlanId(planChange.getId());
        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if (null == recordEntity.getTotalPlanAmt()) {
            recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (null == recordEntity.getOriginalPlanAmt()) {
            recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
        if (recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(0.0);
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, 4).multiply(new BigDecimal(100)).setScale(2, 4).doubleValue());
        }
        this.monthPlanChangeHisService.saveOrUpdate((Object)recordEntity, false);
        this.monthPlanChangeService.saveOrUpdate((Object)planChange, false);
        newPlanEntity = (MonthPlanEntity)((Object)BeanMapper.map((Object)((Object)planChange), MonthPlanEntity.class));
        newPlanEntity.setChangeState(MonthPlanVO.PLAN_CHANGE_STATE_CHANGED);
        newPlanEntity.setCurChangingPlanId(null);
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        ArrayList<MonthPlanDetailEntity> updatePlanDetail = new ArrayList<MonthPlanDetailEntity>();
        List<MonthPlanDetailEntity> oldList = oldPlan.getMonthPlanDetailList();
        Map<Long, MonthPlanDetailEntity> map1 = oldList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(BaseEntity::getId, item -> item, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty(newPlanEntity.getMonthPlanDetailList())) {
            for (MonthPlanDetailEntity detail2 : newPlanEntity.getMonthPlanDetailList()) {
                if (detail2.getChangeType() == 2) {
                    delDetailIds.add(detail2.getTargetId());
                    continue;
                }
                if (null != detail2.getTargetId()) {
                    if (!map1.containsKey(detail2.getTargetId())) continue;
                    MonthPlanDetailEntity monthPlanDetail = map1.get(detail2.getTargetId());
                    monthPlanDetail.setChangeType(detail2.getChangeType());
                    monthPlanDetail.setPlanTotalNum(detail2.getPlanTotalNum());
                    updatePlanDetail.add(monthPlanDetail);
                    continue;
                }
                detail2.setId(null);
                updatePlanDetail.add(detail2);
            }
        }
        if (CollectionUtils.isNotEmpty(updatePlanDetail)) {
            this.monthPlanDetailService.saveOrUpdateBatch(updatePlanDetail);
        }
        newPlanEntity.setMonthPlanDetailList(updatePlanDetail);
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.monthPlanDetailService.removeByIds(delDetailIds);
        }
        MonthPlanChangeEntity monthPlanChangeEntity = (MonthPlanChangeEntity)((Object)this.monthPlanChangeService.selectById(billId));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MonthPlanEntity::getProjectId, (Object)monthPlanChangeEntity.getProjectId());
        lambda.in(MonthPlanEntity::getBillState, new Object[]{1, 3});
        lambda.notIn(BaseEntity::getId, new Object[]{monthPlanChangeEntity.getSourcePlanId()});
        List monthPlanEntities = this.monthPlanService.list((Wrapper)lambda);
        Map<Object, Object> orderNumMap = new HashMap();
        Map<Object, Object> selfCheckNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)monthPlanEntities)) {
            List ids = monthPlanEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaDetail = Wrappers.lambdaQuery();
            lambdaDetail.in(MonthPlanDetailEntity::getMaterialMonthPlanId, ids);
            List monthPlanDetailEntities = this.monthPlanDetailService.list((Wrapper)lambdaDetail);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)monthPlanDetailEntities)) {
                orderNumMap = monthPlanDetailEntities.stream().filter(s -> s.getOrderNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getOrderNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                selfCheckNumMap = monthPlanDetailEntities.stream().filter(s -> s.getSelfCheckNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getSelfCheckNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
        }
        Map<Object, Object> planMonthNumMap = new HashMap();
        List<MonthPlanChangeDetailEntity> monthPlanDetailList = monthPlanChangeEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(monthPlanDetailList)) {
            planMonthNumMap = monthPlanDetailList.stream().filter(s -> s.getPlanMonthNum() != null).collect(Collectors.groupingBy(MonthPlanChangeDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanMonthNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        LambdaQueryWrapper lambdaMaster = Wrappers.lambdaQuery();
        lambdaMaster.eq(MasterPlanEntity::getProjectId, (Object)monthPlanChangeEntity.getProjectId());
        lambdaMaster.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)lambdaMaster));
        if (masterPlanEntity != null) {
            LambdaQueryWrapper lambdaMasterDetail = Wrappers.lambdaQuery();
            lambdaMasterDetail.in(MasterPlanDetailEntity::getMaterialMasterPlanId, new Object[]{masterPlanEntity.getId()});
            List masterPlanDetailEntities = this.masterPlanDetailService.list((Wrapper)lambdaMasterDetail);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)masterPlanDetailEntities)) {
                for (MasterPlanDetailEntity masterPlanDetailEntity : masterPlanDetailEntities) {
                    BigDecimal planMonthNum = BigDecimal.ZERO;
                    if (orderNumMap.containsKey(masterPlanDetailEntity.getMaterialId())) {
                        BigDecimal orderNum = (BigDecimal)orderNumMap.get(masterPlanDetailEntity.getMaterialId());
                        planMonthNum = ComputeUtil.safeAdd((BigDecimal)planMonthNum, (BigDecimal)orderNum);
                    }
                    if (orderNumMap.containsKey(masterPlanDetailEntity.getMaterialId())) {
                        BigDecimal selfCheckNum = (BigDecimal)selfCheckNumMap.get(masterPlanDetailEntity.getMaterialId());
                        planMonthNum = ComputeUtil.safeAdd((BigDecimal)planMonthNum, (BigDecimal)selfCheckNum);
                    }
                    if (planMonthNumMap.containsKey(masterPlanDetailEntity.getMaterialId())) {
                        BigDecimal planMonthNumNum = (BigDecimal)planMonthNumMap.get(masterPlanDetailEntity.getMaterialId());
                        planMonthNum = ComputeUtil.safeAdd((BigDecimal)planMonthNum, (BigDecimal)planMonthNumNum);
                    }
                    masterPlanDetailEntity.setPlanMonthNum(planMonthNum);
                }
                this.masterPlanDetailService.saveOrUpdateBatch(masterPlanDetailEntities);
            }
        }
        this.logger.info("\u56de\u663e\u539f\u8ba1\u5212\u5b50\u8868\u7ed3\u675f\uff01");
        this.monthPlanService.saveOrUpdate((Object)newPlanEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            CommonResponse.success((String)"\u6709\u5ba1\u6279\u6d41\u7a0b\u7684\u53d8\u66f4\u603b\u8ba1\u5212\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        MonthPlanChangeEntity planChange = (MonthPlanChangeEntity)((Object)this.monthPlanChangeService.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"change_plan_id", (Object)billId);
        MonthPlanChangeHisEntity hisEntity = (MonthPlanChangeHisEntity)((Object)this.monthPlanChangeHisService.getOne((Wrapper)hisQuery));
        if (null != hisEntity) {
            MonthPlanEntity newPlanEntity = null;
            MonthPlanEntity oldPlan = (MonthPlanEntity)((Object)this.monthPlanService.selectById(planChange.getSourcePlanId()));
            this.logger.info("\u603b\u8ba1\u5212\u6267\u884c\u5f03\u5ba1\u6570\u636e\u6062\u590d\u903b\u8f91\uff0c\u5f53\u524d\u6570\u636e\u3010{}\u3011\uff0c\u5f85\u6062\u590d\u6570\u636e\u3010{}\u3011", (Object)oldPlan, (Object)hisEntity);
            newPlanEntity = (MonthPlanEntity)((Object)BeanMapper.map((Object)((Object)hisEntity), MonthPlanEntity.class));
            newPlanEntity.setCurChangingPlanId(hisEntity.getChangePlanId());
            newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
            newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
            newPlanEntity.setCreateTime(oldPlan.getCreateTime());
            newPlanEntity.setId(oldPlan.getId());
            newPlanEntity.setVersion(oldPlan.getVersion());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion());
            newPlanEntity.setChangeState(MonthPlanVO.PLAN_CHANGE_STATE_CHANGING);
            newPlanEntity.setTotalPlanAmt(hisEntity.getOriginalPlanAmt());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);
            ArrayList<Long> delDetailIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(planChange.getMonthPlanDetailList())) {
                ArrayList<MonthPlanDetailEntity> list = new ArrayList<MonthPlanDetailEntity>();
                MonthPlanDetailEntity tmp = null;
                Map<Long, Integer> map = oldPlan.getMonthPlanDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                for (MonthPlanChangeDetailEntity detail : planChange.getMonthPlanDetailList()) {
                    tmp = (MonthPlanDetailEntity)((Object)BeanMapper.map((Object)((Object)detail), MonthPlanDetailEntity.class));
                    if (null != detail.getTargetId()) {
                        tmp.setVersion(map.get(detail.getTargetId()));
                        tmp.setId(detail.getTargetId());
                        if (detail.getChangeType().equals("1")) {
                            delDetailIds.add(detail.getId());
                            continue;
                        }
                        list.add(tmp);
                        continue;
                    }
                    delDetailIds.add(detail.getId());
                }
                newPlanEntity.setMonthPlanDetailList(list);
            }
            if (CollectionUtils.isNotEmpty(delDetailIds)) {
                this.monthPlanDetailService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
            }
            this.monthPlanChangeHisService.removeById(hisEntity.getId(), false);
            this.monthPlanService.saveOrUpdate((Object)newPlanEntity, false);
        }
        if (this.monthPlanChangeService.saveOrUpdate((Object)planChange, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success();
    }
}

