/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.mapper.MonthPlanChangeHisMapper;
import com.ejianc.wzxt.plan.mapper.MonthPlanChangeMapper;
import com.ejianc.wzxt.plan.service.IMonthPlanChangeService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.plan.vo.MonthPlanChangeHisVO;
import com.ejianc.wzxt.plan.vo.MonthPlanChangeVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="monthPlanChangeService")
public class MonthPlanChangeServiceImpl
extends BaseServiceImpl<MonthPlanChangeMapper, MonthPlanChangeEntity>
implements IMonthPlanChangeService {
    @Autowired
    private IMonthPlanChangeService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private MonthPlanChangeMapper planChangeMapper;
    @Autowired
    private MonthPlanChangeHisMapper monthPlanChangeHisMapper;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MONTHCHANGEPLAN";
    @Autowired
    private SessionManager sessionManager;

    @Override
    public MonthPlanChangeVO saveOrUpdate(MonthPlanChangeVO planVo) {
        MonthPlanChangeEntity planChangeEntity = this.service.getUnFinishedChange(planVo.getSourcePlanId());
        if (!(null == planChangeEntity || null != planVo.getId() && planChangeEntity.getId().equals(planVo.getId()))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u6750\u6599\u603b\u8ba1\u5212\u53d8\u66f4\u5355\uff01");
        }
        MonthPlanEntity monthPlan = (MonthPlanEntity)((Object)this.monthPlanService.getById(planVo.getSourcePlanId()));
        UserContext userContext = this.sessionManager.getUserContext();
        MonthPlanChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = (MonthPlanChangeEntity)((Object)BeanMapper.map((Object)planVo, MonthPlanChangeEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(monthPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setProjectName(monthPlan.getProjectName());
            saveEntity.setOrgName(monthPlan.getOrgName());
            saveEntity.setOrgId(monthPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (MonthPlanChangeEntity)((Object)this.service.getById(planVo.getId()));
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMonthPlanDetailList(BeanMapper.mapList((Iterable)planVo.getMonthPlanDetailList(), MonthPlanChangeDetailEntity.class));
        }
        List<MonthPlanChangeDetailEntity> beforeDetails = saveEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == saveEntity.getId()) {
            for (MonthPlanChangeDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
            }
        }
        if (planVo.getId() == null || planVo.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)planVo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveEntity.setPlanCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)saveEntity, false);
        MonthPlanEntity planEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(saveEntity.getSourcePlanId()));
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            this.monthPlanService.saveOrUpdate((Object)planEntity, false);
        }
        MonthPlanChangeVO vo = (MonthPlanChangeVO)BeanMapper.map((Object)((Object)saveEntity), MonthPlanChangeVO.class);
        return vo;
    }

    @Override
    public MonthPlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_plan_id", (Object)sourcePlanId);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (MonthPlanChangeEntity)((Object)this.planChangeMapper.selectOne((Wrapper)query));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteChangePlan(List<Long> changeIds) {
        List changeList = this.planChangeMapper.selectBatchIds(changeIds);
        List planIds = changeList.stream().map(MonthPlanChangeEntity::getSourcePlanId).collect(Collectors.toList());
        QueryWrapper planQuery = new QueryWrapper();
        planQuery.in((Object)"id", planIds);
        List planList = this.monthPlanService.list((Wrapper)planQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, source_plan_id as planId"});
        query.in((Object)"source_plan_id", planIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"source_plan_id"});
        List queryResult = this.monthPlanChangeHisMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        Iterator iterator = planList.iterator();
        while (iterator.hasNext()) {
            MonthPlanEntity plan;
            plan.setChangeState(null != hisCountNumMap.get((plan = (MonthPlanEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(plan.getId()) > 0 ? 2 : 0);
            plan.setCurChangingPlanId(null);
        }
        this.monthPlanService.saveOrUpdateBatch(planList, planList.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<MonthPlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MonthPlanChangeEntity::getSourcePlanId, (Object)id);
        lambda.in(MonthPlanChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        List recordVOList = BeanMapper.mapList((Iterable)entities, MonthPlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-0" + recordVO.getChangeVersion());
            } else {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-" + recordVO.getChangeVersion());
            }
            recordVO.setChangeCode(recordVO.getPlanCode());
        });
        return recordVOList;
    }
}

