/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.service.impl;

import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.enums.ChangeTypeEnum;
import com.ejianc.wzxt.plan.mapper.MonthPlanMapper;
import com.ejianc.wzxt.plan.service.IMonthPlanChangeService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.plan.vo.MonthPlanContrastVO;
import com.ejianc.wzxt.plan.vo.MonthPlanDetailVO;
import com.ejianc.wzxt.plan.vo.MonthPlanVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthPlanService")
public class MonthPlanServiceImpl
extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity>
implements IMonthPlanService {
    private static final String BILL_CODE = "MONTHPLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IMonthPlanChangeService monthPlanChangeService;
    @Autowired
    private MonthPlanMapper monthPlanMapper;

    @Override
    public MonthPlanVO saveOrUpdate(MonthPlanVO saveOrUpdateVO) {
        List<MonthPlanDetailEntity> detailEntities;
        MonthPlanEntity entity = (MonthPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MonthPlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setPlanCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null == saveOrUpdateVO.getId()) {
            entity.setId(IdWorker.getId());
            entity.setChangeState(0);
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setChangeVersion(1);
        }
        if (CollectionUtils.isNotEmpty(detailEntities = entity.getMonthPlanDetailList())) {
            for (MonthPlanDetailEntity monthPlanDetailEntity : detailEntities) {
                monthPlanDetailEntity.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        super.saveOrUpdate((Object)entity, false);
        MonthPlanVO vo = (MonthPlanVO)BeanMapper.map((Object)((Object)entity), MonthPlanVO.class);
        return vo;
    }

    @Override
    public MonthPlanVO queryDetail(Long id) {
        MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)super.selectById((Serializable)id));
        MonthPlanVO monthPlanVO = (MonthPlanVO)BeanMapper.map((Object)((Object)monthPlanEntity), MonthPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMonthPlanId", new Parameter("eq", (Object)id));
        List detailEntityListDb = this.monthPlanDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62\u9879.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (MonthPlanDetailEntity cdEntity : detailEntityList) {
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, MonthPlanDetailVO.class);
            monthPlanVO.setMonthPlanDetailList(resultMapList);
        } else {
            monthPlanVO.setMonthPlanDetailList(BeanMapper.mapList(detailEntityList, MonthPlanDetailVO.class));
        }
        if (null != monthPlanEntity.getChangeVersion() && monthPlanEntity.getChangeVersion() > 0) {
            monthPlanVO.setMonthPlanChangeHisList(this.monthPlanChangeService.queryDetailRecord(monthPlanEntity.getId()));
        }
        return monthPlanVO;
    }

    @Override
    public List<MonthPlanContrastVO> getContrastInfo(Long materialMonthPlanId, Long oldMaterialMonthPlanId) {
        return this.monthPlanMapper.getContrastInfo(materialMonthPlanId, oldMaterialMonthPlanId);
    }
}

