/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.check.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.wzxt.check.bean.CheckDetailEntity;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.check.service.ICheckDetailService;
import com.ejianc.wzxt.check.service.ICheckService;
import com.ejianc.wzxt.check.vo.CheckVO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/check/"})
public class CheckApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ICheckDetailService checkDetailService;

    @RequestMapping(value={"/queryCheckByDetailId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryCheckByDetailId(@RequestParam(value="detailId") Long detailId) {
        this.logger.info("\u7269\u8d44\u660e\u7ec6id\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)detailId);
        CheckEntity checkEntity = new CheckEntity();
        CheckDetailEntity checkDetailEntity = (CheckDetailEntity)((Object)this.checkDetailService.getById(detailId));
        if (null != checkDetailEntity) {
            checkEntity = (CheckEntity)((Object)this.checkService.selectById(checkDetailEntity.getCheckId()));
        }
        this.logger.info("\u6839\u636e\u7269\u8d44\u660e\u7ec6id \u83b7\u53d6\u9a8c\u6536\u5355\u8be6\u60c5\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)checkEntity)));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class));
    }

    @PostMapping(value={"/countBillNum"})
    public CommonResponse<Map<String, Integer>> countBillNum(@RequestBody JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"projectId")) {
            throw new BusinessException("\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!jsonObject.containsKey((Object)"fillDate")) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.checkService.countBillNum(jsonObject.getLong("projectId"), jsonObject.getDate("fillDate")));
    }

    @RequestMapping(value={"/querycheckListByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CheckVO>> querycheckListByProjectId(@RequestParam(value="projectId") Long projectId) {
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u53c2\u6570\uff1a{} ", (Object)projectId);
        List list = this.checkService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).in((Object)"bill_state", new Object[]{1, 3})).isNull((Object)"contract_id"));
        List checkVOS = BeanMapper.mapList((Iterable)list, CheckVO.class);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)checkVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)checkVOS);
    }
}

