/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.material.api.IMaterialapproachApi;
import com.ejianc.foundation.material.vo.MaterialapproachVO;
import com.ejianc.foundation.material.vo.MaterialapproachdetailVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.wzxt.check.bean.CheckDetailEntity;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.check.bean.CheckWeighEntity;
import com.ejianc.wzxt.check.mapper.CheckMapper;
import com.ejianc.wzxt.check.service.ICheckDetailService;
import com.ejianc.wzxt.check.service.ICheckService;
import com.ejianc.wzxt.check.service.ICheckWeighService;
import com.ejianc.wzxt.check.vo.CheckDetailVO;
import com.ejianc.wzxt.check.vo.CheckVO;
import com.ejianc.wzxt.check.vo.CheckWeighTypeEnum;
import com.ejianc.wzxt.check.vo.CheckWeighVO;
import com.ejianc.wzxt.check.vo.WeighUnitEnum;
import com.ejianc.wzxt.delivery.bean.DeliveryDetailEntity;
import com.ejianc.wzxt.delivery.bean.DeliveryEntity;
import com.ejianc.wzxt.delivery.service.IDeliveryDetailService;
import com.ejianc.wzxt.delivery.service.IDeliveryService;
import com.ejianc.wzxt.delivery.vo.DeliveryTypeEnum;
import com.ejianc.wzxt.enums.BillPushStatusEnum;
import com.ejianc.wzxt.enums.CheckResultEnum;
import com.ejianc.wzxt.enums.CheckTypeEnum;
import com.ejianc.wzxt.op.service.IOpService;
import com.ejianc.wzxt.op.vo.OpDetailVO;
import com.ejianc.wzxt.op.vo.OpVO;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.set.service.ISmallSetService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String PUSH_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/delivery/saveMaterialDeliveryState";
    private static final String BILL_CODE = "ZJKJ-CHECK-CODE";
    private final String OPERATE = "ZJKJ_CHECK_SYNC";
    private static final String BILL_TYPE = "EJCBT202407000006";
    private static final String MONTH_CHECK_CODE = "P-V2lO9s0299";
    private static final String MASTER_CHECK_CODE = "P-OU40050300";
    private static final String SMALL_CHECK_CODE = "P-3yz9CK0301";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOutcontractApi outcontractApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICheckWeighService checkWeighService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private ISmallSetService smallSetService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IMaterialapproachApi materialapproachApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOpService opService;

    @Override
    @Transactional
    public CheckVO saveOrUpdates(CheckVO saveOrUpdateVO) {
        CheckEntity entity;
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (saveOrUpdateVO.getCheckType().equals(CheckTypeEnum.\u96f6\u661f\u6750\u6599\u9a8c\u6536.getCode()) && this.smallSetService.querySetByProj(saveOrUpdateVO.getOrgId()).booleanValue()) {
            if (null == saveOrUpdateVO.getContractId()) {
                throw new BusinessException("\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.savaHintFlag(saveOrUpdateVO);
        }
        if (StringUtils.isEmpty((String)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((String)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
        }
        if ((entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (null == entity.getCheckWeighType()) {
                entity.setCheckWeighType(CheckWeighTypeEnum.\u5426\u78c5\u5355\u9a8c\u6536.getCode());
            }
            if (null == entity.getAutomaticWeigh()) {
                entity.setAutomaticWeigh(1);
            }
        }
        entity.setSignStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
            ArrayList<CheckWeighEntity> checkWeighListDel = new ArrayList<CheckWeighEntity>();
            for (CheckWeighEntity checkWeighEntity : entity.getCheckWeighList()) {
                if (!"del".equals(checkWeighEntity.getRowState())) continue;
                checkWeighListDel.add(checkWeighEntity);
            }
            this.delWeighBill(checkWeighListDel);
        }
        super.saveOrUpdate((Object)entity, false);
        if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
            this.addOrUpdateWeighBill(entity.getCheckDetailList(), entity.getCheckWeighList());
        }
        if (CheckTypeEnum.\u53d1\u8d27\u9a8c\u6536.getCode().equals(entity.getCheckType())) {
            Integer checkStatus = 0;
            DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()));
            LambdaQueryWrapper lambdaCheckDetail = Wrappers.lambdaQuery();
            lambdaCheckDetail.eq(CheckDetailEntity::getSourceId, (Object)entity.getDeliveryId());
            List checkDetailEntityList = this.checkDetailService.list((Wrapper)lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty((Collection)checkDetailEntityList)) {
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getSourceDetailId));
                LambdaQueryWrapper lambdaDeliveryDetail = Wrappers.lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
                List deliveryDetailEntityList = this.deliveryDetailService.list((Wrapper)lambdaDeliveryDetail);
                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null != deliveryDetailEntity.getCheckNum()) continue;
                    deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                }
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
                if (allCheck.booleanValue()) {
                    checkStatus = 2;
                }
                if (anyCheck.booleanValue()) {
                    checkStatus = 1;
                }
                deliveryEntity.setCheckStatus(checkStatus);
                this.deliveryService.updateById((Object)deliveryEntity);
                this.deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
            if (!DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
                CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/zjkj-supbusiness-web/openapi/delivery/saveMaterialDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "ZJKJ_CHECK_SYNC", BILL_TYPE);
                if (!updateSupplierStatus.booleanValue()) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
            }
        }
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return vo;
    }

    private void delWeighBill(List<CheckWeighEntity> checkWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                weighbillVO.setCheckId(checkWeighEntity.getCheckId());
                weighbillVO.setCheckDetailId(checkWeighEntity.getId());
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(0));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u4fdd\u5b58\u5220\u9664\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    private void addOrUpdateWeighBill(List<CheckDetailEntity> checkDetailList, List<CheckWeighEntity> checkWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                if (CollectionUtils.isNotEmpty(checkDetailList)) {
                    for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                        if (null == checkWeighEntity.getDeliveryDetailId() || !checkWeighEntity.getDeliveryDetailId().equals(checkDetailEntity.getSourceDetailId())) continue;
                        weighbillVO.setCheckId(checkDetailEntity.getCheckId());
                        weighbillVO.setCheckDetailId(checkDetailEntity.getId());
                        checkWeighEntity.setCheckDetailId(checkDetailEntity.getId());
                        checkWeighEntity.setCheckStatus(1);
                    }
                }
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(1));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u66f4\u65b0\u9a8c\u6536\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(checkWeighList));
            this.checkWeighService.updateBatchById(checkWeighList);
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    @Transactional
    public void deletes(List<CheckVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        CheckVO checkVO = vos.get(0);
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)checkVO.getId()));
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        List<CheckWeighEntity> checkWeighList = checkEntity.getCheckWeighList();
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(checkEntity.getDeliveryId()));
        if (deliveryEntity != null) {
            List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
            Map checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getSourceDetailId, Function.identity()));
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                if (!checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) continue;
                CheckDetailEntity checkDetailEntity = (CheckDetailEntity)((Object)checkDetailEntityMap.get(deliveryDetailEntity.getId()));
                deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
            }
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
            Integer checkStatus = 0;
            if (allCheck.booleanValue()) {
                checkStatus = 2;
            }
            if (anyCheck.booleanValue()) {
                checkStatus = 1;
            }
            deliveryEntity.setCheckStatus(checkStatus);
            this.deliveryService.updateById((Object)deliveryEntity);
            this.deliveryDetailService.updateBatchById(deliveryDetailList);
            if (!DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
                CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/zjkj-supbusiness-web/openapi/delivery/saveMaterialDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "ZJKJ_CHECK_SYNC", BILL_TYPE);
                if (!updateSupplierStatus.booleanValue()) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
            }
        }
        this.delWeighBill(checkWeighList);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate, String url) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"ZJKJ_CHECK_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "ZJKJ_CHECK_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", datInfo);
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(sourceId, null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)supplierId, (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url, paramMap, supplierId.toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, sourceId, billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{sourceId, supplierId, syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u9a8c\u6536\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)sourceId, (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{sourceId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "ZJKJ_CHECK_SYNC");
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String key = "EJCBT202407000006::" + checkEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"ZJKJ_CHECK_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)checkEntity.getId());
                this.releaseLock(jedis, false, key, "ZJKJ_CHECK_SYNC");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, checkEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            checkEntity.setAttachIds(attchIdsList);
            checkEntity.setSignStatus(1);
            super.saveOrUpdate((Object)checkEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)checkEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "ZJKJ_CHECK_SYNC");
        }
        return msg;
    }

    private String sendMsg(CheckEntity checkEntity, String subject, String content) {
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(checkEntity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    @Override
    public ParamsCheckVO checkParams(CheckVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (CheckTypeEnum.\u81ea\u5236\u9a8c\u6536.getCode().equals(vo.getCheckType())) {
            if (1 == vo.getRecordFlag()) {
                paramsCheckVOS.addAll(this.masterCtrlNum(vo));
            } else {
                paramsCheckVOS.addAll(this.monthCtrlNum(vo));
                paramsCheckVOS.addAll(this.masterCtrlNum(vo));
            }
        } else if (CheckTypeEnum.\u53d1\u8d27\u9a8c\u6536.getCode().equals(vo.getCheckType())) {
            paramsCheckVOS.addAll(this.monthCtrlNum(vo));
            paramsCheckVOS.addAll(this.masterCtrlNum(vo));
        } else if (CheckTypeEnum.\u96f6\u661f\u6750\u6599\u9a8c\u6536.getCode().equals(vo.getCheckType())) {
            paramsCheckVOS.addAll(this.smallCtrlNum(vo));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> monthCtrlNum(CheckVO checkVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MONTH_CHECK_CODE, checkVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6e05\u5355\u91cf\u5927\u4e8e\u6708\u5ea6\u8ba1\u5212\u5269\u4f59\u91cf\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (CheckDetailVO detailVO : checkVO.getCheckDetailList()) {
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        BigDecimal roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        BigDecimal compareNum = ComputeUtil.safeMultiply((BigDecimal)detailVO.getPlanSurplusNum(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getCheckSumNum(), (BigDecimal)compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u91cf\u8d85\u8fc7\u6708\u5ea6\u8ba1\u5212\u5269\u4f59\u91cf");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u91cf\u5927\u4e8e\u6708\u5ea6\u8ba1\u5212\u5269\u4f59\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u6e05\u5355\u7f16\u7801[").append(detailVO.getMaterialCode()).append("]\u7684\u9a8c\u6536\u91cf:").append(detailVO.getCheckSumNum().setScale(3, 4)).append("\uff0c\u6708\u5ea6\u8ba1\u5212\u5269\u4f59\u91cf:").append(compareNum.setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getCheckSumNum(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    private List<ParamsCheckVO> masterCtrlNum(CheckVO checkVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, (Object)checkVO.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.last("limit 1");
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)queryWrapper, false));
        if (null != masterPlanEntity) {
            MasterPlanEntity planEntity = (MasterPlanEntity)((Object)this.masterPlanService.selectById(masterPlanEntity.getId()));
            Map map = planEntity.getMasterPlanDetailList().stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (k1, k2) -> k1));
            CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MASTER_CHECK_CODE, checkVO.getOrgId());
            if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
                List data = (List)billParamByCode.getData();
                this.logger.info("\u6e05\u5355\u91cf\u5927\u4e8e\u603b\u63a7\u8ba1\u5212\u5269\u4f59\u91cf\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
                if (CollectionUtils.isNotEmpty((Collection)data)) {
                    for (CheckDetailVO detailVO : checkVO.getCheckDetailList()) {
                        BigDecimal masterNum = map.containsKey(detailVO.getMaterialId()) ? ((MasterPlanDetailEntity)((Object)map.get(detailVO.getMaterialId()))).getPlanTotalSurplusNum() : BigDecimal.ZERO;
                        for (BillParamVO datum : data) {
                            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                            ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                            BigDecimal roleValue = datum.getRoleValue();
                            paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                            BigDecimal compareNum = ComputeUtil.safeMultiply((BigDecimal)masterNum, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                            if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getCheckSumNum(), (BigDecimal)compareNum)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnItem("\u6e05\u5355\u91cf\u8d85\u8fc7\u603b\u63a7\u8ba1\u5212\u5269\u4f59\u91cf");
                                paramsCheckDsVO.setWarnName("\u6e05\u5355\u91cf\u5927\u4e8e\u603b\u63a7\u8ba1\u5212\u5269\u4f59\u91cf");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u6e05\u5355\u7f16\u7801[").append(detailVO.getMaterialCode()).append("]\u7684\u9a8c\u6536\u91cf:").append(detailVO.getCheckSumNum().setScale(3, 4)).append("\uff0c\u603b\u63a7\u8ba1\u5212\u5269\u4f59\u91cf:").append(compareNum.setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getCheckSumNum(), (BigDecimal)compareNum).setScale(3, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                            paramsCheckVO.setDataSource(checkDsVOS);
                            paramsCheckVOList.add(paramsCheckVO);
                        }
                    }
                }
            } else {
                this.logger.info(billParamByCode.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
        }
        return paramsCheckVOList;
    }

    private List<ParamsCheckVO> smallCtrlNum(CheckVO checkVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(SMALL_CHECK_CODE, checkVO.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6e05\u5355\u91cf\u5927\u4e8e\u96f6\u661f\u8ba1\u5212\u5269\u4f59\u91cf\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (CheckDetailVO detailVO : checkVO.getCheckDetailList()) {
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        BigDecimal roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        BigDecimal compareNum = ComputeUtil.safeMultiply((BigDecimal)detailVO.getPlanSurplusNum(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getCheckSumNum(), (BigDecimal)compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u91cf\u8d85\u8fc7\u96f6\u661f\u8ba1\u5212\u5269\u4f59\u91cf");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u91cf\u5927\u4e8e\u96f6\u661f\u8ba1\u5212\u5269\u4f59\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u6e05\u5355\u7f16\u7801[").append(detailVO.getMaterialCode()).append("]\u7684\u9a8c\u6536\u91cf:").append(detailVO.getCheckSumNum().setScale(3, 4)).append("\uff0c\u96f6\u661f\u8ba1\u5212\u5269\u4f59\u91cf:").append(compareNum.setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getCheckSumNum(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public CheckVO queryDetailWeigh(CheckVO vo) {
        CheckVO checkVO = this.deliveryService.queryDetailToCheck(vo.getDeliveryId());
        this.logger.info("----\u78c5\u5355\u9a8c\u6536\u539f\u6570\u636e \uff1a{}", (Object)JSONObject.toJSONString((Object)checkVO));
        List checkDetailList = checkVO.getCheckDetailList();
        List checkWeighList = vo.getCheckWeighList();
        ArrayList<CheckWeighVO> checkWeighVOS = new ArrayList<CheckWeighVO>();
        if (CollectionUtils.isNotEmpty((Collection)checkWeighList)) {
            List collect = checkWeighList.stream().filter(item -> null != item.getId()).map(item -> item.getId()).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.weighbillApi.queryWeighbills(checkVO.getProjectId(), collect);
            if (!listCommonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u78c5\u5355\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + listCommonResponse.getMsg());
            }
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (WeighbillVO weighbillVO : data) {
                    CheckWeighVO checkWeighVO = (CheckWeighVO)BeanMapper.map((Object)weighbillVO, CheckWeighVO.class);
                    BigDecimal netWeight = weighbillVO.getNetWeight();
                    BigDecimal coefficient = weighbillVO.getCoefficient();
                    String weightUnit = weighbillVO.getWeightUnit();
                    Map<String, BigDecimal> checkNumMap = this.getCheckNum(weightUnit, netWeight, coefficient);
                    checkWeighVO.setCheckNum(checkNumMap.get("checkNum"));
                    checkWeighVO.setDetailNetWeightCoefficient(checkNumMap.get("detailNetWeightCoefficient"));
                    checkWeighVO.setWeightId(weighbillVO.getId());
                    checkWeighVO.setCheckId(null);
                    checkWeighVO.setId(null);
                    checkWeighVO.setWeighMemo(weighbillVO.getMemo());
                    checkWeighVO.setRowState("add");
                    checkWeighVOS.add(checkWeighVO);
                }
                Map<Long, List<CheckWeighVO>> weighMap = checkWeighVOS.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(CheckWeighVO::getDeliveryDetailId));
                if (CollectionUtils.isNotEmpty((Collection)checkDetailList)) {
                    for (CheckDetailVO checkDetailVO : checkDetailList) {
                        List<CheckWeighVO> checkWeighS = weighMap.get(checkDetailVO.getSourceDetailId());
                        if (null != checkWeighS && CollectionUtils.isNotEmpty(checkWeighS)) {
                            BigDecimal checkNum = checkWeighS.stream().map(CheckWeighVO::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal detailNetWeightCoefficient = checkWeighS.stream().map(CheckWeighVO::getDetailNetWeightCoefficient).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal netWeight = checkWeighS.stream().map(CheckWeighVO::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            checkDetailVO.setDetailNetWeight(netWeight);
                            checkDetailVO.setDetailNetWeightCoefficient(detailNetWeightCoefficient);
                            checkDetailVO.setDetailCoefficient(ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)checkNum));
                            checkDetailVO.setCheckNum(checkNum);
                            continue;
                        }
                        checkDetailVO.setDetailNetWeightCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setDetailNetWeight(BigDecimal.ZERO);
                        checkDetailVO.setDetailCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setCheckNum(BigDecimal.ZERO);
                    }
                }
            }
        }
        checkVO.setCheckWeighType(CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode());
        checkVO.setCheckDetailList(checkDetailList);
        checkVO.setCheckWeighList(checkWeighVOS);
        return checkVO;
    }

    public Map<String, BigDecimal> getCheckNum(String weighUnit, BigDecimal netWeight, BigDecimal coefficient) {
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (null == coefficient) {
            coefficient = BigDecimal.ZERO;
        }
        if (null == netWeight) {
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if (StringUtils.isNotEmpty((String)weighUnit)) {
            billStateCode = WeighUnitEnum.getEnumByStateCode((String)weighUnit).getBillStateCode();
        }
        switch (billStateCode) {
            case 0: {
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
                break;
            }
            case 1: {
                detailNetWeightCoefficient = ComputeUtil.safeMultiply((BigDecimal)netWeight, (BigDecimal)new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
            }
        }
        map.put("checkNum", checkNum);
        map.put("detailNetWeightCoefficient", detailNetWeightCoefficient);
        return map;
    }

    @Override
    public Map<String, Integer> countBillNum(Long projectId, Date checkDate) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(CheckEntity::getProjectId, (Object)projectId)).eq(CheckEntity::getCheckDate, (Object)checkDate);
        int checkCount = super.count((Wrapper)lambdaQuery);
        resultMap.put("\u6d88\u8017\u6750", checkCount);
        return resultMap;
    }

    @Override
    public void writeBackPlan(CheckEntity checkEntity, boolean isCommit) {
        if (CheckTypeEnum.\u81ea\u5236\u9a8c\u6536.getCode().equals(checkEntity.getCheckType()) || CheckTypeEnum.\u53d1\u8d27\u9a8c\u6536.getCode().equals(checkEntity.getCheckType())) {
            MasterPlanEntity masterPlanEntity;
            List<MasterPlanDetailEntity> masterPlanDetailList;
            MonthPlanEntity monthPlanEntity;
            List<MonthPlanDetailEntity> monthPlanDetailList;
            List<CheckDetailEntity> detailList = checkEntity.getCheckDetailList();
            if ((null == checkEntity.getRecordFlag() || 1 != checkEntity.getRecordFlag()) && CollectionUtils.isNotEmpty(monthPlanDetailList = (monthPlanEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(detailList.get(0).getMonthPlanId()))).getMonthPlanDetailList())) {
                Map map = monthPlanDetailList.stream().collect(Collectors.toMap(MonthPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
                ArrayList<MonthPlanDetailEntity> list = new ArrayList<MonthPlanDetailEntity>();
                for (CheckDetailEntity detailEntity : detailList) {
                    if (!map.containsKey(detailEntity.getMaterialId())) continue;
                    MonthPlanDetailEntity entity = (MonthPlanDetailEntity)((Object)map.get(detailEntity.getMaterialId()));
                    if (isCommit) {
                        entity.setCheckNum(ComputeUtil.safeAdd((BigDecimal)entity.getCheckNum(), (BigDecimal)detailEntity.getCheckNum()));
                    } else {
                        entity.setCheckNum(ComputeUtil.safeSub((BigDecimal)entity.getCheckNum(), (BigDecimal)detailEntity.getCheckNum()));
                    }
                    list.add(entity);
                }
                if (CollectionUtils.isNotEmpty(list)) {
                    this.monthPlanDetailService.saveOrUpdateBatch(list);
                }
            }
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(MasterPlanEntity::getProjectId, (Object)checkEntity.getProjectId());
            queryWrapper.in(MasterPlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            MasterPlanEntity planEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)queryWrapper, false));
            if (null != planEntity && CollectionUtils.isNotEmpty(masterPlanDetailList = (masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.selectById(planEntity.getId()))).getMasterPlanDetailList())) {
                Map map = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
                ArrayList<MasterPlanDetailEntity> list = new ArrayList<MasterPlanDetailEntity>();
                for (CheckDetailEntity detailEntity : detailList) {
                    if (!map.containsKey(detailEntity.getMaterialId())) continue;
                    MasterPlanDetailEntity entity = (MasterPlanDetailEntity)((Object)map.get(detailEntity.getMaterialId()));
                    if (isCommit) {
                        entity.setCheckNum(ComputeUtil.safeAdd((BigDecimal)entity.getCheckNum(), (BigDecimal)detailEntity.getCheckNum()));
                    } else {
                        entity.setCheckNum(ComputeUtil.safeSub((BigDecimal)entity.getCheckNum(), (BigDecimal)detailEntity.getCheckNum()));
                    }
                    list.add(entity);
                }
                if (CollectionUtils.isNotEmpty(list)) {
                    this.masterPlanDetailService.saveOrUpdateBatch(list);
                }
            }
        }
    }

    @Override
    public void pushMaterial(CheckEntity checkEntity) {
        UserContext userContext = this.sessionManager.getUserContext();
        MaterialapproachVO vo = new MaterialapproachVO();
        vo.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        vo.setApproveTime(new Date());
        vo.setAgentId(userContext.getEmployeeId());
        vo.setAgentName(userContext.getEmployeeName());
        vo.setAgentdepId(userContext.getDeptId());
        vo.setAgentdepName(userContext.getDeptName());
        vo.setBillTime(new Date());
        vo.setOrgId(checkEntity.getParentOrgId());
        vo.setOrgName(checkEntity.getParentOrgName());
        vo.setProjectDepartmentId(checkEntity.getOrgId());
        vo.setContractId(checkEntity.getContractId());
        vo.setContractCode(checkEntity.getContractCode());
        vo.setContractName(checkEntity.getContractName());
        vo.setProjectId(checkEntity.getProjectId());
        vo.setProjectName(checkEntity.getProjectName());
        vo.setSupplierId(checkEntity.getSupplierId());
        vo.setSupplierName(checkEntity.getSupplierName());
        vo.setEnterTime(new Date());
        vo.setVerificationTime(new Date());
        vo.setSubcontractorId(checkEntity.getSubContractId());
        vo.setSubcontractorName(checkEntity.getSubContractName());
        vo.setContractType(Integer.valueOf(0));
        vo.setUseFlag(Integer.valueOf(0));
        vo.setCheckType(checkEntity.getCheckType());
        vo.setSourceId(checkEntity.getId());
        ArrayList<MaterialapproachdetailVO> detailList = new ArrayList<MaterialapproachdetailVO>();
        for (CheckDetailEntity detailEntity : checkEntity.getCheckDetailList()) {
            MaterialapproachdetailVO detailVO = new MaterialapproachdetailVO();
            detailVO.setMaterialId(detailEntity.getMaterialId());
            detailVO.setMaterialCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setSpec(detailEntity.getSpec());
            detailVO.setUnit(detailEntity.getUnit());
            detailVO.setMaterialClassId(detailEntity.getMaterialTypeId());
            detailVO.setMaterialClassName(detailEntity.getMaterialTypeName());
            detailVO.setEnterCount(detailEntity.getCheckNum());
            detailVO.setCode(detailEntity.getQualityCode());
            detailVO.setConclusion(CheckResultEnum.getEnumByResultCode(detailEntity.getCheckResult()).getDescription());
            detailVO.setProjectId(vo.getProjectId());
            detailVO.setProjectName(vo.getProjectName());
            detailList.add(detailVO);
        }
        vo.setMaterialapproachdetailEntities(detailList);
        this.materialapproachApi.push(vo);
    }

    @Override
    public OpVO pushOp(Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.selectById(id));
        OpVO applyVO = new OpVO();
        applyVO.setProjectId(entity.getProjectId());
        applyVO.setProjectName(entity.getProjectName());
        applyVO.setOrgId(entity.getOrgId());
        applyVO.setOrgName(entity.getOrgName());
        applyVO.setParentOrgId(entity.getParentOrgId());
        applyVO.setApplyDept(entity.getSupplierName());
        applyVO.setOutDate(new Date());
        applyVO.setCarNumber(entity.getLicensePlate());
        applyVO.setOutType(Integer.valueOf(2));
        applyVO.setSourceBillCode(entity.getBillCode());
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        applyVO.setLinkUrlPc(frontendBaseHost + "zjkj-wzxt-frontend/#/check/card?link=true&id=" + entity.getId());
        applyVO.setLinkUrlMobile(frontendBaseHost + "zjkj-wzxt-mobile/#/check/card?link=true&id=" + entity.getId());
        ArrayList<OpDetailVO> detailList = new ArrayList<OpDetailVO>();
        ArrayList<String> list = new ArrayList<String>();
        for (CheckDetailEntity detailEntity : entity.getCheckDetailList()) {
            OpDetailVO detailVO = new OpDetailVO();
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setSpec(detailEntity.getSpec());
            detailVO.setUnit(detailEntity.getUnit());
            detailVO.setNum(ComputeUtil.safeSub((BigDecimal)detailEntity.getDeliverNum(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)detailEntity.getCheckSumNum(), (BigDecimal)detailEntity.getCheckNum())));
            detailVO.setSourceId(detailEntity.getId());
            detailList.add(detailVO);
            list.add(detailEntity.getMaterialName());
        }
        applyVO.setSourceId(String.valueOf(entity.getId()));
        applyVO.setSourceType(BILL_TYPE);
        applyVO.setSourceTypeName("\u9a8c\u6536\u5355");
        applyVO.setSourceBussType("sceneImgs");
        applyVO.setDetailList(detailList);
        applyVO.setMaterialName(StringUtils.join(list, (String)","));
        return this.opService.push(applyVO);
    }

    private void savaHintFlag(CheckVO checkVO) {
        ArrayList<String> errList = new ArrayList<String>();
        CommonResponse response = this.outcontractApi.queryDetail(checkVO.getContractId());
        if (response.isSuccess() && null != response.getData() && CollectionUtils.isNotEmpty((Collection)checkVO.getCheckDetailList())) {
            Map<Long, OutcontractMaterialVO> detailVOMap = ((OutcontractVO)response.getData()).getOutcontractMaterialList().stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(OutcontractMaterialVO::getMaterialId, item -> item, (v1, v2) -> v2));
            for (CheckDetailVO detailVO : checkVO.getCheckDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVOMap.containsKey(detailVO.getMaterialId())) continue;
                errList.add(detailVO.getMaterialCode());
            }
        }
        if (CollectionUtils.isNotEmpty(errList)) {
            throw new BusinessException("\u6750\u6599\u7f16\u7801[" + org.apache.commons.lang3.StringUtils.join(errList, (String)",") + "]\u4e0d\u5728\u91c7\u8d2d\u5408\u540c\u8303\u56f4\u5185\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u6e05\u5355!");
        }
    }
}

