/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.wagon.api.IWagonMaterialApi;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.WeighApplyThirdVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.wzxt.delivery.bean.WeighApplyEntity;
import com.ejianc.wzxt.delivery.mapper.WeighApplyMapper;
import com.ejianc.wzxt.delivery.service.IWeighApplyService;
import com.ejianc.wzxt.delivery.vo.WeighApplyVO;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weighApplyService")
public class WeighApplyServiceImpl
extends BaseServiceImpl<WeighApplyMapper, WeighApplyEntity>
implements IWeighApplyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushThirdDataApi pushThirdDataApi;
    @Autowired
    private IWagonMaterialApi wagonMaterialApi;

    @Override
    public WeighApplyVO saveOrUpdate(WeighApplyVO saveOrUpdateVO) {
        CommonResponse response;
        if (saveOrUpdateVO.getPcCarInfoFlag().booleanValue() && (response = this.wagonMaterialApi.queryMaterialAutomaticWeigh(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getMaterialId())).isSuccess() && null != response.getData()) {
            WagonMaterialVO materialVO = (WagonMaterialVO)response.getData();
            saveOrUpdateVO.setMaterialAmount(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)saveOrUpdateVO.getMaterialAmount(), (BigDecimal)materialVO.getScaleFactor()), (BigDecimal)BigDecimal.valueOf(100L)));
        }
        WeighApplyEntity entity = (WeighApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WeighApplyEntity.class));
        this.saveOrUpdate((Object)entity, false);
        WeighApplyVO vo = (WeighApplyVO)BeanMapper.map((Object)((Object)entity), WeighApplyVO.class);
        WeighApplyThirdVO thirdVO = (WeighApplyThirdVO)BeanMapper.map((Object)((Object)entity), WeighApplyThirdVO.class);
        this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
        CommonResponse thirdRes = this.pushThirdDataApi.pushApplyToThird(thirdVO);
        if (!thirdRes.isSuccess()) {
            this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
        } else {
            this.logger.info("\u6d88\u8017\u6750\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
            entity.setTicketId((String)thirdRes.getData());
        }
        super.updateById((Object)entity);
        return vo;
    }
}

