/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.op.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.op.bean.OpEntity;
import com.ejianc.wzxt.op.mapper.OpMapper;
import com.ejianc.wzxt.op.service.IOpService;
import com.ejianc.wzxt.op.vo.OpVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="opService")
public class OpServiceImpl
extends BaseServiceImpl<OpMapper, OpEntity>
implements IOpService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_CODE = "ZJKJ-OP";

    @Override
    public OpVO push(OpVO opVO) {
        this.logger.error("apply push is " + JSONObject.toJSONString((Object)opVO));
        if (StringUtils.isBlank((CharSequence)opVO.getLinkUrlPc())) {
            throw new BusinessException("PC\u8054\u67e5\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)opVO.getLinkUrlMobile())) {
            throw new BusinessException("\u79fb\u52a8\u7aef\u8054\u67e5\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)opVO.getSourceId())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)opVO.getSourceType())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)opVO.getSourceType())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OpEntity entity = (OpEntity)((Object)BeanMapper.map((Object)opVO, OpEntity.class));
        entity.setId(IdWorker.getId());
        entity.setCarNumber(StringUtils.trimToNull((String)entity.getCarNumber()));
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38,\u7f16\u7801\u751f\u6210\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setBillCode((String)billCode.getData());
        UserContext context = this.sessionManager.getUserContext();
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setApplyUser(context.getUserName());
        entity.setEmployeeId(context.getEmployeeId());
        entity.setEmployeeName(context.getEmployeeName());
        if (StringUtils.isNotBlank((CharSequence)opVO.getSourceBussType())) {
            if (opVO.getSourceId().indexOf("@") > 0) {
                for (String sourceId : opVO.getSourceId().split("@")) {
                    this.attachmentApi.copyFilesFromSourceBillToTargetBill(sourceId, opVO.getSourceType(), opVO.getSourceBussType(), String.valueOf(entity.getId()), "EJCBT202408000010", "siteImg");
                }
            } else {
                this.attachmentApi.copyFilesFromSourceBillToTargetBill(opVO.getSourceId(), opVO.getSourceType(), opVO.getSourceBussType(), String.valueOf(entity.getId()), "EJCBT202408000010", "siteImg");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (OpVO)BeanMapper.map((Object)((Object)entity), OpVO.class);
    }

    @Override
    public OpVO saveOrUpdate(OpVO saveOrUpdateVO) {
        OpEntity entity = (OpEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OpEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        OpVO vo = (OpVO)BeanMapper.map((Object)((Object)entity), OpVO.class);
        return vo;
    }
}

