/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.vo.MasterPlanDetailVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/plan/"})
public class PlanApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;

    @RequestMapping(value={"getMasterByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> getMasterByProjectId(@RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(MasterPlanEntity::getProjectId, (Object)projectId);
        lambdaQueryWrapper.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)lambdaQueryWrapper));
        Map<Object, Object> numMap = new HashMap();
        if (masterPlanEntity != null) {
            Long id = masterPlanEntity.getId();
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(MasterPlanDetailEntity::getMaterialMasterPlanId, (Object)id);
            List masterPlanDetailEntities = this.masterPlanDetailService.list((Wrapper)lambdaQuery);
            if (CollectionUtils.isNotEmpty((Collection)masterPlanDetailEntities)) {
                numMap = masterPlanDetailEntities.stream().collect(Collectors.groupingBy(MasterPlanDetailEntity::getMaterialCategoryId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanTotalNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", numMap);
    }

    @RequestMapping(value={"getMasterDetailByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<Long, MasterPlanDetailVO>> getMasterDetailByProjectId(@RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(MasterPlanEntity::getProjectId, (Object)projectId);
        lambdaQueryWrapper.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)lambdaQueryWrapper));
        Map<Object, Object> numMap = new HashMap();
        if (masterPlanEntity != null) {
            Long id = masterPlanEntity.getId();
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(MasterPlanDetailEntity::getMaterialMasterPlanId, (Object)id);
            List masterPlanDetailEntities = this.masterPlanDetailService.list((Wrapper)lambdaQuery);
            if (CollectionUtils.isNotEmpty((Collection)masterPlanDetailEntities)) {
                List list = BeanMapper.mapList((Iterable)masterPlanDetailEntities, MasterPlanDetailVO.class);
                numMap = list.stream().collect(Collectors.toMap(MasterPlanDetailVO::getMaterialId, Function.identity(), (key1, key2) -> key1));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", numMap);
    }
}

