/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.service.impl;

import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.enums.ChangeTypeEnum;
import com.ejianc.wzxt.plan.mapper.MasterPlanMapper;
import com.ejianc.wzxt.plan.service.IMasterPlanChangeService;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.vo.MasterPlanContrastVO;
import com.ejianc.wzxt.plan.vo.MasterPlanDetailVO;
import com.ejianc.wzxt.plan.vo.MasterPlanVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="masterPlanService")
public class MasterPlanServiceImpl
extends BaseServiceImpl<MasterPlanMapper, MasterPlanEntity>
implements IMasterPlanService {
    private static final String BILL_CODE = "ZJKJ_MASTER_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IMasterPlanChangeService masterPlanChangeService;
    @Autowired
    private MasterPlanMapper masterPlanMapper;

    @Override
    public MasterPlanVO saveOrUpdate(MasterPlanVO saveOrUpdateVO) {
        List<MasterPlanDetailEntity> detailEntities;
        MasterPlanEntity entity = (MasterPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MasterPlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setPlanCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null == saveOrUpdateVO.getId()) {
            entity.setId(IdWorker.getId());
            entity.setChangeState(0);
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setChangeVersion(1);
        }
        if (CollectionUtils.isNotEmpty(detailEntities = entity.getMasterPlanDetailList())) {
            for (MasterPlanDetailEntity masterPlanDetailEntity : detailEntities) {
                masterPlanDetailEntity.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        super.saveOrUpdate((Object)entity, false);
        MasterPlanVO vo = (MasterPlanVO)BeanMapper.map((Object)((Object)entity), MasterPlanVO.class);
        return vo;
    }

    @Override
    public MasterPlanVO queryDetail(Long id) {
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)super.selectById((Serializable)id));
        MasterPlanVO masterPlanVO = (MasterPlanVO)BeanMapper.map((Object)((Object)masterPlanEntity), MasterPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter("eq", (Object)id));
        List detailEntityListDb = this.masterPlanDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62\u9879.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (MasterPlanDetailEntity cdEntity : detailEntityList) {
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class);
            masterPlanVO.setMasterPlanDetailList(resultMapList);
        } else {
            masterPlanVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class));
        }
        if (null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0) {
            masterPlanVO.setMasterPlanChangeHisList(this.masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }
        return masterPlanVO;
    }

    @Override
    public List<MasterPlanContrastVO> getContrastInfo(Long materialMasterPlanId, Long oldMaterialMasterPlanId) {
        return this.masterPlanMapper.getContrastInfo(materialMasterPlanId, oldMaterialMasterPlanId);
    }
}

