/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.wzxt.plan.bean.MaterialPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMaterialPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="materialPlan")
public class MaterialPlanBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMasterPlanService service;
    @Autowired
    private IMonthPlanService monthPlanService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPlanService materialPlanService;
    private final String PUSH_DELETE_URL = "/zjkj-supbusiness-web/openapi/materialPlan/delSupPLan";
    private final String OPERATE = "ZJKJ_MATERIAL_PLAN_SYNC";
    private static final String BILL_TYPE = "EJCBT202407000006";
    @Autowired
    private IProSupplierApi proSupplierApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialPlanEntity materialPlanEntity = (MaterialPlanEntity)((Object)this.materialPlanService.selectById(billId));
        this.materialPlanService.pushBillToSupCenter(materialPlanEntity, billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialPlanEntity materialPlanEntity = (MaterialPlanEntity)((Object)this.materialPlanService.selectById(billId));
        if (materialPlanEntity.getSignStatus() == 2) {
            return CommonResponse.error((String)"\u5df2\u7b7e\u5b57,\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialPlanEntity materialPlanEntity = (MaterialPlanEntity)((Object)this.materialPlanService.selectById(billId));
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", billId);
        map.put("systemId", ejcCloudSystemCode.getData());
        String dataInfo = JSONObject.toJSONString(map);
        Boolean updateSupplierStatus = this.materialPlanService.delSupPLan(billId, dataInfo, "/zjkj-supbusiness-web/openapi/materialPlan/delSupPLan", RequestMethod.POST, materialPlanEntity.getSupplierId().toString(), "ZJKJ_MATERIAL_PLAN_SYNC", BILL_TYPE);
        if (!updateSupplierStatus.booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }
}

